//初始化单元格事件
function initCellEvents() {

    let colors = [
        ["rgb(0, 0, 0)", "rgb(67, 67, 67)", "rgb(102, 102, 102)", "rgb(204, 204, 204)", "rgb(217, 217, 217)", "rgb(255, 255, 255)"],
        ["rgb(152, 0, 0)", "rgb(255, 0, 0)", "rgb(255, 153, 0)", "rgb(255, 255, 0)", "rgb(0, 255, 0)", "rgb(0, 255, 255)", "rgb(74, 134, 232)", "rgb(0, 0, 255)", "rgb(153, 0, 255)", "rgb(255, 0, 255)"],
        ["rgb(230, 184, 175)", "rgb(244, 204, 204)", "rgb(252, 229, 205)", "rgb(255, 242, 204)", "rgb(217, 234, 211)", "rgb(208, 224, 227)", "rgb(201, 218, 248)", "rgb(207, 226, 243)", "rgb(217, 210, 233)", "rgb(234, 209, 220)", "rgb(221, 126, 107)", "rgb(234, 153, 153)", "rgb(249, 203, 156)", "rgb(255, 229, 153)", "rgb(182, 215, 168)",
            "rgb(162, 196, 201)", "rgb(164, 194, 244)", "rgb(159, 197, 232)", "rgb(180, 167, 214)", "rgb(213, 166, 189)", "rgb(204, 65, 37)", "rgb(224, 102, 102)", "rgb(246, 178, 107)", "rgb(255, 217, 102)", "rgb(147, 196, 125)",
            "rgb(118, 165, 175)", "rgb(109, 158, 235)", "rgb(111, 168, 220)", "rgb(142, 124, 195)", "rgb(194, 123, 160)", "rgb(166, 28, 0)", "rgb(204, 0, 0)", "rgb(230, 145, 56)", "rgb(241, 194, 50)", "rgb(106, 168, 79)",
            "rgb(69, 129, 142)", "rgb(60, 120, 216)", "rgb(61, 133, 198)", "rgb(103, 78, 167)", "rgb(166, 77, 121)", "rgb(91, 15, 0)", "rgb(102, 0, 0)", "rgb(120, 63, 4)", "rgb(127, 96, 0)", "rgb(39, 78, 19)", "rgb(12, 52, 61)", "rgb(28, 69, 135)", "rgb(7, 55, 99)", "rgb(32, 18, 77)", "rgb(76, 17, 48)"]
    ];
    //颜色插件配置
    let colorOpt = {
        allowEmpty: true, showInput: true, containerClassName: "full-spectrum", showInitial: true, showPalette: true,
        showSelectionPalette: true, showAlpha: true, maxPaletteSize: 10, preferredFormat: "hex",
        change: function (color) {
            let hexColor = "transparent";
            if (color) {
                hexColor = color.toHexString();
                //changeLineColor($(this), hexColor, true, color);
                $(this).find('#lineColorDiv').css("background-color", hexColor);
                $(this).find('#lineColorText').text(hexColor);
            }
        },
        beforeShow: function () {
            //MainEditor.setCurSpreadSheetEnabled(0);
            let co = '';
            let id = $(this).attr('id');
            if ('chartColor' == id || 'linecolor' == id || 'linecolor1' == id || 'bkcolor' == id || 'bkcolor1' == id || 'bkcolor2' == id || 'color' == id || 'color1' == id) {
                co = $(this).css('background-color');
            } else {
                co = $(this).css('border-bottom-color');
            }
            if (co) {
                $(this).spectrum('set', co);
            }
        },
        hide: function () {
            $("#mask").hide();
        },
        palette: colors
    };
    /**
     * 数据设置
     * **/
    $('#cellds').dropdown({
        onChange: function (value, text, $selectedItem) {
            let dsName = canvasEvent.Cell.getDSName(); //数据集名称
            if (dsName == value) {
                return false;
            }
            let dataArray = [];
            let val = value;
            let defaultColumn;
            if (val == "") {//未选中ds时
                canvasEvent.Cell.setDSName(val);
            } else {
                canvasEvent.Cell.setDSName(val);
                let templateIndex = canvasEvent.Template.getCurrentSpreadSheetIndex(); // 获取当前模板的索引值
                let key = templateIndex + '@#' + val; //键
                let columns = dsMap[key]; //获取ds对应的列
                $.each(columns, function (i, e) {
                    let dataObj = {};
                    dataObj.name = e;
                    dataObj.value = e;
                    dataArray.push(dataObj);
                    if (i == 0) { //默认选中第一个字段
                        defaultColumn = e;
                        canvasEvent.Cell.setFieldName(e);
                    }
                })
            }
            $('#dscol').dropdown('setup menu', {values: dataArray});
            $('#dscol').parent().removeClass('disabled');
            /* manualChange($('#dscol') , defaultColumn , defaultColumn)*/
            $('#dscol').dropdown('set selected', defaultColumn);
        }
    });
    //字段列选择事件
    $('#dscol').dropdown({
        onChange: function (value, text, $selectedItem) {
            let fieldName = canvasEvent.Cell.getFieldName();
            if (fieldName == value) {
                return false;
            }
            canvasEvent.Cell.setFieldName(value);
        }
    });
    //数据类型选择事件
    $('#dstype').dropdown({
        onChange: function (value, text, $selectedItem) {
            let dstype = canvasEvent.Cell.getFieldDataType();
            if (dstype != value) {
                canvasEvent.Cell.setFieldDataType(value);
            }
        }
    });
    //数据设置选择事件
    $('#attri').dropdown({
        onChange: function (value, text, $selectedItem) {
            let dataAttribution = canvasEvent.Cell.getDataAttribution(); //获取数据设置
            if (dataAttribution == 0 && value == "") { //未设置数据设置,进行clear操作
                return false;
            } else if (dataAttribution == 0 && value != "") { //change Type
                canvasEvent.Cell.setDataAttribution(parseInt(value));
                if (value == 3) { //汇总
                    $('#statistics').dropdown('setting', 'useLabels', true)
                        .removeClass('disabled');
                } else {
                    $('#statistics').dropdown('setting', 'useLabels', false)
                        .addClass('disabled');
                }
            } else { // set value
                if (dataAttribution == value) {
                    return false;
                }
                canvasEvent.Cell.setDataAttribution(value);
                if (value == 3) { //汇总
                    $('#statistics').dropdown('setting', 'useLabels', true)
                        .removeClass('disabled');
                } else {
                    $('#statistics').dropdown('setting', 'useLabels', false)
                        .addClass('disabled');
                }
            }
        }
    });
    //汇总方式
    $('#statistics').dropdown({
        onChange: function (value, text, $selectedItem) {
            let dataAttribution = canvasEvent.Cell.getDataAttribution();
            if (dataAttribution == 3) { //单元格为汇总
                let type = canvasEvent.Cell.getDataStatisticsType();
                if (type != value) { //change
                    let val = value;
                    val = parseInt(val);
                    canvasEvent.Cell.setDataStatisticsType(val);
                }
            }
        }
    });
    /**
     * 数据字典
     * **/
    $('#d_dict').unbind().bind("change", function () {
        let checked = $(this).prop("checked"); //是否选中
        if (checked) { //选中
            $('#d_ds').dropdown('setting', 'useLabels', true)
                .removeClass('disabled');
            manualClear($('#d_ds'));
            $('#d_ds').dropdown('clear');
            $('#d_af').dropdown('setting', 'useLabels', true)
                .removeClass('disabled');
            $('#d_sf').dropdown('setting', 'useLabels', true)
                .removeClass('disabled');
        } else {
            $('#d_ds').dropdown('setting', 'useLabels', true)
                .addClass('disabled');
            manualClear($('#d_ds'));
            $('#d_af').dropdown('setting', 'useLabels', true)
                .addClass('disabled');
            manualClear($('#d_af'));
            $('#d_sf').dropdown('setting', 'useLabels', true)
                .addClass('disabled');
            manualClear($('#d_sf'));
            canvasEvent.Cell.setDataDict();
        }
    })
    //数据字典ds
    $('#d_ds').dropdown({
        onChange: function (value, text, $selectedItem) {
            if(value == ''){
                return;
            }
            let dsName = value;
            canvasEvent.Cell.setDataDictDsName(dsName);
            let templateIndex = canvasEvent.Template.getCurrentSpreadSheetIndex();
            let key = templateIndex + '@#' + dsName;
            let columns = dsMap[key];

            $('#d_af').empty();
            $('#d_sf').empty();
            $('#d_af').append("<option></option>");
            $('#d_sf').append("<option></option>");
            $.each(columns, function (i, e) {
                $('#d_af').append("<option value='" + e + "'>" + e + "</option>");
                $('#d_sf').append("<option value='" + e + "'>" + e + "</option>");
            })
        }
    });
    $('#d_af').dropdown({
        onChange: function (value, text, $selectedItem) {
            let actualField = value;
            canvasEvent.Cell.setActualFieldName(actualField);
        }
    });
    //实际显示列
    $('#d_sf').dropdown({
        onChange: function (value, text, $selectedItem) {
            let showField = value;
            canvasEvent.Cell.setShowFieldName(showField);
        }
    });
    /**
     * 扩展
     * **/
    $('#kzfx').dropdown({
        onChange: function (value, text, $selectedItem) {
            let expandOri = canvasEvent.Cell.getExpandOri();
            if (expandOri != value) {
                let kzfx = value;
                canvasEvent.Cell.setExpandOri(parseInt(kzfx));
            }
        }
    });
    //左父格
    $('#zfg').dropdown({
        onChange: function (value, text, $selectedItem) {
            let leftParentCellType = canvasEvent.Cell.getLeftParentCellType();
            if (leftParentCellType != value) {
                canvasEvent.Cell.setLeftParentCellType(parseInt(value));
                if (value == 2) { //自定义
                    $('#zfgS').removeClass('ef-hidden');
                } else {
                    $('#zfgS').addClass('ef-hidden');
                }
            }
        }
    })

    $("#zfgBtn").click(function () {
        canvasEvent.Cell.setLeftParentCellFrame();
    });

    $("#zfgA").unbind().bind('keyup', function () {
        canvasEvent.Cell.setLeftParentCell($(this).val(), $("#zfg1").val());
    });

    $("#zfg1").unbind().bind('keyup', function () {
        canvasEvent.Cell.setLeftParentCell($("#zfgA").val(), $(this).val());
    });

    //上父格
    $('#sfg').dropdown({
        onChange: function (value, text, $selectedItem) {
            let topParentCellType = canvasEvent.Cell.getTopParentCellType();
            if (topParentCellType == value) {
                return false;
            }
            canvasEvent.Cell.setTopParentCellType(parseInt(value));
            if (value == 2) { //自定义
                $('#sfgS').removeClass('ef-hidden');
            } else {
                $('#sfgS').addClass('ef-hidden');
            }
        }
    })

    //上父格单元格选择按钮
    $("#sfgBtn").click(function () {
        canvasEvent.Cell.setTopParentCellFrame();
    });

    $("#sfgA").unbind().bind('keyup', function () {
        canvasEvent.Cell.setTopParentCell($(this).val(), $("#sfg1").val());
    });

    $("#sfg1").unbind().bind('keyup', function () {
        canvasEvent.Cell.setTopParentCell($("#sfgA").val(), $(this).val());
    });

    /**
     * 字段分页补齐
     * */

    $('#pagingFieldRowCount').unbind().bind('change' , function(){
        canvasEvent.Cell.setSelCellPagingFieldRowCount($(this).val());
    })



    //字段分页
    $('#fg').unbind().bind("change", function () {
        let checked = $(this).prop("checked"); //是否选中
        canvasEvent.Cell.setFieldPaging(checked);
    })

    //行后分页
    $('#far').unbind().bind("change", function () {
        let checked = $(this).prop("checked"); //是否选中
        canvasEvent.Cell.setPagingAfterRow(checked);
    })

    //每页补齐行
    $('#crfs').unbind().bind("change", function () {
        let checked = $(this).prop("checked"); //是否选中
        canvasEvent.Cell.setCompleteRowForEveryPage(checked);
    })

    //尾页补齐行
    $('#crfl').unbind().bind("change", function () {
        let checked = $(this).prop("checked"); //是否选中
        canvasEvent.Cell.setCompleteRowForLastPage(checked);
    })


    $('#minr').unbind().bind("change", function () {
        let val = $(this).val();
        try {
            val = parseInt(val);
            let g = /^[1-9]*[1-9][0-9]*$/;
            if (!g.test(val)) {
                if (val == -1 || val == 0) {
                    canvasEvent.Cell.setMinRecordCount(val);
                } else {
                    $(this).val('');
                }
            } else {
                $(this).val(val);
                canvasEvent.Cell.setMinRecordCount($(this).val());
            }

        } catch (err) {
            $(this).val('');
        }
    })

    /**
     * 图片字段
     * */
    $('#imageField').unbind().bind("change", function () {
        let checked = $(this).prop("checked"); //是否选中
        canvasEvent.Cell.setImageField(checked);
        if (checked) {
            canvasEvent.Cell.setImagePathStr('@{serverImages}');
            $('#imagePathStr').val('@{serverImages}');
            $('#imagePathStr').attr('disabled', false);
            $('#imagePathStr').parent().removeClass('disabled');
        } else {
            $('#imagePathStr').val('');
            $('#imagePathStr').attr('disabled', 'disabled');
        }
    })

    //图片地址
    $('#imagePathStr').unbind().bind("change", function () {
        let val = $(this).val();
        canvasEvent.Cell.setImagePathStr(val);
    })

    /**
     * 伸展设置
     * */

    //横向扩展
    $('#hxkz').unbind().bind('change', function () {
        canvasEvent.Cell.setSelCellExtendH($(this).prop("checked") ? 1 : 0);
    })
    //纵向扩展
    $('#zxkz').unbind().bind('change', function () {
        canvasEvent.Cell.setSelCellExtendV($(this).prop("checked") ? 1 : 0);
    })

    /**
     * 分栏设置
     * */
    //是否分栏
    $('#multi').unbind().bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setSelCellExpandByIsMutliColumn(checked);
        if (checked) {
            $('#cf').attr('disabled', false);
            $('#cf').parent().removeClass('disabled');
            $('#num').attr('disabled', false);
            $('#num').parent().removeClass('disabled');
        } else {
            $('#cf').attr('disabled', true);
            $('#num').attr('disabled', true);
        }
    })
    //先行后列
    $('#cf').unbind().bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setSelCellExpandByIsColumnFirst(checked);
    })
    //分栏数量
    $('#num').unbind().bind("change", function () {
        let val = $(this).val();
        canvasEvent.Cell.setSelCellExpandByColCount(val);
    })
    /**
     * 0值空值
     * */
    //是否显示0值
    $('#showZero').unbind().bind('change', function () {
        canvasEvent.Cell.setSelCellShowZero($(this).prop("checked") ? 1 : 0);
    })
    //空值显示值
    $('#nullConvertValue').unbind().bind('change', function () {
        canvasEvent.Cell.setSelCellNullConvertStr($(this).val());
    })
    /**
     * 折叠
     * */
    //开启折叠
    $('#zd').unbind().bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setRetractSubCellByRetractSubCell(checked);
    })
    //显示最后行
    $('#lasts').unbind().bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setRetractSubCellByShowLastSubCell(checked);
    })

    /**
     *特殊
     * */
    //排序
    $('#px').dropdown({
        onChange: function (value, text, $selectItem) {
            canvasEvent.Cell.setOrderType(parseInt(value));
        }
    });

    //强制允许编辑
    $('#lockCell').unbind().bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setSelCellForceAllowedEdit(checked);
    })
    //拆分并拷贝
    $('#demergeAndCopyCell').bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setSelCellDemergeAndCopyCell(checked);
    })
    //强制分组
    $('#listToGroup').bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setSelCellDataAttrListToGroup(checked);
    })

    //合并扩展单元格
    $('#mergeExpandCellStr').bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setMergeExpandCellStr(checked);
    })

    //强制分组
    $('#autoHiddenComment').bind("change", function () {
        let checked = $(this).prop("checked");
        canvasEvent.Cell.setSelCellCommentHide(checked);
    })


    /
    //隐藏单元格
    $('#hidec').unbind().bind('change', function () {
        canvasEvent.Cell.setSelCellHided($(this).prop("checked") ? 1 : 0);
    })

    $("#cellPosAlign").unbind().bind('change', function () {
        canvasEvent.Cell.setSelCellMoveAlign(parseInt($(this).val()));
    });

    //过滤筛选
    $("#filterExpr").click(function () {
        var index = layer.open({
            type: 2,
            area: ['700px', '550px'],
            closeBtn: 1,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/menus/cellFilter.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var data = iframeWin.getRules();
                data = JSON.parse(data);
                var rules = data.rules;
                var parent = data.parent;
                if (rules.length == 0) {//未设置规则
                    canvasEvent.Cell.setFilterExpr('');
                } else {
                    canvasEvent.Cell.setFilterExpr(JSON.stringify(rules));
                }

                DesignModule._setFilterDependentParent(parent);
                layer.close(index);
            },
            success: function (layero, index) {
                let iframeWin = window[layero.find('iframe')[0]['name']];
                //获取当前单元格上的ds信息
                let dsName = canvasEvent.Cell.getDSName();
                let tmp = canvasEvent.Template.getCurrentSpreadSheetIndex();
                let dsInfo = dsMap[tmp + '@#' + dsName]; //获取ds对应的数据列
                let rules = canvasEvent.Cell.getFilterExpr(); //获取过滤规则
                let parent = canvasEvent.Cell.getFilterDependentParent();
                iframeWin.init(dsInfo, rules, parent);
            }
        });
    });
    //悬浮元素是否可见
    $("#shapeExpr").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:36px;line-height:36px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
                // MainEditor.setCurSpreadSheetEnabled(1);
            },
            yes: function (index, layero) {
                let iframeWin = window[layero.find('iframe')[0]['name']];
                let expr = iframeWin.getExpr();
                if (expr == "") { //没有设置公式
                    canvasEvent.Shape.setSelShapeVisExprStr("");
                } else {
                    if (expr.indexOf('=') != 0) {
                        expr = "=" + expr;
                        // 设置单元格文本
                        canvasEvent.Shape.setSelShapeVisExprStr(expr);
                    } else {
                        canvasEvent.Shape.setSelShapeVisExprStr(expr);
                    }
                }
                layer.close(index);
            },
            success: function (layero, index) {
                // MainEditor.setCurSpreadSheetEnabled(0);
                let iframeWin = window[layero.find('iframe')[0]['name']];
                //获取当前单元格文本
                let val = canvasEvent.Shape.getSelShapeVisExprStr();
                let valArr = val.split('');
                if (valArr[0] == '=') {
                    val = val.replace('=', '');
                }
                iframeWin.setExpr(val);
            }
        });
    });

    initStyleEvent(colorOpt);


    let dict = {};
    //控件信息事件
    $("#ef_control").dropdown({
        onChange: function (value, text, item) { //选择控件类型
            $('#ef-dateTime-div').hide();
            $('#ef-date-div').show();
            $('#filesize').val('');
            let controlInfo = canvasEvent.Cell.getControlInfo();
            if (controlInfo != '') { //存在控件信息
                let ctinfo = JSON.parse(controlInfo);
                let ctype = ctinfo.ControlType;
                if (ctype == value) { //判断是赋值还是主动改变
                    return false;
                }
            } else {
                if (value == 0) {
                    return false;
                }
            }
            let type = value;
            $('.ef-ctrl-div').hide();
            let id = 'controlInfo' + type;
            $('#' + id).show();
            $('#' + id).find('input[type="text"]').val('');
            $('#' + id).find('input[type="checkbox"]').prop('checked', false);
            //设置单元格类型为图片
            if (11 == $(this).val()) {
                DesignModule._setSelCellsType(264);
            }
            canvasEvent.Cell.setControlInfo(''); //清空控件信息
            //canvasEvent.Cell.setSelCellText('');
            if (0 == $(this).val()) {
                $('.ef-ctrl-div').hide();
            } else if (6 == $(this).val()) { //初始化日期时间
                $('#showdate').prop('checked', false);
                $('#dateType').show();
                $('#dateType').dropdown('set selected', '0');
                $('#dateTimeType').hide();
                updateControl();
            } else {
                updateControl();
            }
        }
    });
    $("input[id^='controlName']").keyup(function () {
        updateControl();
    });
    $("input[id^='allowNull']").change(function () {
        updateControl();
    });
    $("input[id^='tip']").keyup(function () {
        updateControl();
    });
    $("input[id^='defaultValue']").keyup(function () { //设置默认值时，填充单元格文本
        canvasEvent.Cell.setSelCellText($(this).val());
        updateControl();
    });
    $("input[id^='affectRow']").change(function () {
        updateControl();
    });
    $("#maxsize").keyup(function () {
        updateControl();
    });
    $("#minsize").keyup(function () {
        updateControl();
    });

    $("#allowDecimal").change(function () {
        updateControl();
    });
    $("#allowNegative").change(function () {
        updateControl();
    });
    $("#maxnum").change(function () {
        if (isNaN($(this).val())) {
            efalert(layer, "该控件只允许输入数字", 2);
            $(this).val('');
            return false;
        }
        updateControl();
    });
    $("#minnum").change(function () {
        if (isNaN($(this).val())) {
            efalert(layer, "该控件只允许输入数字", 2);
            $(this).val('');
            return false;
        }
        updateControl();
    });
    $("#autonum").keyup(function () {
        updateControl();
    });
    //$("#btntext").change(function(){updateControl();});
    $("#btntext").keyup(function () {
        updateControl();
    });

    $("#btntype").dropdown({
        onChange: function (value, text, item) {
            let controlInfo = canvasEvent.Cell.getControlInfo();
            if (controlInfo != '') { //存在控件信息
                let ctinfo = JSON.parse(controlInfo);
                let ctype = ctinfo.ControlType;
                if (9 == ctype) {
                    let buttonType = ctinfo.ButtonType;
                    if (buttonType == value) {
                        return false;
                    }
                }
            }
            if (value == 2) {
                $('#firstCell').hide();
            } else {
                $('#firstCell').show();
            }
            updateControl();
        }
    });
    $("#btntype").parent().css('height', '32.38px');
    $("#dyg1").change(function () {
        updateControl();
    });
    $("#dyg2").change(function () {
        updateControl();
    });

    $("#sdygBtn").click(function () {
        canvasEvent.Cell.setLeftParentCellFrame();
        canvasEvent.Cell.setLeftParentCellType(2);
    });

    $("#cktext").keyup(function () {
        updateControl();
    });
    $("#showdate").change(function () {
        if ($('#showdate').prop('checked')) {
            $('#ef-dateTime-div').show();
            $('#ef-date-div').hide();
        } else {
            $('#ef-dateTime-div').hide();
            $('#ef-date-div').show();
        }
        updateControl();
    });
    $('#dateType').dropdown({
        onChange: function (value, text, item) {
            updateControl();
        }
    })
    $("#dateTimeType").dropdown({
        onChange: function (value, text, item) {
            updateControl();
        }
    });
    //$("#filesize").change(function(){updateControl();});
    $("#filesize").keyup(function () {
        updateControl();
    });
    $("#addButJs").click(function () {
        let index = layer.open({
            type: 2,
            area: ['500px', '500px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['Javascript代码编辑器', 'height:30px;line-height:30px'],
            content: [base + '/design/scriptEdit.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
                MainEditor.setCurSpreadSheetEnabled(1);
            },
            yes: function (index, layero) {
                let iframeWin = window[layero.find('iframe')[0]['name']];
                let expr = iframeWin.getPage();
                $("#addButJs").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                MainEditor.setCurSpreadSheetEnabled(0);
                let iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setVal($("#addButJs").prev().val());
            }
        });
    });
    $('#filetype').dropdown({
        onChange: function (value, text, item) {
            updateControl();
        }
    })
    /*  $("#filetype").change(function () {
          updateControl();
      });*/
    /* $("#showPic").change(function () {
         updateControl();
     });*/


    $("#expr_1").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_1").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_1").prev().val());
            }
        });
    });

    $("#expr_2").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_2").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_2").prev().val());
            }
        });
    });

    $("#expr_3").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_3").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_3").prev().val());
            }
        });
    });

    $("#expr_6").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_6").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_6").prev().val());
            }
        });
    });

    $("#expr_7").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_7").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_7").prev().val());
            }
        });
    });

    $("#expr_8").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_8").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_8").prev().val());
            }
        });
    });

    $("#expr_9").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_9").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_9").prev().val());
            }
        });
    });

    $("#expr_10").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_10").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_10").prev().val());
            }
        });
    });

    $("#expr_11").click(function () {
        var index = layer.open({
            type: 2,
            area: ['900px', '650px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['公式编辑', 'height:30px;line-height:30px'],
            content: ['pages/design/expr.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#expr_11").prev().val(expr);
                updateControl();
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                iframeWin.setExpr($("#expr_11").prev().val());
            }
        });
    });

    $("#init").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(1);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 1) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });

    $("#before").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑前事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(2);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 2) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#after").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(3);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 3) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });


    $("#relateCell").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });

    $("#init_2").click(function () { //下拉框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(5);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                //iframeWin.setExpr($("#expr").prev().val());
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 5) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });


    $("#after_2").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(6);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 6) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });


    $("#relateCell_2").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                console.log(effectCellTexts);
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });


    $("#init_3").click(function () { //多选下拉框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(7);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 7) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });

    $("#after_3").click(function () { //多选下拉框修改函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(8);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 8) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });

    $("#relateCell_3").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });
    $("#init_6").click(function () { //检查框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(14);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 14) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#after_6").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(15);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 15) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#relateCell_6").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {

            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });
    $("#init_7").click(function () { //检查框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(12);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 12) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#after_7").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(13);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 13) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#relateCell_7").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });
    $("#init_8").click(function () { //多选下拉框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(9);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 9) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#before_8").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑前事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(10);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 10) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#after_8").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(11);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 11) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#relateCell_8").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });
    $("#init_9").click(function () { //检查框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(12);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 12) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#after_9").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(13);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 13) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#relateCell_9").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });
    $("#init_10").click(function () { //检查框初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(16);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined || events.length == 0) { //无事件
                    iframeWin.setExpr('function(){\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 16) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#after_10").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['编辑后事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(17);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function(){\n\r\}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 17) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function(){\n\r}');
                        }
                    })
                }
            }
        });
    });
    $("#relateCell_10").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 1,
            maxmin: false,
            resize: false,
            title: ['关联单元格', 'height:30px;line-height:30px'],
            content: ['pages/design/relateCell.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var result = iframeWin.getPage();
                updateControl(result);
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var curCell = $('#dscol').val();
                var json = JSON.parse(controlInfo); //解析controlInfo
                var effectCellTexts = json.EffectCellTexts; //关联数据
                var lis = $('.dsi'); //所有的ds
                var dsMap = {};
                //遍历ds li
                $.each(lis, function (i, e) {
                    var className = $(e).attr('class');
                    var classArray = className.split("_");
                    var dsName = classArray[2]; //ds名
                    var columnsUl = $(e).children('ul'); //列名列表
                    var columnsLi = columnsUl.children('li'); //列名
                    var columns = [];
                    $.each(columnsLi, function (ii, ee) {
                        columns.push($(ee).attr('name'));
                    })
                    dsMap[dsName] = columns;
                });
                iframeWin.init(effectCellTexts, dsMap, curCell);
            }
        });
    });

    $("#click").click(function () { //初始化函数
        var index = layer.open({
            type: 2,
            area: ['800px', '600px'],
            closeBtn: 0,
            maxmin: true,
            resize: false,
            title: ['初始化事件', 'height:30px;line-height:30px'],
            content: ['pages/design/script.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.getExpr();
                $("#eventType").val(4);
                $("#eventCode").val(expr);
                updateControl();
                $("#eventType").val('');
                $("#eventCode").val('');
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo
                var json = JSON.parse(controlInfo); //解析controlInfo
                var events = json.Events; // 事件
                if (events == undefined) {
                    iframeWin.setExpr('function() {\n\r}');
                } else {
                    $.each(events, function (index, element) {
                        if (element.Type == 4) {
                            iframeWin.setExpr(element.Code);
                            return false;
                        } else {
                            iframeWin.setExpr('function() {\n\r}');
                        }
                    })
                }
            }
        });
    });


    $('.dictPage').click(function () {
        var index = layer.open({
            type: 2,
            area: ['600px', '500px'],
            closeBtn: 0,
            resize: false,
            title: ['数据字典', 'height:30px;line-height:30px'],
            content: ['pages/design/dict.html', 'no'],
            btn: ['确定', '关闭'],
            btnAlign: 'c',
            end: function () {
            },
            yes: function (index, layero) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var expr = iframeWin.save();
                var ctype = $('#ef_control').dropdown('get value');
                if (!Util.isNull(expr)) {
                    var dsT = expr.ComboDSType;
                    var con = getBaseControl(ctype);
                    var orgiInfo = JSON.parse(canvasEvent.Cell.getControlInfo()); //原始控件信息
                    con.ComboDSType = dsT;
                    if (dsT == 1) {
                        con.Events = orgiInfo.Events;
                        con.DSName = expr.DSName;
                        con.KeyFieldName = expr.KeyFieldName;
                        con.ShowFieldName = expr.ShowFieldName;
                        con.CustomComboTexts = [];
                    } else if (dsT == 2) {
                        con.Events = orgiInfo.Events;
                        con.DSName = '';
                        con.KeyFieldName = '';
                        con.ShowFieldName = '';
                        con.CustomComboTexts = expr.CustomComboTexts;
                    }
                    if (orgiInfo.EffectCellTexts != undefined) {
                        con.EffectCellTexts = orgiInfo.EffectCellTexts;
                    }
                    var t = canvasEvent.Cell.setControlInfo(JSON.stringify(con));
                    dict = con;
                } else {
                    var con = getBaseControl(ctype);
                    var orgiInfo = JSON.parse(canvasEvent.Cell.getControlInfo());
                    con.Events = orgiInfo.Events;
                    var t = canvasEvent.Cell.setControlInfo(JSON.stringify(con));
                    dict = con;
                }
                layer.close(index);
            },
            success: function (layero, index) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                //控件信息
                var ct = canvasEvent.Cell.getControlInfo();
                //当前模板的数据级
                let dataSourceArr = canvasEvent.Template.dataSourceArray();
                let dataSource = JSON.parse(dataSourceArr);
                let dsNameArr = [];
                $.each(dataSource, function (i, e) {
                    dsNameArr.push(e.DSName);
                });
                //当前模板的索引值
                let templateIndex = canvasEvent.Template.getCurrentSpreadSheetIndex();
                let controlInfo = JSON.parse(ct);
                //初始化数据集信息
                iframeWin.setDs(dsNameArr, templateIndex, controlInfo, dsMap);

            }
        });
    });


}

function changeLineColor(obj, hexColor, ct, color) {
    obj.css("background-color", hexColor);
    obj.children(0).val(hexColor);
}

//根据属性的变化更新控件信息
function updateControl(relateCell) {
    let ctype = $("#ef_control").dropdown('get value'); //获取控件类型
    let con = getBaseControl(parseInt(ctype)); //获取基础属性
    let controlInfo = canvasEvent.Cell.getControlInfo(); //获取controlInfo

    if (controlInfo !== "") {
        let json = JSON.parse(controlInfo);
        let events = json.Events; //获取事件
        if (events == undefined) { //事件为空时，添加事件
            if ($('#eventType').val() != '') {
                let eventType = $('#eventType').val(); //事件类型
                let eventCode = $('#eventCode').val(); //事件代码
                eventType = parseInt(eventType);
                let Events = [];
                let event = {};
                event.Type = eventType;
                event.Code = eventCode;
                Events.push(event);
                con.Events = Events; //初始化事件属性
                //dict.Events = Events;
            }
        } else { //控件事件存在
            let eventType = $('#eventType').val(); //事件类型
            let eventCode = $('#eventCode').val(); //事件代码
            eventType = parseInt(eventType);
            $.each(events, function (index, element) { //遍历现有事件
                let type = element.Type; //事件类型
                if (type == eventType) {//已有事件
                    events.splice(index, 1); //删除当前对象
                    return false;
                }
            })
            if (eventCode != '') { //事件编码不为空
                let event = {};
                event.Type = eventType;
                event.Code = eventCode;
                events.push(event); //添加新事件
            }
            con.Events = events;
            //dict.Events = events;
            //遍历当前控件存在的事件
            if (ctype == 1) { //文本编辑框
                $.each(events, function (index, element) {
                    if (element.Type == 1) {//初始化事件
                        $('#init').css("border-color", "#009688");
                    } else if (element.Type == 2) {//编辑前
                        $('#before').css("border-color", "#009688");
                    } else if (element.Type == 3) {//编辑后
                        $('#after').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 2) { //单选下拉

                $.each(events, function (index, element) {
                    if (element.Type == 5) {//初始化事件
                        $('#init_2').css("border-color", "#009688");
                    } else if (element.Type == 6) {//编辑后
                        $('#after_2').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 3) { //单选下拉

                $.each(events, function (index, element) {
                    if (element.Type == 7) {//初始化事件
                        $('#init3').css("border-color", "#009688");
                    } else if (element.Type == 8) {//编辑后
                        $('#after3').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 8) { //文本编辑框

                $.each(events, function (index, element) {
                    if (element.Type == 9) {//初始化事件
                        $('#init8').css("border-color", "#009688");
                    } else if (element.Type == 10) {//编辑前
                        $('#before8').css("border-color", "#009688");
                    } else if (element.Type == 11) {//编辑后
                        $('#after8').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 9) {

                $.each(events, function (index, element) {
                    if (element.Type == 4) {//点击事件
                        $('#click').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 7) { //单选下拉

                $.each(events, function (index, element) {
                    if (element.Type == 12) {//初始化事件
                        $('#init7').css("border-color", "#009688");
                    } else if (element.Type == 13) {//编辑后
                        $('#after7').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 6) { //单选下拉
                $('#init6').css("border-color", "white");
                $('#after6').css("border-color", "white");
                $.each(events, function (index, element) {
                    if (element.Type == 14) {//初始化事件
                        $('#init6').css("border-color", "#009688");
                    } else if (element.Type == 15) {//编辑后
                        $('#after6').css("border-color", "#009688");
                    }
                })
            } else if (ctype == 10) {

                $.each(events, function (index, element) {
                    if (element.Type == 16) {//初始化事件
                        $('#init10').css("border-color", "#009688");
                    } else if (element.Type == 17) {//编辑后
                        $('#after10').css("border-color", "#009688");
                    }
                })
            }

        }
        //关联单元格信息
        if (relateCell != undefined) {
            if (relateCell.length == 0) {//无关联单元格信息
                delete relateCell['EffectCellTexts'];
            } else {
                con.EffectCellTexts = relateCell;
            }
        } else {
            if (json.EffectCellTexts != undefined) {
                con.EffectCellTexts = json.EffectCellTexts
            }
        }
    }


    if (1 == ctype) {
        // con.MaxLength = parseInt($("#maxsize").val());
        // con.MinLength = parseInt($("#minsize").val());
        con.MaxLength = $("#maxsize").val() == "" ? -1 : parseInt($("#maxsize").val());
        con.MinLength = $("#minsize").val() == "" ? -1 : parseInt($("#minsize").val());
    } else if (8 == ctype) {
        con.AllowDecimal = $('#allowDecimal').prop('checked');
        con.AllowNegative = $('#allowNegative').prop('checked');
        //con.MaxValue = parseInt($('#maxnum').val());
        con.MaxValue = $("#maxnum").val() == "" ? -1 : parseInt($("#maxnum").val());
        //con.MinValue = parseInt($('#minnum').val());
        con.MinValue = $("#minnum").val() == "" ? -1 : parseInt($("#minnum").val());
        //con.decimalPlace = parseInt($('#autonum').val());
        con.decimalPlace = $("#autonum").val() == "" ? -1 : parseInt($("#autonum").val());

    } else if (9 == ctype) {
        con.ButtonText = $('#btntext').val();
        con.ButtonType = parseInt($('#btntype').val());
        if (2 == $('#btntype').val()) {
            $('#firstCell').hide();
            con.ButtonJS = $("#addButJs").prev().val();
        } else {
            $('#firstCell').show();
            /*  $("#addButJs").hide();
              $('#btntype').parent().parent().next().next().show();*/
            con.FirstCellX = canvasEvent.Util.cellX2Int($('#dyg1').val());
            con.FirstCellY = parseInt($('#dyg2').val() == '' ? 0 : $('#dyg2').val());
        }
    } else if (7 == ctype) {
        if (controlInfo != '') {
            let controlJson = JSON.parse(controlInfo);
            let dsType = controlJson.ComboDSType;
            if (dsType != undefined) {
                if (dsType == 1) {
                    con.ComboDSType = dsType;
                    con.DSName = controlJson.DSName;
                    con.KeyFieldName = controlJson.KeyFieldName;
                    con.ShowFieldName = controlJson.ShowFieldName;
                    con.CustomComboTexts = [];
                } else if (dsType == 2) {
                    con.ComboDSType = dsType;
                    con.DSName = '';
                    con.KeyFieldName = '';
                    con.ShowFieldName = '';
                    con.CustomComboTexts = controlJson.CustomComboTexts;
                }
            }
        }

    } else if (6 == ctype) {
        con.HasTime = $('#showdate').prop('checked');
        if ($('#showdate').prop('checked')) { //显示时间
            con.DateType = parseInt($('#dateTimeType').dropdown('get value'));
        } else {
            con.DateType = parseInt($('#dateType').dropdown('get value'));
        }
    } else if (11 == ctype) {
        con.SizeLimit = $("#filesize").val() == "" ? -1 : parseInt($('#filesize').val());
        con.FileType = $('#filetype').val();
        /*con.ShowPic = $('#showPic').prop('checked');*/
    } else if (2 == ctype || 10 == ctype || 3 == ctype) {
        if (controlInfo != '') {
            let controlJson = JSON.parse(controlInfo);
            let dsType = controlJson.ComboDSType;
            if (dsType != undefined) {
                if (dsType == 1) {
                    con.ComboDSType = dsType;
                    con.DSName = controlJson.DSName;
                    con.KeyFieldName = controlJson.KeyFieldName;
                    con.ShowFieldName = controlJson.ShowFieldName;
                    con.CustomComboTexts = [];
                } else if (dsType == 2) {
                    con.ComboDSType = dsType;
                    con.DSName = '';
                    con.KeyFieldName = '';
                    con.ShowFieldName = '';
                    con.CustomComboTexts = controlJson.CustomComboTexts;
                }
            }
        }
    }
    let str = JSON.stringify(con);
    canvasEvent.Cell.setControlInfo(str);
}

//获取基本属性
function getBaseControl(type) {
    let control = {};
    control.ControlName = $("#controlName_" + type).val();
    control.AllowNull = $("#allowNull_" + type).prop('checked');
    control.Hint = $("#tip_" + type).val();
    control.ControlShowExpr = $("#expr_" + type).prev().val();
    control.ControlType = parseInt(type);
    control.AffectRow = $("#affectRow_" + type).prop('checked');
    control.DefaultValue = $('#defaultValue_' + type).val();
    return control;
}

function initStyleEvent(colorOpt) {
    //数据分类
    $('#fmt').dropdown({
        onChange: function (value, text, $selectedItem) {
            let cellType = canvasEvent.Cell.getSelCellsType(); //数据分类
            $('#fmt_val').parent().removeClass('disabled');
            if (cellType == value) { // 赋值
                if (value == 1) {
                    $('#fmt_val').dropdown('clear');
                    $('#fmt_val').parent().addClass('disabled');
                }
                return false;
            }
            if (value == 1) {
                $('#fmt_val').dropdown('clear');
                $('#fmt_val').parent().addClass('disabled');
            }
            let cellStyle = canvasEvent.Cell.getSelCellsStyle();
            let val = parseInt(value);
            canvasEvent.Cell.setSelCellsType(val);

            let dataArray = [];
            let enums;
            if (2 == val) {
                enums = CellConstant.Number;
            } else if (4 == val) {
                enums = CellConstant.DateType;
            } else if (5 == val) {
                enums = CellConstant.TimeType;
            } else if (6 == val) {
                enums = CellConstant.Currency;
            } else if (8 == val) {
                enums = CellConstant.Percent;
            } else if (10 == val) {
                enums = CellConstant.BarCodeType;
            } else if(3 == val){
                $('#fmt_val').dropdown('clear');
                $('#fmt_val').parent().addClass('disabled');
            }
            let index = 0;
            let firstValue;
            $("#fmt_val").empty();
            for (var i in enums) {
                if (index == 0) {
                    firstValue = i;
                }
                $("#fmt_val").append('<option value="' + i + '">' + enums[i] + '</option>')
                index++;
            }
            $("#fmt_val").dropdown();
            //default selected
            if (val == 10) {
                //设置二维码类型
                canvasEvent.Cell.setSelCellsBarCodeType(parseInt(firstValue));
            } else {
                //设置数据格式
                canvasEvent.Cell.setSelCellsStyle(parseInt(firstValue));
            }
            //$("#fmt_val").dropdown('set selected' , firstValue);
        }
    })

    $('#fmt_val').dropdown({
        onChange: function (value, text, $selectedItem) {
            let cellType = canvasEvent.Cell.getSelCellsType(); //获取数据类型
            if (cellType == 1 || cellType == 0) { //常规
                return false;
            }
            let cellStyle;
            if (cellType == 10) { //二维码
                cellStyle = canvasEvent.Cell.getSelCellsBarCodeType();
            } else {
                cellStyle = canvasEvent.Cell.getSelCellsStyle();
            }
            if (cellStyle != value) {
                if (cellType == 10) {
                    //设置二维码类型
                    canvasEvent.Cell.setSelCellsBarCodeType(value);
                } else {
                    //设置数据格式
                    canvasEvent.Cell.setSelCellsStyle(value);
                }
            }

        }
    })
    //水平对齐

    $("#horAlign").dropdown({
        onChange: function (value, text, $selectedItem) {
            let alignH = canvasEvent.Cell.getSelCellAlignH();
            if (alignH == 0) { //
                if (value != '4') {
                    canvasEvent.Cell.setSelCellAlignH(parseInt(value));
                }
            } else {
                if (alignH != parseInt(value)) {
                    canvasEvent.Cell.setSelCellAlignH(parseInt(value));
                }
            }
        }
    });
    //垂直对齐
    $("#verAlign").dropdown({
        onChange: function (value, text, $selectedItem) {
            let alignV = canvasEvent.Cell.getSelCellAlignV();
            if (alignV == 0) { //
                if (value != '64') {
                    canvasEvent.Cell.setSelCellAlignV(parseInt(value));
                }
            } else {
                if (alignV != parseInt(value)) {
                    canvasEvent.Cell.setSelCellAlignV(parseInt(value));
                }
            }
        }
    });


    $("#horAlignS").dropdown({
        onChange: function (value, text, $selectedItem) {
            let alignH = canvasEvent.Shape.getSelShapeAlignH();
            if (alignH == 0) { //
                if (value != '4') {
                    canvasEvent.Shape.setSelShapeAlignH(parseInt(value));
                }
            } else {
                if (alignH != parseInt(value)) {
                    canvasEvent.Shape.setSelShapeAlignH(parseInt(value));
                }
            }
        }
    });
    //垂直对齐
    $("#verAlignS").dropdown({
        onChange: function (value, text, $selectedItem) {
            let alignV = canvasEvent.Shape.getSelShapeAlignV();
            if (alignV == 0) { //
                if (value != '64') {
                    canvasEvent.Shape.setSelShapeAlignV(parseInt(value));
                }
            } else {
                if (alignV != parseInt(value)) {
                    canvasEvent.Shape.setSelShapeAlignV(parseInt(value));
                }
            }
        }
    });

    //垂直对齐
    $("#animationS").dropdown({
        onChange: function (value, text, $selectedItem) {
            canvasEvent.Shape.setSelShapeAniType(value);
        }
    });

    $('#adapt').dropdown({
        onChange: function (value, text, $selectedItem) {
            if (value == 1) {
                canvasEvent.Cell.setSelCellAdaptTextHeight(false);
                canvasEvent.Cell.setSelCellAdaptTextWidth(false);
            } else if (value == 2) {
                canvasEvent.Cell.setSelCellAdaptTextHeight(true);
                canvasEvent.Cell.setSelCellAdaptTextWidth(false);
            } else {
                canvasEvent.Cell.setSelCellAdaptTextHeight(false);
                canvasEvent.Cell.setSelCellAdaptTextWidth(true);
            }
        }
    })

    $("#lineSpacing").bind('change', function () { //行间距
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellLineSpacing(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellLineSpacing(val);
        }

    });

    $("#letterSpacing").bind('change', function () { //字符间距
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellLetterSpacing(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellLetterSpacing(0);
        }
    });

    $("#paragraphSpaceCount").bind('change', function () { //段落空格数
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellParagraphSpaceCount(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellParagraphSpaceCount(0);
        }
    });

    $("#topMargin").bind('change', function () { //文本上边距
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellTopMargin(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellTopMargin(0);
        }
    });

    $("#bottomMargin").bind('change', function () { //文本下边距
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellBottomMargin(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellBottomMargin(0);
        }
    });

    $("#leftMargin").bind('change', function () { //文本左边距
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellLeftMargin(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellLeftMargin(0);
        }
    });

    $("#rightMargin").bind('change', function () { //文本右边距
        let val = $(this).val();
        let reg = /^\d+(?=\.{0,1}\d+$|$)/
        if (reg.test(val) || val == 0) {
            canvasEvent.Cell.setSelCellRightMargin(val);
        } else {
            $(this).val(0);
            canvasEvent.Cell.setSelCellRightMargin(0);
        }
    });

    $('#imghAlign').dropdown({
        onChange: function (value, text, item) {
            let cur = canvasEvent.Cell.getSelCellImageAlignX();
            if (cur != value) {
                canvasEvent.Cell.setSelCellImageAlignX(value);
            }
        }
    })

    $('#imgvAlign').dropdown({
        onChange: function (value, text, item) {
            let cur = canvasEvent.Cell.getSelCellImageAlignY();
            if (cur != value) {
                canvasEvent.Cell.setSelCellImageAlignY(value);
            }
        }
    })

    /* // 图片水平对齐
     $("img[name='imghAlign']").click(function () {
         $("img[name='imghAlign']").each(function () {
             $(this).removeClass('choose');
         });
         $(this).addClass('choose');
         canvasEvent.Cell.setSelCellImageAlignX($(this).attr('val'));
     });*/

    // 图片垂直对齐
    /*   $("img[name='imgvAlign']").click(function () {
           $("img[name='imgvAlign']").each(function () {
               $(this).removeClass('choose');
           });
           $(this).addClass('choose');
           canvasEvent.Cell.setSelCellImageAlignY($(this).attr('val'));
       });*/
    //图片缩放
    $("#imgsf").change(function () {
        let val = $(this).prop('checked');
        canvasEvent.Cell.setSelCellAdaptImageSize(val);
        if (val) {
            //保持原比例
            $("#imgkeep").removeAttr('disabled');
            $('#tz2_tb').find('img').attr('disabled', true);
        } else {
            $('#tz2_tb').find('img').removeAttr('disabled');
            $("#imgkeep").attr('disabled', true);
        }
    });
    //保持原比例
    $("#imgkeep").change(function () {
        canvasEvent.Cell.setSelCellRawImageScale($(this).prop('checked'));
    });

    $("#linecolor").spectrum(colorOpt);

    //设置边框
    $("div[name='borderAlign_d']").click(function () { //设置边框
        let val = $(this).children(0).attr('val'); //边框类型
        $("img[name='borders']").each(function () { //设置工具栏的边框样式
            if (val == $(this).attr('attr')) {
                $("img[name='border']").attr('src', $(this).attr('src'));
            }
        });

        let color = $("#lineColorText").text(); //当前选中的颜色
        let widthType = $('input[name="xk"]:checked').val();
        let penStyle = $('#linesDrop').find('.text').find('img').attr('value');
        if (val < 5) {
            if ($(this).hasClass('fx')) {
                $(this).removeClass('fx');
                canvasEvent.Cell.setSelCellLineStyleByPenStyle(val, 0);
            } else {
                $(this).addClass('fx');
                let t = canvasEvent.Cell.setSelCellLineStyle(val, penStyle, widthType, color);
            }
        } else {
            if ($(this).hasClass('fx')) {
                $(this).removeClass('fx');
            } else {
                $(this).addClass('fx');
            }
            if ($(this).hasClass('fx')) {
                canvasEvent.Cell.setSelCellLineStyle(val, penStyle, widthType, color);
                $("img[name='borderAlign']").each(function () {
                    if ($(this).attr('val') < 5) {
                        $(this).parent().addClass('fx');
                    }
                });
            } else {
                canvasEvent.Cell.setSelCellLineStyle(val, 0, widthType, color);
                if (val == 6) {
                    $("img[name='borderAlign']").each(function () {
                        if ($(this).attr('val') < 5) {
                            $(this).parent().removeClass('fx');
                            canvasEvent.Cell.setSelCellLineStyleByPenStyle($(this).attr('val'), 0);
                        }
                    });
                }
            }
        }
    });

    //水平对齐
    $("#imageHAlign").dropdown({
        onChange: function (value, text, $selectedItem) {
            canvasEvent.Cell.setSelCellImageAlignX(parseInt(value));
        }
    });
    //垂直对齐
    $("#imageVAlign").dropdown({
        onChange: function (value, text, $selectedItem) {
            canvasEvent.Cell.setSelCellImageAlignY(parseInt(value));
        }
    });


}

function checkXk(val) {
    $('input[name="xk"][value="' + val + '"]').prop('checked', true);
}

function shapeExpr() {
    var index = layer.open({
        type: 2,
        area: ['900px', '650px'],
        closeBtn: 0,
        maxmin: true,
        resize: false,
        title: ['公式编辑', 'height:36px;line-height:36px'],
        content: ['pages/design/expr.html', 'no'],
        btn: ['确定', '关闭'],
        btnAlign: 'c',
        end: function () {

        },
        yes: function (index, layero) {
            let iframeWin = window[layero.find('iframe')[0]['name']];
            let expr = iframeWin.getExpr();
            if (expr == "") { //没有设置公式
                canvasEvent.Shape.setSelShapeVisExprStr("");
            } else {
                if (expr.indexOf('=') != 0) {
                    expr = "=" + expr;
                    // 设置单元格文本
                    canvasEvent.Shape.setSelShapeVisExprStr(expr);
                } else {
                    canvasEvent.Shape.setSelShapeVisExprStr(expr);
                }
            }
            layer.close(index);
        },
        success: function (layero, index) {
            // MainEditor.setCurSpreadSheetEnabled(0);
            let iframeWin = window[layero.find('iframe')[0]['name']];
            //获取当前单元格文本
            let val = canvasEvent.Shape.getSelShapeVisExprStr();
            let valArr = val.split('');
            if (valArr[0] == '=') {
                val = val.replace('=', '');
            }
            iframeWin.setExpr(val);
        }
    });
}



