# 数据源

数据源可添加、删除、查找数据库链接条目，不同的数据库链接属性略有不同，不同的设计器人员的数据源只有设计器人员自身可见。具体属性如下：

  ---------------------- ------------------------------------------------------------------------------
|属性|功能描述
|:-----:|-----|
|链接名称|数据库链接名称，不能设置为空、重复名、特殊符号。
|数据库类型|链接的数据库类型。
|数据库URL|数据库链接所需的URL，采用JDBC的方式链接数据库，不同数据库链接的URL格式不同。
|用户名|链接的数据库用户名。
|密码|链接的数据库用户密码。
|测试链接|测试当前设置信息是否正常链接到数据库。
  ---------------------- ------------------------------------------------------------------------------

添加一个数据源后，填写当前的"链接名称"，选择实际要链接的"数据库类型"，选择后在"数据库URL"中修改相应的数据库IP地址，端口与实际链接的数据库名称，最后填写"用户名"，"密码"。填写好信息，可点击"测试连接"，查看是否正常链接，连接成功后，可正常使用。

支持直接将存储过程作为数据集，调用方式对应相应的数据库调用存储过程的方法，存储过程需要返回数据集。ORACLE数据库的链接，填写用户名时一定要注意大小写，"测试链接"时，大小写不敏感，查找相应的表时，大小写敏感。

ODBC链接方式只支持windows服务器。使用ODBC链接数据库时，"jdbc:odbc:Driver={SQL Server};Server=127.0.0.1;Database=DB;Uid=sa;Pwd=123"，用户名、密码必须写在url中。还可以在windows中建立dsn，"name"："odbc1"，"password"："123"，"type"："ODBC"，"url"："jdbc:odbc:name1","username"："sa"。"name1"是在windows的odbc中建立的连接名。Windows服务器连接SQLSERVER数据库时，建议使用ODBC方式链接。

Mysql数据库中的使用Federated引擎时，需要注意同步频率等设置，过于频繁的同步数据会造成链接失败等问题。

链接REDIS数据库时，数据库URL格式为"127.0.0.1:6379?index=0"，其中"127.0.0.1:6379"是REDIS数据库的IP与端口，"index=0"是REDIS数据库实际的数据库索引值，输入链接的密码即可正常链接。

从REDIS数据库取数据时，需要使用特殊的获取方式。"(Key)"获取"Key"的全部数据，"(Key,Start,End)"获取"Key"值从Start开始End结束的部分数据，其他Start从０开始计数。REDIS数据库暂支持String、List类型。

使用数据库类型为"HTTP"http接口时，解析的JSON格式如下：{\"表名\":\[{\"字段1\":\"文本数据1\",\"字段2\":具体数值1,\...},{\"字段1\":\"文本数据1\",\"字段2\":具体数值2,\...},\...\]}。

需要使用参数传入http地址中时，根据实际的接口方式，后面加入报表参数。例如："http://127.0.0.1:8099/EFRS/thirdSys/getHttpData?id=@{param1}&address=@{param2}", 输入的地址中的@{param1}、@{param2}是报表中需要传递的参数，制作报表时如果使用此链接，需要在相应的报表里面创建相应名称的模板参数，并根据实际情况设置是否是字符串类型，是字符串类型的会自动加单引号。

数据库连接支持二次开发，可自定义数据库连接。具体参考数据库二次开发文档。