/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EFMultiSheetButton {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = EFMultiSheetButton.generateDefaultOption();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String clazzName = EFMultiSheetButton.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;display:flex;justify-content:center;align-items:center;'>");
                sb.append("<button style='width:80px;height:30px;background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("font-family") + ";font-style:" + optionObj.getString("font-style") + ";font-weight:" + optionObj.getString("font-weight") + ";'>" + optionObj.getString("text") + "</button>");
                sb.append("</div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFMultiSheetButton.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                results.put("option", realDataJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{'text':'\u6309\u94ae',");
        sb.append("'backgroundColor':'#ffffff',");
        sb.append("'color':'#000000',");
        sb.append("'fontSize':'12',");
        sb.append("'fontWeight':'normal',");
        sb.append("'fontStyle':'normal',");
        sb.append("'fontFamily':'\u5b8b\u4f53',");
        sb.append("'templateName':'',");
        sb.append("'js':'window.history.back();'");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        int i;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObj = JSONObject.parseObject((String)option);
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-4.1.0.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'>");
        sb.append("<button id='but' style='outline:none;border:0px;width:" + (width - 1) + "px;height:" + height + "px;background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>" + optionObj.getString("text") + "</button>");
        sb.append("</div>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        sb.append("$('#main').css('width',$(window.frameElement).attr('ow'));");
        sb.append("$('#main').css('height',$(window.frameElement).attr('oh'));");
        sb.append("$('#but').css('width',$(window.frameElement).attr('ow') - 2);");
        sb.append("$('#but').css('height',$(window.frameElement).attr('oh') - 2);");
        sb.append("$('#main').find('#but').bind('click',function(){");
        String targetShapes = optionObj.getString("targetShapes");
        String targetShape = optionObj.getString("targetShape");
        String[] shapes = targetShapes.split(",");
        String functionStr = "";
        functionStr = functionStr + "if($(window.parent.document) != undefined){";
        for (i = 0; i < shapes.length; ++i) {
            functionStr = functionStr + "$(window.parent.document).find('div[sname=\"" + shapes[i] + "\"]').css('display' , 'none');";
            functionStr = functionStr + "$(window.parent.document).find('div[sname=\"" + targetShape + "\"]').css('display' , 'flex');";
        }
        functionStr = functionStr + "}else{";
        for (i = 0; i < shapes.length; ++i) {
            functionStr = functionStr + "$(document).find('div[sname=\"" + shapes[i] + "\"]').css('display' , 'none');";
            functionStr = functionStr + "$(document).find('div[sname=\"" + targetShape + "\"]').css('display' , 'flex');";
        }
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        functionStr = functionStr + "}";
        sb.append(functionStr);
        sb.append("parent.Link.Fn.regionLink(this,2,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')");
        sb.append("});");
        sb.append("var fontSize = $('#main').find('#but').css('fontSize');");
        sb.append("fontSize = fontSize.substring(0,fontSize.length-2);");
        sb.append("$('#main').find('#but').hover(function(){$(this).css('fontSize' , (parseInt(fontSize)+4) + 'px');},function(){$(this).css('fontSize' , (fontSize) + 'px');})");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(sb.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        JSONObject optionObj = JSONObject.parseObject((String)option);
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-4.1.0.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'>");
        sb.append("<button id='but' style='border:0px;width:" + (width - 1) + "px;height:" + height + "px;background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>" + optionObj.getString("text") + "</button>");
        sb.append("</div>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        sb.append("$('#main').css('width',$(window.frameElement).attr('ow'));");
        sb.append("$('#main').css('height',$(window.frameElement).attr('oh'));");
        sb.append("$('#but').css('width',$(window.frameElement).attr('ow'));");
        sb.append("$('#but').css('height',$(window.frameElement).attr('oh'));");
        if (optionObj.getString("templateName") != null && !optionObj.getString("templateName").equals("")) {
            String url = jsResourcePath.substring(0, jsResourcePath.length() - 7) + "/report/checkSheet?file=" + optionObj.getString("templateName");
            sb.append("$('#main').find('#but').bind('click',function(){window.open('" + url + "')})");
        } else if (optionObj.getString("js") != null) {
            sb.append("$('#main').find('#but').bind('click',function(){" + optionObj.getString("js") + "});");
        }
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u591asheet\u9875\u6309\u94ae\u63a7\u4ef6";
    }

    public static String getClassName() {
        return "EFMultiSheetButton";
    }

    public static void main(String[] args) {
        System.out.println(EFMultiSheetButton.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        return option;
    }
}

