/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfScriptMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfScriptMerger.class);
    private static final Set<PdfName> allowedAAEntries = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.WC, PdfName.WS, PdfName.DS, PdfName.WP)));

    public static void mergeScripts(PdfDocument source, PdfDocument destination) {
        PdfScriptMerger.mergeOpenActionsScripts(source, destination);
        PdfScriptMerger.mergeAdditionalActionsScripts(source, destination);
        PdfScriptMerger.mergeNamesScripts(source, destination);
    }

    public static void mergeAdditionalActionsScripts(PdfDocument source, PdfDocument destination) {
        PdfDictionary sourceAA = ((PdfDictionary)source.getCatalog().getPdfObject()).getAsDictionary(PdfName.AA);
        PdfDictionary destinationAA = ((PdfDictionary)destination.getCatalog().getPdfObject()).getAsDictionary(PdfName.AA);
        if (sourceAA == null || sourceAA.isEmpty()) {
            return;
        }
        if (destinationAA == null) {
            destinationAA = new PdfDictionary();
            ((PdfDictionary)destination.getCatalog().getPdfObject()).put(PdfName.AA, destinationAA);
        }
        for (Map.Entry<PdfName, PdfObject> entry : sourceAA.entrySet()) {
            if (destinationAA.containsKey(entry.getKey())) {
                LOGGER.error(MessageFormatUtil.format((String)"Cannot merge entry {0}, entry with such key already exists.", (Object[])new Object[]{entry.getKey()}));
                return;
            }
            if (!allowedAAEntries.contains(entry.getKey())) continue;
            destinationAA.put(entry.getKey(), PdfScriptMerger.copyECMAScriptActionsDictionary(destination, (PdfDictionary)entry.getValue()));
        }
    }

    public static void mergeOpenActionsScripts(PdfDocument source, PdfDocument destination) {
        PdfObject sourceOpenAction = ((PdfDictionary)source.getCatalog().getPdfObject()).get(PdfName.OpenAction);
        if (sourceOpenAction instanceof PdfArray) {
            return;
        }
        PdfDictionary sourceOpenActionDict = ((PdfDictionary)source.getCatalog().getPdfObject()).getAsDictionary(PdfName.OpenAction);
        if (sourceOpenActionDict == null || sourceOpenActionDict.isEmpty() || !PdfName.JavaScript.equals(sourceOpenActionDict.get(PdfName.S))) {
            return;
        }
        PdfObject destinationOpenAction = ((PdfDictionary)destination.getCatalog().getPdfObject()).get(PdfName.OpenAction);
        if (destinationOpenAction != null) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot merge entry {0}, entry with such key already exists.", (Object[])new Object[]{PdfName.OpenAction}));
            return;
        }
        ((PdfDictionary)destination.getCatalog().getPdfObject()).put(PdfName.OpenAction, PdfScriptMerger.copyECMAScriptActionsDictionary(destination, sourceOpenActionDict));
    }

    public static void mergeNamesScripts(PdfDocument source, PdfDocument destination) {
        PdfDictionary namesDict = ((PdfDictionary)source.getCatalog().getPdfObject()).getAsDictionary(PdfName.Names);
        if (namesDict == null || !namesDict.containsKey(PdfName.JavaScript)) {
            return;
        }
        PdfDictionary destinationNamesDict = ((PdfDictionary)destination.getCatalog().getPdfObject()).getAsDictionary(PdfName.Names);
        if (destinationNamesDict != null && destinationNamesDict.get(PdfName.JavaScript) != null || destination.getCatalog().nameTreeContainsKey(PdfName.JavaScript)) {
            LOGGER.error(MessageFormatUtil.format((String)"Cannot merge entry {0}, entry with such key already exists.", (Object[])new Object[]{PdfName.JavaScript}));
            return;
        }
        PdfNameTree sourceTree = new PdfNameTree(source.getCatalog(), PdfName.JavaScript);
        PdfNameTree destinationTree = destination.getCatalog().getNameTree(PdfName.JavaScript);
        for (Map.Entry<PdfString, PdfObject> entry : sourceTree.getNames().entrySet()) {
            PdfDictionary ECMAScriptActionsDirectCopy = PdfScriptMerger.copyECMAScriptActionsDictionary(destination, entry.getValue().isIndirect() ? (PdfDictionary)entry.getValue().getIndirectReference().getRefersTo() : (PdfDictionary)entry.getValue());
            destinationTree.addEntry(entry.getKey(), (PdfObject)ECMAScriptActionsDirectCopy);
        }
    }

    private static PdfDictionary copyECMAScriptActionsDictionary(PdfDocument destination, PdfDictionary actions) {
        PdfObject originalScriptSource = actions.get(PdfName.JS);
        PdfObject scriptType = actions.get(PdfName.S);
        PdfDictionary actionsCopy = new PdfDictionary();
        if (originalScriptSource != null) {
            actionsCopy.put(PdfName.JS, originalScriptSource.copyTo(destination));
        }
        if (scriptType != null) {
            actionsCopy.put(PdfName.S, scriptType.copyTo(destination));
        }
        return actionsCopy;
    }
}

