/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.internal.failover.utils.ConfigParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class TnsDaemon
extends Thread {
    private static String configFileName = "tnsnames.ob";

    private void fullFillMap(String tnsPath) throws IOException {
        String filePath = tnsPath + "/" + configFileName;
        File file = new File(filePath);
        InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
        ConfigParser.getLoadBalanceInfosFromReader(reader);
    }

    @Override
    public void run() {
        try {
            WatchKey key;
            boolean vaild;
            ConfigParser.TnsFileInfo tnsFileInfo = ConfigParser.getTnsFilePath();
            configFileName = tnsFileInfo.name;
            this.fullFillMap(tnsFileInfo.path);
            WatchService watchService = FileSystems.getDefault().newWatchService();
            File file1 = new File(tnsFileInfo.path);
            file1.toPath().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            do {
                key = watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (!filename.toString().equals(configFileName)) continue;
                    this.fullFillMap(tnsFileInfo.path);
                }
            } while (vaild = key.reset());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

