/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EFVideo {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = EFVideo.generateDefaultOption();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String clazzName = EFVideo.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append(" <meta http-equiv='pragma' content='no-cache'>");
                sb.append(" <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append(" <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/layui/css/layui.css' media='all'>");
                sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/semantic/css/semantic.min.css' media='all'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/layui/layui.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/semantic/semantic.js'></script>");
                sb.append("<style>");
                sb.append("        html, body {");
                sb.append("    width: 100%;");
                sb.append("    border: 0px;");
                sb.append("    margin: 0px;");
                sb.append("    padding: 0px;");
                sb.append("     height: 100%;");
                sb.append(" }");
                sb.append("</style>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;width:100%;height:100%;'>");
                sb.append("<div style='margin:0px;padding:0px;width:100%;height:100%;display:flex;justify-content: center; align-items: center;'>");
                sb.append("<video width='100%' height='100%' controls autoplay muted>\n\n    <source src='path/to/your/video.mp4' type='video/mp4'>\n\n    <source src='path/to/your/video.webm' type='video/webm'>\n\n    \u60a8\u7684\u6d4f\u89c8\u5668\u4e0d\u652f\u6301 video \u6807\u7b7e\u3002\n\n</video>");
                sb.append("</div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFVideo.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        StringBuffer sb = new StringBuffer();
        path = path.replace(".html", ".plugin");
        JSONObject optionJ = JSONObject.parseObject((String)option);
        JSONObject optionJson = optionJ.getJSONObject("saveJson");
        String url = optionJson.getString("url");
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        cssArray.add((Object)(jsResourcePath + "/semantic/css/semantic.min.css"));
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(cssArray.toString());
        domBuffer.append("<div style='margin:0px;padding:0px;width:100%;height:100%;display:flex;justify-content: center; align-items: flex-start;'>");
        domBuffer.append("<video style='width:100%;height:100%;object-fit: cover;' controls autoplay muted>\n\n    <source src='" + url + "' type='video/mp4'>\n\n    <source src='path/to/your/video.webm' type='video/webm'>\n\n    \u60a8\u7684\u6d4f\u89c8\u5668\u4e0d\u652f\u6301 video \u6807\u7b7e\u3002\n\n</video>");
        domBuffer.append("</div>");
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        JSONObject optionObj = JSONObject.parseObject((String)option);
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-4.1.0.min.js'></script>");
        sb.append("<style>");
        sb.append("        html, body {");
        sb.append("    width: 100%;");
        sb.append("    border: 0px;");
        sb.append("    margin: 0px;");
        sb.append("    padding: 0px;");
        sb.append("     height: 100%;");
        sb.append("     background-color: transparent;");
        sb.append(" }");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = tempPath + File.separator + fileName;
        String pngPath = tempPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            if (htmlPath.contains(":")) {
                htmlPath = htmlPath.substring(1, htmlPath.length());
                pngPath = pngPath.substring(1, pngPath.length());
            }
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            int result = engine.Er_ExportPluginImage(htmlPath = htmlPath.replaceAll("//", "/"), 0, 0, width, height, pngPath = pngPath.replaceAll("//", "/"));
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u89c6\u9891\u64ad\u653e\u63d2\u4ef6";
    }

    public static String getClassName() {
        return "EFVideo";
    }

    public static void main(String[] args) {
        System.out.println(EFVideo.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        return option;
    }
}

