/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Funnel {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Funnel.generateDefaultOption();
            String clazzName = Funnel.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Funnel.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONArray legend;
                JSONObject legendObject;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                if (optionJSON.containsKey((Object)"legend") && (legendObject = (legend = optionJSON.getJSONArray("legend")).getJSONObject(0)).containsKey((Object)"data")) {
                    legendObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("    title: {");
        sb.append("        text: '\u6f0f\u6597\u56fe'");
        sb.append("    },");
        sb.append("initTimes:0,");
        sb.append("animation:false,");
        sb.append("    tooltip: {");
        sb.append("        trigger: 'item',");
        sb.append("                formatter: '{a} <br/>{b} : {c}%'");
        sb.append("    },");
        sb.append("    legend: {");
        sb.append("        data: ['\u5c55\u73b0','\u70b9\u51fb','\u8bbf\u95ee','\u54a8\u8be2','\u8ba2\u5355'], type:'scroll'");
        sb.append("    },");
        sb.append("    series: [");
        sb.append("    {");
        sb.append("        name:'\u6f0f\u6597\u56fe',");
        sb.append("                type:'funnel',");
        sb.append("            left: '10%',");
        sb.append("            top: 60,");
        sb.append("            bottom: 60,");
        sb.append("            width: '80%',");
        sb.append("            min: 0,");
        sb.append("            max: 100,");
        sb.append("            minSize: '0%',");
        sb.append("            maxSize: '100%',");
        sb.append("            sort: 'none',");
        sb.append("           gap: 2,");
        sb.append("            label: {");
        sb.append("        show: true,");
        sb.append("                position: 'inside'");
        sb.append("    },");
        sb.append("        labelLine: {");
        sb.append("            length: 10,");
        sb.append("                    lineStyle: {");
        sb.append("                width: 1,");
        sb.append("                        type: 'solid'");
        sb.append("            }");
        sb.append("        },");
        sb.append("        itemStyle: {");
        sb.append("            borderColor: '#fff',");
        sb.append("                    borderWidth: 1");
        sb.append("        },");
        sb.append("        emphasis: {");
        sb.append("            label: {");
        sb.append("                fontSize: 20");
        sb.append("            }");
        sb.append("        },");
        sb.append("        data: [");
        sb.append("        {value: 60, name: '\u8bbf\u95ee'},");
        sb.append("        {value: 40, name: '\u54a8\u8be2'},");
        sb.append("        {value: 20, name: '\u8ba2\u5355'},");
        sb.append("        {value: 80, name: '\u70b9\u51fb'},");
        sb.append("        {value: 100, name: '\u5c55\u73b0'}");
        sb.append("        ]");
        sb.append("    }");
        sb.append("    ]");
        sb.append(" }");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        JSONObject backColorObj;
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = optionObject.getJSONArray("series");
        JSONObject seriesObject = seriesArray.getJSONObject(0);
        if (seriesObject.containsKey((Object)"data")) {
            seriesObject.remove((Object)"data");
        }
        if (seriesObject.containsKey((Object)"name")) {
            seriesObject.remove((Object)"name");
            seriesObject.put("name", (Object)"");
        }
        JSONArray seriesDataArray = new JSONArray();
        for (int j = 0; j < seriesDatas.length; ++j) {
            JSONObject seriesDefObj;
            JSONObject object = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && j < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(j)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    object.put(key, seriesDefObj.get((Object)key));
                }
            }
            object.put("value", (Object)valueDatas[j]);
            object.put("name", (Object)seriesDatas[j]);
            seriesDataArray.add((Object)object);
        }
        seriesObject.put("data", (Object)seriesDataArray);
        optionObject.put("series", (Object)seriesArray);
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legendObject = legendArray.getJSONObject(0);
        JSONArray legendDataArray = new JSONArray();
        for (int i = 0; i < seriesDataArray.size(); ++i) {
            JSONObject dataObj = seriesDataArray.getJSONObject(i);
            legendDataArray.add((Object)dataObj.getString("name"));
        }
        if (legendObject.containsKey((Object)"data")) {
            legendObject.remove((Object)"data");
        }
        legendObject.put("data", (Object)legendDataArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsBuffer.append(jsArray.toString());
        cssBuffer.append(cssArray.toString());
        long time = System.currentTimeMillis();
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);});");
        }
        sb.append("$('#main_" + time + "').on('dblclick' , function(params){var pWidth = $(window.parent.document).find('.x-data-bg_block').width();var pHeight = $(window.parent.document).find('.x-data-bg_block').height();var url = $(window.frameElement).attr('src');Link.Fn.layerOpen(pWidth , pHeight , url);});");
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        JSONObject backColorObj;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = optionObject.getJSONArray("series");
        JSONObject seriesObject = seriesArray.getJSONObject(0);
        if (seriesObject.containsKey((Object)"data")) {
            seriesObject.remove((Object)"data");
        }
        if (seriesObject.containsKey((Object)"name")) {
            seriesObject.remove((Object)"name");
            seriesObject.put("name", (Object)"");
        }
        JSONArray seriesDataArray = new JSONArray();
        for (int j = 0; j < seriesDatas.length; ++j) {
            JSONObject seriesDefObj;
            JSONObject object = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && j < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(j)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    object.put(key, seriesDefObj.get((Object)key));
                }
            }
            object.put("value", (Object)valueDatas[j]);
            object.put("name", (Object)seriesDatas[j]);
            seriesDataArray.add((Object)object);
        }
        seriesObject.put("data", (Object)seriesDataArray);
        optionObject.put("series", (Object)seriesArray);
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legendObject = legendArray.getJSONObject(0);
        JSONArray legendDataArray = new JSONArray();
        for (int i = 0; i < seriesDataArray.size(); ++i) {
            JSONObject dataObj = seriesDataArray.getJSONObject(i);
            legendDataArray.add((Object)dataObj.getString("name"));
        }
        if (legendObject.containsKey((Object)"data")) {
            legendObject.remove((Object)"data");
        }
        legendObject.put("data", (Object)legendDataArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(optionObject.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = optionObject.getJSONArray("series");
        JSONObject seriesObject = seriesArray.getJSONObject(0);
        if (seriesObject.containsKey((Object)"data")) {
            seriesObject.remove((Object)"data");
        }
        if (seriesObject.containsKey((Object)"name")) {
            seriesObject.remove((Object)"name");
            seriesObject.put("name", (Object)"");
        }
        JSONArray seriesDataArray = new JSONArray();
        for (int j = 0; j < seriesDatas.length; ++j) {
            JSONObject seriesDefObj;
            JSONObject object = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && j < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(j)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    object.put(key, seriesDefObj.get((Object)key));
                }
            }
            object.put("value", (Object)valueDatas[j]);
            object.put("name", (Object)seriesDatas[j]);
            seriesDataArray.add((Object)object);
        }
        seriesObject.put("data", (Object)seriesDataArray);
        optionObject.put("series", (Object)seriesArray);
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legendObject = legendArray.getJSONObject(0);
        JSONArray legendDataArray = new JSONArray();
        for (int i = 0; i < seriesDataArray.size(); ++i) {
            JSONObject dataObj = seriesDataArray.getJSONObject(i);
            legendDataArray.add((Object)dataObj.getString("name"));
        }
        if (legendObject.containsKey((Object)"data")) {
            legendObject.remove((Object)"data");
        }
        legendObject.put("data", (Object)legendDataArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u6f0f\u6597\u56fe";
    }

    public static String getClassName() {
        return "Funnel";
    }

    public static void main(String[] args) {
        System.out.println(Funnel.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)Funnel.generateDefaultOption());
        JSONArray optionArray = (JSONArray)optionJson.get((Object)"series");
        JSONObject seriesObject = optionArray.getJSONObject(0);
        JSONObject labelObject = seriesObject.getJSONObject("label");
        Object formatter = null;
        if (labelObject != null && labelObject.getString("formatter") != null) {
            String format = labelObject.getString("formatter");
            if (format.contains("\n")) {
                format = format.replaceAll("\n", "&e&");
            }
            optionJson.put("labelFormat", (Object)format);
        }
        JSONArray seriesDefaultArray = (JSONArray)defaultJson.get((Object)"series");
        JSONObject seriesDefaultObj = seriesDefaultArray.getJSONObject(0);
        for (String key : seriesDefaultObj.keySet()) {
            if ("name".equals(key)) {
                optionJson.put("name", (Object)seriesDefaultObj.getString(key));
            }
            if (!"data".equals(key)) continue;
            optionJson.put("data", (Object)seriesDefaultObj.getJSONArray(key));
        }
        return optionJson.toString();
    }
}

