/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class EFText {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = EFText.generateDefaultOption();
            JSONObject optionObj = JSONObject.parseObject((String)option);
            String clazzName = EFText.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;display:flex;justify-content:center;align-items:center;'>");
                sb.append("<span style='line-height:50px;text-align:center;width:200px;height:50px;border:0px solid" + optionObj.getString("borderColor") + ";background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>" + optionObj.getString("text") + "</span>");
                sb.append("</div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + EFText.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                results.put("option", realDataJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{'text':'\u63d0\u793a\u6846',");
        sb.append("'backgroundColor':'#cccccc',");
        sb.append("'color':'#ffffff',");
        sb.append("'borderColor':'#000000',");
        sb.append("'fontSize':'12',");
        sb.append("'fontWeight':'normal',");
        sb.append("'fontStyle':'normal',");
        sb.append("'hori':'center',");
        sb.append("'verti':'middle',");
        sb.append("'fontFamily':'\u5b8b\u4f53'");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        path = path.replace(".html", ".plugin");
        long pluginTime = new Random().nextLong();
        if (pluginTime < 0L) {
            pluginTime = 0L - pluginTime;
        }
        StringBuffer sb = new StringBuffer();
        JSONObject optionObj = JSONObject.parseObject((String)option);
        boolean flag = true;
        String hori = optionObj.getString("hori");
        String horiF = hori.equals("left") ? "flex-start" : (hori.equals("right") ? "flex-end" : "center");
        String verti = optionObj.getString("verti");
        String vertiF = verti.equals("top") ? "flex-start" : (verti.equals("bottom") ? "flex-end" : "center");
        String text = optionObj.getString("text");
        String animation = optionObj.getString("animation");
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        JSONArray cssArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsBuffer.append(jsArray.toString());
        cssArray.add((Object)(jsResourcePath + "/animate.css"));
        cssBuffer.append(cssArray.toString());
        domBuffer.append("<div id='main_" + pluginTime + "' style='width:100%;height:100%;'>");
        if (animation == null) {
            domBuffer.append("<div id='but_" + pluginTime + "' style='display:flex;justify-content:" + horiF + ";align-items:" + vertiF + ";width:100%;height:100%;border:1px solid " + optionObj.getString("borderColor") + ";background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>");
        } else if (animation.equals("ef_null")) {
            domBuffer.append("<div id='but_" + pluginTime + "' style='display:flex;justify-content:" + horiF + ";align-items:" + vertiF + ";width:100%;height:100%;border:1px solid " + optionObj.getString("borderColor") + ";background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>");
        } else {
            domBuffer.append("<div id='but_" + pluginTime + "' class='animate__animated animate__" + animation + "' style='display:flex;justify-content:" + horiF + ";align-items:" + vertiF + ";width:100%;height:100%;border:1px solid " + optionObj.getString("borderColor") + ";background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>");
        }
        domBuffer.append(text);
        domBuffer.append("</div>");
        domBuffer.append("</div>");
        String originalStyle = "";
        originalStyle = originalStyle + "'display':'flex','justify-content':'" + horiF + "','align-items':'" + vertiF + "','width':'100%','height':'100%','border':'1px solid " + optionObj.getString("borderColor") + "','background-color':'" + optionObj.getString("backgroundColor") + "','font-size':'" + optionObj.getString("fontSize") + "px','color':'" + optionObj.getString("color") + "','font-family':'" + optionObj.getString("fontFamily") + "','font-style':'" + optionObj.getString("fontStyle") + "','font-weight':'" + optionObj.getString("fontWeight") + "'";
        String hoverStyle = optionObj.getString("hoverStyle");
        if (hoverStyle != null) {
            String proStyle = hoverStyle.trim();
            String proStyle1 = proStyle.replaceAll("\\n", "");
            String[] styles = proStyle1.split(";");
            scriptBuffer.append("$('#but_" + pluginTime + "').hover(function(){$(this).css({");
            if (!proStyle.isEmpty()) {
                for (int i = 0; i < styles.length; ++i) {
                    String[] st = styles[i].split(":");
                    if (i == styles.length - 1) {
                        scriptBuffer.append("'" + st[0] + "':'" + st[1] + "'");
                        continue;
                    }
                    scriptBuffer.append("'" + st[0] + "':'" + st[1] + "',");
                }
            }
            scriptBuffer.append("})},function(){$(this).css({" + originalStyle + "})})");
        }
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + pluginTime + " = [];");
            scriptBuffer.append("var obj_" + pluginTime + " = {};");
            scriptBuffer.append("var paramExpression_" + pluginTime + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + pluginTime + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + pluginTime + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + pluginTime + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + pluginTime + ".push(obj_" + pluginTime + ");");
            scriptBuffer.append("$('#but_" + pluginTime + "').bind('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + pluginTime + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){     changeParam += (key + '='" + text + "';')  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + pluginTime + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + pluginTime + ");");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("CONTROLVALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=" + text + ";";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("CONTROLVALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=" + text + ";";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("$('#main_" + pluginTime + "').click(function(){console.log(1212);Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + pluginTime + " = [];");
            scriptBuffer.append("var obj_" + pluginTime + " = {};");
            scriptBuffer.append("var paramExpression_" + pluginTime + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + pluginTime + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + pluginTime + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + pluginTime + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + pluginTime + ".push(obj_" + pluginTime + ");");
            scriptBuffer.append("$('#but_" + pluginTime + "').bind('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + pluginTime + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){     changeParam += (key + '='" + text + "';')  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + pluginTime + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + pluginTime + ",value);});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        JSONObject optionObj = JSONObject.parseObject((String)option);
        StringBuffer sb = new StringBuffer();
        String hori = optionObj.getString("hori");
        String horiF = hori.equals("left") ? "flex-start" : (hori.equals("right") ? "flex-end" : "center");
        String verti = optionObj.getString("verti");
        String vertiF = verti.equals("top") ? "flex-start" : (verti.equals("bottom") ? "flex-end" : "center");
        String text = optionObj.getString("text");
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-4.1.0.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'>");
        sb.append("<div id='but' style='display:flex;justify-content:" + horiF + ";align-items:" + vertiF + ";width:" + width + "px;height:" + height + "px;border:1px solid " + optionObj.getString("borderColor") + ";background-color:" + optionObj.getString("backgroundColor") + ";font-size:" + optionObj.getString("fontSize") + "px;color:" + optionObj.getString("color") + ";font-family:" + optionObj.getString("fontFamily") + ";font-style:" + optionObj.getString("fontStyle") + ";font-weight:" + optionObj.getString("fontWeight") + ";'>");
        sb.append("</div>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        if (width != 0 && height != 0) {
            sb.append("$('#but').html('" + text + "');");
            sb.append("$('#main').css('width',$(window.frameElement).attr('ow'));");
            sb.append("$('#main').css('height',$(window.frameElement).attr('oh'));");
            sb.append("$('#but').css('width',$(window.frameElement).attr('ow'));");
            sb.append("$('#but').css('height',$(window.frameElement).attr('oh'));");
        }
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u6587\u672c\u63a7\u4ef6";
    }

    public static String getClassName() {
        return "EFText";
    }

    public static void main(String[] args) {
        System.out.println(EFText.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        return option;
    }
}

