/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class DLine {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = DLine.generateDefaultOption();
            String clazzName = DLine.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + DLine.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONArray legend;
                JSONObject legendObject;
                JSONArray seriesArray;
                int i;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                optionJSON.put("categoryData1", realDataJSON.get((Object)"categoryData1"));
                optionJSON.put("seriesData1", realDataJSON.get((Object)"seriesData1"));
                optionJSON.put("valueData1", realDataJSON.get((Object)"valueData1"));
                optionJSON.put("labelFormatter", realDataJSON.get((Object)"labelFormatter"));
                optionJSON.put("labelFormatter1", realDataJSON.get((Object)"labelFormatter1"));
                if (optionJSON.containsKey((Object)"xAxis")) {
                    JSONArray xAxis = optionJSON.getJSONArray("xAxis");
                    for (i = 0; i < xAxis.size(); ++i) {
                        JSONObject xAxisObject = xAxis.getJSONObject(i);
                        if (!xAxisObject.containsKey((Object)"data")) continue;
                        xAxisObject.remove((Object)"data");
                    }
                }
                if (optionJSON.containsKey((Object)"series") && (seriesArray = optionJSON.getJSONArray("series")).size() > 0) {
                    for (i = 0; i < seriesArray.size(); ++i) {
                        JSONObject seriesObject = seriesArray.getJSONObject(i);
                        if (!seriesObject.containsKey((Object)"data")) continue;
                        seriesObject.remove((Object)"data");
                    }
                }
                if (optionJSON.containsKey((Object)"legend") && (legendObject = (legend = optionJSON.getJSONArray("legend")).getJSONObject(0)).containsKey((Object)"data")) {
                    legendObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{title:{");
        sb.append("    text:'\u6e29\u5ea6\u964d\u6c34\u56fe'");
        sb.append("},");
        sb.append("animation:false,");
        sb.append("initTimes:0,");
        sb.append("tooltip: {");
        sb.append("    trigger: 'axis',");
        sb.append("            axisPointer: {");
        sb.append("        type: 'cross',");
        sb.append("                crossStyle: {");
        sb.append("            color: '#999'");
        sb.append("        }");
        sb.append("    }");
        sb.append("},");
        sb.append("legend: {");
        sb.append("    data:['\u964d\u6c34\u91cf','\u5e73\u5747\u6e29\u5ea6'],type:'scroll'");
        sb.append("},");
        sb.append("xAxis: [");
        sb.append("{");
        sb.append("    type: 'category',");
        sb.append("            data: ['1\u6708','2\u6708','3\u6708','4\u6708','5\u6708','6\u6708','7\u6708','8\u6708','9\u6708','10\u6708','11\u6708','12\u6708'],");
        sb.append("    axisPointer: {");
        sb.append("        type: 'shadow'");
        sb.append("    }");
        sb.append("},");
        sb.append("{");
        sb.append("    type: 'category',");
        sb.append("            data: ['1\u6708','2\u6708','3\u6708','4\u6708','5\u6708','6\u6708','7\u6708','8\u6708','9\u6708','10\u6708','11\u6708','12\u6708'],");
        sb.append("    axisPointer: {");
        sb.append("        type: 'shadow'");
        sb.append("    }");
        sb.append("}");
        sb.append("],");
        sb.append("yAxis: [");
        sb.append("{");
        sb.append("    type: 'value'");
        sb.append("},");
        sb.append("{");
        sb.append("    type: 'value',");
        sb.append("}");
        sb.append("],");
        sb.append("series: [");
        sb.append("{");
        sb.append("    name:'\u964d\u6c34\u91cf',");
        sb.append("            type:'line',");
        sb.append("        data:[2.6, 5.9, 9.0, 26.4, 28.7, 70.7, 175.6, 182.2, 48.7, 18.8, 6.0, 2.3]");
        sb.append("},");
        sb.append("{");
        sb.append("    name:'\u5e73\u5747\u6e29\u5ea6',");
        sb.append("            type:'line',");
        sb.append("        yAxisIndex: 1,");
        sb.append("        data:[2.0, 2.2, 3.3, 4.5, 6.3, 10.2, 20.3, 23.4, 23.0, 16.5, 12.0, 6.2]");
        sb.append("}");
        sb.append("]}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        JSONObject backColorObj;
        path = path.replace(".html", ".plugin");
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String stack = optionObject.getString("stack");
        String stack1 = optionObject.getString("stack1");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        boolean flag = true;
        if (valueData.equals("")) {
            return 1;
        }
        if (valueData.indexOf(",") > -1) {
            String[] values = valueData.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals("0")) continue;
                flag = false;
                break;
            }
            if (flag) {
                return 1;
            }
        } else if (valueData.equals("0")) {
            return 1;
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        String categoryData1 = (String)optionObject.get((Object)"categoryData1");
        String seriesData1 = (String)optionObject.get((Object)"seriesData1");
        String valueData1 = (String)optionObject.get((Object)"valueData1");
        String labelFormatter1 = (String)optionObject.get((Object)"labelFormatter1");
        if (valueData1.equals("")) {
            return 1;
        }
        if (valueData1.indexOf(",") > -1) {
            String[] values = valueData1.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals("0")) continue;
                flag = false;
                break;
            }
            if (flag) {
                return 1;
            }
        } else if (valueData1.equals("0")) {
            return 1;
        }
        String showSeriesLabel = optionObject.getString("showSeriesLabel");
        String showSeriesLabel1 = optionObject.getString("showSeriesLabel1");
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legendObject = legendArray.getJSONObject(0);
        JSONArray dataArray = new JSONArray();
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
            dataArray.add(seriesList.get(i));
        }
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String smooth = (String)optionObject.get((Object)"smooth");
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            seriesObject.put("type", (Object)"line");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (smooth != null && "true".equals(smooth)) {
                seriesObject.put("smooth", (Object)true);
            }
            if (stack != null && "true".equals(stack)) {
                seriesObject.put("stack", (Object)"\u603b\u91cf");
                seriesObject.put("areaStyle", (Object)new JSONObject());
            }
            JSONObject labelObject = new JSONObject();
            if (showSeriesLabel != null) {
                if (showSeriesLabel.equals("true")) {
                    labelObject.put("show", (Object)true);
                } else {
                    labelObject.put("show", (Object)false);
                }
            }
            labelObject.put("formatter", (Object)labelFormatter);
            seriesObject.put("label", (Object)labelObject);
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        String smooth1 = (String)optionObject.get((Object)"smooth1");
        ArrayList<String> categoryList1 = new ArrayList<String>();
        String[] categoryStrs1 = categoryData1.split(",");
        for (int i = 0; i < categoryStrs1.length; ++i) {
            if (categoryList1.contains(categoryStrs1[i])) continue;
            categoryList1.add(categoryStrs1[i]);
        }
        String[] categoryDatas1 = new String[categoryList1.size()];
        for (int i = 0; i < categoryDatas1.length; ++i) {
            categoryDatas1[i] = (String)categoryList1.get(i);
        }
        ArrayList<String> seriesList1 = new ArrayList<String>();
        String[] seriesStrs1 = seriesData1.split(",");
        for (int i = 0; i < seriesStrs1.length; ++i) {
            if (seriesList1.contains(seriesStrs1[i])) continue;
            seriesList1.add(seriesStrs1[i]);
        }
        String[] seriesDatas1 = new String[seriesList1.size()];
        for (int i = 0; i < seriesDatas1.length; ++i) {
            seriesDatas1[i] = (String)seriesList1.get(i);
            dataArray.add(seriesList1.get(i));
        }
        legendObject.put("data", (Object)dataArray);
        JSONArray categoryArray1 = new JSONArray();
        for (int i = 0; i < categoryDatas1.length; ++i) {
            categoryArray1.add((Object)categoryDatas1[i]);
        }
        JSONArray xAxisArray1 = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject1 = xAxisArray.getJSONObject(1);
        xAxisObject1.put("data", (Object)categoryArray1);
        String[] valueDatas1 = valueData1.split(",");
        for (int i = 0; i < seriesDatas1.length; ++i) {
            JSONObject seriesObject1 = new JSONObject();
            seriesObject1.put("type", (Object)"line");
            seriesObject1.put("name", (Object)seriesDatas1[i]);
            seriesObject1.put("xAxisIndex", (Object)1);
            seriesObject1.put("yAxisIndex", (Object)1);
            if (smooth1 != null && "true".equals(smooth1)) {
                seriesObject1.put("smooth", (Object)true);
            }
            if (stack1 != null && "true".equals(stack1)) {
                seriesObject1.put("stack", (Object)"\u603b\u91cf");
                seriesObject1.put("areaStyle", (Object)new JSONObject());
            }
            JSONObject labelObject1 = new JSONObject();
            if (showSeriesLabel1 != null) {
                if (showSeriesLabel1.equals("true")) {
                    labelObject1.put("show", (Object)true);
                } else {
                    labelObject1.put("show", (Object)false);
                }
            }
            labelObject1.put("formatter", (Object)labelFormatter1);
            seriesObject1.put("label", (Object)labelObject1);
            JSONArray seriesDataArray1 = new JSONArray();
            for (int j = 0; j < categoryDatas1.length; ++j) {
                seriesDataArray1.add((Object)valueDatas1[i + j * seriesDatas1.length]);
            }
            seriesObject1.put("data", (Object)seriesDataArray1);
            seriesArray.add((Object)seriesObject1);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsonArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsBuffer.append(jsonArray.toString());
        cssBuffer.append(new JSONArray().toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);});");
        }
        sb.append("$('#main_" + time + "').on('dblclick' , function(params){var pWidth = $(window.parent.document).find('.x-data-bg_block').width();var pHeight = $(window.parent.document).find('.x-data-bg_block').height();var url = $(window.frameElement).attr('src');Link.Fn.layerOpen(pWidth , pHeight , url);});");
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        JSONObject backColorObj;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String stack = optionObject.getString("stack");
        String stack1 = optionObject.getString("stack1");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        boolean flag = true;
        if (valueData.equals("")) {
            return 1;
        }
        if (valueData.indexOf(",") > -1) {
            String[] values = valueData.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals("0")) continue;
                flag = false;
                break;
            }
            if (flag) {
                return 1;
            }
        } else if (valueData.equals("0")) {
            return 1;
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        String categoryData1 = (String)optionObject.get((Object)"categoryData1");
        String seriesData1 = (String)optionObject.get((Object)"seriesData1");
        String valueData1 = (String)optionObject.get((Object)"valueData1");
        String labelFormatter1 = (String)optionObject.get((Object)"labelFormatter1");
        if (valueData1.equals("")) {
            return 1;
        }
        if (valueData1.indexOf(",") > -1) {
            String[] values = valueData1.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals("0")) continue;
                flag = false;
                break;
            }
            if (flag) {
                return 1;
            }
        } else if (valueData1.equals("0")) {
            return 1;
        }
        String showSeriesLabel = optionObject.getString("showSeriesLabel");
        String showSeriesLabel1 = optionObject.getString("showSeriesLabel1");
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legendObject = legendArray.getJSONObject(0);
        JSONArray dataArray = new JSONArray();
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
            dataArray.add(seriesList.get(i));
        }
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String smooth = (String)optionObject.get((Object)"smooth");
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            seriesObject.put("type", (Object)"line");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (smooth != null && "true".equals(smooth)) {
                seriesObject.put("smooth", (Object)true);
            }
            if (stack != null && "true".equals(stack)) {
                seriesObject.put("stack", (Object)"\u603b\u91cf");
                seriesObject.put("areaStyle", (Object)new JSONObject());
            }
            JSONObject labelObject = new JSONObject();
            if (showSeriesLabel != null) {
                if (showSeriesLabel.equals("true")) {
                    labelObject.put("show", (Object)true);
                } else {
                    labelObject.put("show", (Object)false);
                }
            }
            labelObject.put("formatter", (Object)labelFormatter);
            seriesObject.put("label", (Object)labelObject);
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        String smooth1 = (String)optionObject.get((Object)"smooth1");
        ArrayList<String> categoryList1 = new ArrayList<String>();
        String[] categoryStrs1 = categoryData1.split(",");
        for (int i = 0; i < categoryStrs1.length; ++i) {
            if (categoryList1.contains(categoryStrs1[i])) continue;
            categoryList1.add(categoryStrs1[i]);
        }
        String[] categoryDatas1 = new String[categoryList1.size()];
        for (int i = 0; i < categoryDatas1.length; ++i) {
            categoryDatas1[i] = (String)categoryList1.get(i);
        }
        ArrayList<String> seriesList1 = new ArrayList<String>();
        String[] seriesStrs1 = seriesData1.split(",");
        for (int i = 0; i < seriesStrs1.length; ++i) {
            if (seriesList1.contains(seriesStrs1[i])) continue;
            seriesList1.add(seriesStrs1[i]);
        }
        String[] seriesDatas1 = new String[seriesList1.size()];
        for (int i = 0; i < seriesDatas1.length; ++i) {
            seriesDatas1[i] = (String)seriesList1.get(i);
            dataArray.add(seriesList1.get(i));
        }
        legendObject.put("data", (Object)dataArray);
        JSONArray categoryArray1 = new JSONArray();
        for (int i = 0; i < categoryDatas1.length; ++i) {
            categoryArray1.add((Object)categoryDatas1[i]);
        }
        JSONArray xAxisArray1 = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject1 = xAxisArray.getJSONObject(1);
        xAxisObject1.put("data", (Object)categoryArray1);
        String[] valueDatas1 = valueData1.split(",");
        for (int i = 0; i < seriesDatas1.length; ++i) {
            JSONObject seriesObject1 = new JSONObject();
            seriesObject1.put("type", (Object)"line");
            seriesObject1.put("name", (Object)seriesDatas1[i]);
            seriesObject1.put("xAxisIndex", (Object)1);
            seriesObject1.put("yAxisIndex", (Object)1);
            if (smooth1 != null && "true".equals(smooth1)) {
                seriesObject1.put("smooth", (Object)true);
            }
            if (stack1 != null && "true".equals(stack1)) {
                seriesObject1.put("stack", (Object)"\u603b\u91cf");
                seriesObject1.put("areaStyle", (Object)new JSONObject());
            }
            JSONObject labelObject1 = new JSONObject();
            if (showSeriesLabel1 != null) {
                if (showSeriesLabel1.equals("true")) {
                    labelObject1.put("show", (Object)true);
                } else {
                    labelObject1.put("show", (Object)false);
                }
            }
            labelObject1.put("formatter", (Object)labelFormatter1);
            seriesObject1.put("label", (Object)labelObject1);
            JSONArray seriesDataArray1 = new JSONArray();
            for (int j = 0; j < categoryDatas1.length; ++j) {
                seriesDataArray1.add((Object)valueDatas1[i + j * seriesDatas1.length]);
            }
            seriesObject1.put("data", (Object)seriesDataArray1);
            seriesArray.add((Object)seriesObject1);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(optionObject.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String stack = optionObject.getString("stack");
        String stack1 = optionObject.getString("stack1");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        boolean flag = true;
        if (valueData.equals("")) {
            return "error";
        }
        if (valueData.indexOf(",") > -1) {
            String[] values = valueData.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals("0")) continue;
                flag = false;
                break;
            }
            if (flag) {
                return "error";
            }
        } else if (valueData.equals("0")) {
            return "error";
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        String categoryData1 = (String)optionObject.get((Object)"categoryData1");
        String seriesData1 = (String)optionObject.get((Object)"seriesData1");
        String valueData1 = (String)optionObject.get((Object)"valueData1");
        String labelFormatter1 = (String)optionObject.get((Object)"labelFormatter1");
        if (valueData1.equals("")) {
            return "error";
        }
        if (valueData1.indexOf(",") > -1) {
            String[] values = valueData1.split(",");
            for (int i = 0; i < values.length; ++i) {
                if (values[i].equals("0")) continue;
                flag = false;
                break;
            }
            if (flag) {
                return "error";
            }
        } else if (valueData1.equals("0")) {
            return "error";
        }
        String showSeriesLabel = optionObject.getString("showSeriesLabel");
        String showSeriesLabel1 = optionObject.getString("showSeriesLabel1");
        JSONArray legendArray = optionObject.getJSONArray("legend");
        JSONObject legendObject = legendArray.getJSONObject(0);
        JSONArray dataArray = new JSONArray();
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
            dataArray.add(seriesList.get(i));
        }
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String smooth = (String)optionObject.get((Object)"smooth");
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            seriesObject.put("type", (Object)"line");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (smooth != null && "true".equals(smooth)) {
                seriesObject.put("smooth", (Object)true);
            }
            if (stack != null && "true".equals(stack)) {
                seriesObject.put("stack", (Object)"\u603b\u91cf");
                seriesObject.put("areaStyle", (Object)new JSONObject());
            }
            JSONObject labelObject = new JSONObject();
            if (showSeriesLabel != null) {
                if (showSeriesLabel.equals("true")) {
                    labelObject.put("show", (Object)true);
                } else {
                    labelObject.put("show", (Object)false);
                }
            }
            labelObject.put("formatter", (Object)labelFormatter);
            seriesObject.put("label", (Object)labelObject);
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        String smooth1 = (String)optionObject.get((Object)"smooth1");
        ArrayList<String> categoryList1 = new ArrayList<String>();
        String[] categoryStrs1 = categoryData1.split(",");
        for (int i = 0; i < categoryStrs1.length; ++i) {
            if (categoryList1.contains(categoryStrs1[i])) continue;
            categoryList1.add(categoryStrs1[i]);
        }
        String[] categoryDatas1 = new String[categoryList1.size()];
        for (int i = 0; i < categoryDatas1.length; ++i) {
            categoryDatas1[i] = (String)categoryList1.get(i);
        }
        ArrayList<String> seriesList1 = new ArrayList<String>();
        String[] seriesStrs1 = seriesData1.split(",");
        for (int i = 0; i < seriesStrs1.length; ++i) {
            if (seriesList1.contains(seriesStrs1[i])) continue;
            seriesList1.add(seriesStrs1[i]);
        }
        String[] seriesDatas1 = new String[seriesList1.size()];
        for (int i = 0; i < seriesDatas1.length; ++i) {
            seriesDatas1[i] = (String)seriesList1.get(i);
            dataArray.add(seriesList1.get(i));
        }
        legendObject.put("data", (Object)dataArray);
        JSONArray categoryArray1 = new JSONArray();
        for (int i = 0; i < categoryDatas1.length; ++i) {
            categoryArray1.add((Object)categoryDatas1[i]);
        }
        JSONArray xAxisArray1 = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject1 = xAxisArray.getJSONObject(1);
        xAxisObject1.put("data", (Object)categoryArray1);
        String[] valueDatas1 = valueData1.split(",");
        for (int i = 0; i < seriesDatas1.length; ++i) {
            JSONObject seriesObject1 = new JSONObject();
            seriesObject1.put("type", (Object)"line");
            seriesObject1.put("name", (Object)seriesDatas1[i]);
            seriesObject1.put("xAxisIndex", (Object)1);
            seriesObject1.put("yAxisIndex", (Object)1);
            if (smooth1 != null && "true".equals(smooth1)) {
                seriesObject1.put("smooth", (Object)true);
            }
            if (stack1 != null && "true".equals(stack1)) {
                seriesObject1.put("stack", (Object)"\u603b\u91cf");
                seriesObject1.put("areaStyle", (Object)new JSONObject());
            }
            JSONObject labelObject1 = new JSONObject();
            if (showSeriesLabel1 != null) {
                if (showSeriesLabel1.equals("true")) {
                    labelObject1.put("show", (Object)true);
                } else {
                    labelObject1.put("show", (Object)false);
                }
            }
            labelObject1.put("formatter", (Object)labelFormatter1);
            seriesObject1.put("label", (Object)labelObject1);
            JSONArray seriesDataArray1 = new JSONArray();
            for (int j = 0; j < categoryDatas1.length; ++j) {
                seriesDataArray1.add((Object)valueDatas1[i + j * seriesDatas1.length]);
            }
            seriesObject1.put("data", (Object)seriesDataArray1);
            seriesArray.add((Object)seriesObject1);
        }
        optionObject.put("series", (Object)seriesArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u53cc\u6298\u7ebf\u56fe";
    }

    public static String getClassName() {
        return "DLine";
    }

    public static void main(String[] args) {
        System.out.println(DLine.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)DLine.generateDefaultOption());
        JSONArray seriesDefaultArray = (JSONArray)defaultJson.get((Object)"series");
        JSONArray seriesOptionArray = (JSONArray)optionJson.get((Object)"series");
        for (int i = 0; i < seriesDefaultArray.size(); ++i) {
            JSONObject defaultSeries = seriesDefaultArray.getJSONObject(i);
            JSONObject optionSeries = seriesOptionArray.getJSONObject(i);
            optionSeries.put("data", (Object)defaultSeries.getJSONArray("data"));
        }
        JSONArray xAxisDefaultArray = (JSONArray)defaultJson.get((Object)"xAxis");
        JSONArray xAxisOptionArray = (JSONArray)optionJson.get((Object)"xAxis");
        for (int i = 0; i < xAxisDefaultArray.size(); ++i) {
            JSONObject defaultSeries = xAxisDefaultArray.getJSONObject(i);
            JSONObject optionSeries = xAxisOptionArray.getJSONObject(i);
            optionSeries.put("data", (Object)defaultSeries.getJSONArray("data"));
        }
        return optionJson.toString();
    }
}

