/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class Bar {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = Bar.generateDefaultOption();
            String clazzName = Bar.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                File htmlFile = new File(htmlPath);
                htmlFile.createNewFile();
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>");
                sb.append("<html lang='zh-cmn-Hans'>");
                sb.append("<head>");
                sb.append(" <meta charset='UTF-8'>");
                sb.append("        <meta http-equiv='pragma' content='no-cache'>");
                sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
                sb.append("        <meta http-equiv='expires' content='0'>");
                sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
                sb.append("        <meta name='format-detection' content='telephone=no'>");
                sb.append("        <meta name='format-detection' content='email=no'>");
                sb.append("        <meta name='format-detection' content='adress=no'>");
                sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
                sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
                sb.append("</head>");
                sb.append("<body style='margin:0px;padding:0px;'>");
                sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
                sb.append("</body>");
                sb.append("<script type='text/javascript'>");
                sb.append("var myChart = echarts.init(document.getElementById('main'));");
                sb.append("var option = ");
                sb.append(option + ";");
                sb.append("myChart.setOption(option);");
                sb.append("</script>");
                sb.append("</html>");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
                writer.write(sb.toString());
                ((Writer)writer).flush();
                ((Writer)writer).close();
                htmlPath = htmlPath.replaceAll("\\\\", "/");
                pngPath = pngPath.replaceAll("\\\\", "/");
                htmlPath = htmlPath.replaceAll("//", "/");
                pngPath = pngPath.replaceAll("//", "/");
                int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
                if (result == 0) {
                    String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                    results.put("state", "success");
                    results.put("imageCode", base64Code);
                    results.put("option", option);
                } else {
                    results.put("state", "failed");
                }
                if (htmlFile.exists()) {
                    htmlFile.delete();
                }
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Bar.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                JSONArray legend;
                JSONObject legendObject;
                JSONArray yAxis;
                JSONObject yAxisObject;
                JSONArray xAxis;
                JSONObject xAxisObject;
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("categoryData", realDataJSON.get((Object)"categoryData"));
                optionJSON.put("seriesData", realDataJSON.get((Object)"seriesData"));
                optionJSON.put("valueData", realDataJSON.get((Object)"valueData"));
                optionJSON.put("labelFormatter", realDataJSON.get((Object)"labelFormatter"));
                optionJSON.put("barWidth", realDataJSON.get((Object)"barWidth"));
                optionJSON.put("showAve", realDataJSON.get((Object)"showAve"));
                optionJSON.put("showMM", realDataJSON.get((Object)"showMM"));
                if (optionJSON.containsKey((Object)"xAxis") && (xAxisObject = (xAxis = optionJSON.getJSONArray("xAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    xAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"yAxis") && (yAxisObject = (yAxis = optionJSON.getJSONArray("yAxis")).getJSONObject(0)).containsKey((Object)"data")) {
                    yAxisObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"series")) {
                    JSONObject seriesObject;
                    JSONArray seriesArray = optionJSON.getJSONArray("series");
                    if (seriesArray.size() > 0 && (seriesObject = seriesArray.getJSONObject(0)).containsKey((Object)"label")) {
                        JSONObject labelObject = seriesObject.getJSONObject("label");
                        if (labelObject.containsKey((Object)"show")) {
                            boolean flag = labelObject.getBoolean("show");
                            optionJSON.put("labelShow", (Object)flag);
                        }
                        if (labelObject.containsKey((Object)"color")) {
                            String labelColor = labelObject.getString("color");
                            optionJSON.put("labelColor", (Object)labelColor);
                        }
                        if (labelObject.containsKey((Object)"fontSize")) {
                            String fontSize = labelObject.getString("fontSize");
                            optionJSON.put("labelSize", (Object)fontSize);
                        }
                    }
                    optionJSON.remove((Object)"series");
                }
                if (optionJSON.containsKey((Object)"legend") && (legendObject = (legend = optionJSON.getJSONArray("legend")).getJSONObject(0)).containsKey((Object)"data")) {
                    legendObject.remove((Object)"data");
                }
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{title:{text:'\u9500\u91cf\u56fe',padding:0},");
        sb.append("animation:false,");
        sb.append("initTimes:0,");
        sb.append("tooltip:{show:false},");
        sb.append("legend:{data:['\u82f9\u679c', '\u9999\u8549'],type:'scroll'},");
        sb.append("xAxis: {type: 'category', data: ['2011', '2012', '2013', '2014', '2015', '2016', '2017']},");
        sb.append("yAxis: {type: 'value'},");
        sb.append("series: [");
        sb.append("{name:'\u82f9\u679c', data: [120, 200, 150, 80, 70, 110, 130],type: 'bar',label:{show:false}},");
        sb.append("{name:'\u9999\u8549', data:[130,210,160,90,80,120,140],type:'bar',label:{show:false}}");
        sb.append("]}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        Set keySet;
        JSONObject hyperLinkObj;
        JSONObject backColorObj;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        path = path.replace(".html", ".plugin");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        if (valueData.equals("")) {
            return 0;
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        String type = (String)optionObject.get((Object)"chartType");
        String labelShow = optionObject.getString("labelShow");
        String labelColor = optionObject.getString("labelColor");
        String labelSize = optionObject.getString("labelSize");
        String showAve = optionObject.getString("showAve");
        String showMM = optionObject.getString("showMM");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            seriesObject.put("type", (Object)"bar");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (labelShow != null && "true".equals(labelShow)) {
                JSONObject seriesObj;
                JSONObject labelObj = new JSONObject();
                labelObj.put("show", (Object)true);
                labelObj.put("formatter", (Object)labelFormatter);
                if (labelColor != null) {
                    labelObj.put("color", (Object)labelColor);
                }
                if (labelSize != null) {
                    labelObj.put("fontSize", (Object)labelSize);
                }
                if ((seriesObj = seriesObject.getJSONObject("label")) != null) {
                    Set set = seriesObj.entrySet();
                    for (Map.Entry entry : set) {
                        String name = (String)entry.getKey();
                        if (name.equals("color") || name.equals("show") || name.equals("formatter") || name.equals("fontSize")) continue;
                        labelObj.put(name, entry.getValue());
                    }
                }
                seriesObject.put("label", (Object)labelObj);
            }
            if (type != null && "stack".equals(type)) {
                seriesObject.put("stack", (Object)"\u603b\u91cf");
            }
            if ("Y".equals(showMM)) {
                JSONObject markDataObj = new JSONObject();
                JSONArray markDataArray = new JSONArray();
                JSONObject maxObj = new JSONObject();
                maxObj.put("type", (Object)"max");
                maxObj.put("name", (Object)"\u6700\u5927\u503c");
                markDataArray.add((Object)maxObj);
                JSONObject minObj = new JSONObject();
                minObj.put("type", (Object)"min");
                minObj.put("name", (Object)"\u6700\u5c0f\u503c");
                markDataArray.add((Object)minObj);
                markDataObj.put("data", (Object)markDataArray);
                seriesObject.put("markPoint", (Object)markDataObj);
            }
            if ("Y".equals(showAve)) {
                JSONObject markLineObj = new JSONObject();
                JSONArray markLineDataArray = new JSONArray();
                JSONObject aveObj = new JSONObject();
                aveObj.put("type", (Object)"average");
                aveObj.put("name", (Object)"\u5e73\u5747\u503c");
                markLineDataArray.add((Object)aveObj);
                markLineObj.put("data", (Object)markLineDataArray);
                seriesObject.put("markLine", (Object)markLineObj);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        optionObject.remove((Object)"markPoint");
        optionObject.remove((Object)"markLine");
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer cssBuffer = new StringBuffer();
        StringBuffer domBuffer = new StringBuffer();
        StringBuffer jsBuffer = new StringBuffer();
        StringBuffer scriptBuffer = new StringBuffer();
        JSONArray jsArray = new JSONArray();
        jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
        jsArray.add((Object)(jsResourcePath + "/echarts-5.4.2.min.js"));
        jsBuffer.append(jsArray.toString());
        JSONArray cssArray = new JSONArray();
        cssArray.add((Object)(jsResourcePath + "/animate.css"));
        cssBuffer.append(cssArray.toString());
        long time = new Random().nextLong();
        if (time < 0L) {
            time = 0L - time;
        }
        domBuffer.append("<div id='main_" + time + "' style='width:100%;height:100%;'></div>");
        scriptBuffer.append("var myChart_" + time + " = echarts.init(document.getElementById('main_" + time + "'));");
        scriptBuffer.append("var option_" + time + " = ");
        scriptBuffer.append(optionObject.toString());
        scriptBuffer.append(";");
        scriptBuffer.append("myChart_" + time + ".setOption(option_" + time + ");");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        String repaintRegions = reportInfoObj.getString("repaintRegions");
        JSONObject repaintRegionsObj = JSONObject.parseObject((String)repaintRegions);
        if (hyperLinkArray != null && repaintRegionsObj != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ");");
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1');");
            scriptBuffer.append("});");
        } else if (repaintRegionsObj != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if (!"CONTROLVALUE".equals(key) && !"X-AXIS".equals(key) && !"Y-AXIS".equals(key)) continue;
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        } else if (hyperLinkArray != null) {
            scriptBuffer.append("var hyperLinkArray_" + time + " = [];");
            scriptBuffer.append("var obj_" + time + " = {};");
            scriptBuffer.append("var paramExpression_" + time + " ;");
            hyperLinkObj = hyperLinkArray.getJSONObject(0);
            keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    scriptBuffer.append("obj_" + time + "." + key + "=" + value + ";");
                    continue;
                }
                scriptBuffer.append("obj_" + time + "." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                scriptBuffer.append("paramExpression_" + time + " = '" + value + "';");
            }
            scriptBuffer.append("hyperLinkArray_" + time + ".push(obj_" + time + ");");
            scriptBuffer.append("myChart_" + time + ".on('click', function (params) {var changeParam='';var hyperParam = paramExpression_" + time + ";var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}hyperLinkArray_" + time + "[0].Params = changeParam;Link.Fn.hyperlink(hyperLinkArray_" + time + ",value);});");
        }
        JSONObject pluginInfo = new JSONObject();
        pluginInfo.put("dom", (Object)domBuffer.toString());
        pluginInfo.put("css", (Object)cssBuffer.toString());
        pluginInfo.put("js", (Object)jsBuffer.toString());
        pluginInfo.put("script", (Object)scriptBuffer.toString());
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static int generatePluginData(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        JSONObject backColorObj;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        if (valueData.equals("")) {
            return 0;
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        String type = (String)optionObject.get((Object)"chartType");
        String labelShow = optionObject.getString("labelShow");
        String labelColor = optionObject.getString("labelColor");
        String labelSize = optionObject.getString("labelSize");
        String showAve = optionObject.getString("showAve");
        String showMM = optionObject.getString("showMM");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            seriesObject.put("type", (Object)"bar");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (labelShow != null && "true".equals(labelShow)) {
                JSONObject seriesObj;
                JSONObject labelObj = new JSONObject();
                labelObj.put("show", (Object)true);
                labelObj.put("formatter", (Object)labelFormatter);
                if (labelColor != null) {
                    labelObj.put("color", (Object)labelColor);
                }
                if (labelSize != null) {
                    labelObj.put("fontSize", (Object)labelSize);
                }
                if ((seriesObj = seriesObject.getJSONObject("label")) != null) {
                    Set set = seriesObj.entrySet();
                    for (Map.Entry entry : set) {
                        String name = (String)entry.getKey();
                        if (name.equals("color") || name.equals("show") || name.equals("formatter") || name.equals("fontSize")) continue;
                        labelObj.put(name, entry.getValue());
                    }
                }
                seriesObject.put("label", (Object)labelObj);
            }
            if (type != null && "stack".equals(type)) {
                seriesObject.put("stack", (Object)"\u603b\u91cf");
            }
            if ("Y".equals(showMM)) {
                JSONObject markDataObj = new JSONObject();
                JSONArray markDataArray = new JSONArray();
                JSONObject maxObj = new JSONObject();
                maxObj.put("type", (Object)"max");
                maxObj.put("name", (Object)"\u6700\u5927\u503c");
                markDataArray.add((Object)maxObj);
                JSONObject minObj = new JSONObject();
                minObj.put("type", (Object)"min");
                minObj.put("name", (Object)"\u6700\u5c0f\u503c");
                markDataArray.add((Object)minObj);
                markDataObj.put("data", (Object)markDataArray);
                seriesObject.put("markPoint", (Object)markDataObj);
            }
            if ("Y".equals(showAve)) {
                JSONObject markLineObj = new JSONObject();
                JSONArray markLineDataArray = new JSONArray();
                JSONObject aveObj = new JSONObject();
                aveObj.put("type", (Object)"average");
                aveObj.put("name", (Object)"\u5e73\u5747\u503c");
                markLineDataArray.add((Object)aveObj);
                markLineObj.put("data", (Object)markLineDataArray);
                seriesObject.put("markLine", (Object)markLineObj);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        optionObject.remove((Object)"markPoint");
        optionObject.remove((Object)"markLine");
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(optionObject.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String categoryData = (String)optionObject.get((Object)"categoryData");
        String seriesData = (String)optionObject.get((Object)"seriesData");
        String valueData = (String)optionObject.get((Object)"valueData");
        String labelFormatter = (String)optionObject.get((Object)"labelFormatter");
        if (valueData.equals("")) {
            return "error";
        }
        String defString = optionObject.getString("defCode");
        JSONObject defObject = JSONObject.parseObject((String)defString);
        String type = (String)optionObject.get((Object)"chartType");
        String labelShow = optionObject.getString("labelShow");
        String labelColor = optionObject.getString("labelColor");
        String labelSize = optionObject.getString("labelSize");
        String showAve = optionObject.getString("showAve");
        String showMM = optionObject.getString("showMM");
        ArrayList<String> categoryList = new ArrayList<String>();
        String[] categoryStrs = categoryData.split(",");
        for (int i = 0; i < categoryStrs.length; ++i) {
            if (categoryList.contains(categoryStrs[i])) continue;
            categoryList.add(categoryStrs[i]);
        }
        String[] categoryDatas = new String[categoryList.size()];
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryDatas[i] = (String)categoryList.get(i);
        }
        ArrayList<String> seriesList = new ArrayList<String>();
        String[] seriesStrs = seriesData.split(",");
        for (int i = 0; i < seriesStrs.length; ++i) {
            if (seriesList.contains(seriesStrs[i])) continue;
            seriesList.add(seriesStrs[i]);
        }
        String[] seriesDatas = new String[seriesList.size()];
        for (int i = 0; i < seriesDatas.length; ++i) {
            seriesDatas[i] = (String)seriesList.get(i);
        }
        JSONArray categoryArray = new JSONArray();
        for (int i = 0; i < categoryDatas.length; ++i) {
            categoryArray.add((Object)categoryDatas[i]);
        }
        JSONArray xAxisArray = optionObject.getJSONArray("xAxis");
        JSONObject xAxisObject = xAxisArray.getJSONObject(0);
        xAxisObject.put("data", (Object)categoryArray);
        String[] valueDatas = valueData.split(",");
        JSONArray seriesArray = new JSONArray();
        JSONArray seriesDefArray = new JSONArray();
        if (defObject != null) {
            seriesDefArray = defObject.getJSONArray("series");
        }
        for (int i = 0; i < seriesDatas.length; ++i) {
            JSONObject seriesDefObj;
            JSONObject seriesObject = new JSONObject();
            if (seriesDefArray != null && !seriesDefArray.isEmpty() && i < seriesDefArray.size() && (seriesDefObj = seriesDefArray.getJSONObject(i)) != null) {
                for (String key : seriesDefObj.keySet()) {
                    seriesObject.put(key, seriesDefObj.get((Object)key));
                }
            }
            seriesObject.put("type", (Object)"bar");
            seriesObject.put("name", (Object)seriesDatas[i]);
            if (labelShow != null && "true".equals(labelShow)) {
                JSONObject seriesObj;
                JSONObject labelObj = new JSONObject();
                labelObj.put("show", (Object)true);
                labelObj.put("formatter", (Object)labelFormatter);
                if (labelColor != null) {
                    labelObj.put("color", (Object)labelColor);
                }
                if (labelSize != null) {
                    labelObj.put("fontSize", (Object)labelSize);
                }
                if ((seriesObj = seriesObject.getJSONObject("label")) != null) {
                    Set set = seriesObj.entrySet();
                    for (Map.Entry entry : set) {
                        String name = (String)entry.getKey();
                        if (name.equals("color") || name.equals("show") || name.equals("formatter") || name.equals("fontSize")) continue;
                        labelObj.put(name, entry.getValue());
                    }
                }
                seriesObject.put("label", (Object)labelObj);
            }
            if (type != null && "stack".equals(type)) {
                seriesObject.put("stack", (Object)"\u603b\u91cf");
            }
            if ("Y".equals(showMM)) {
                JSONObject markDataObj = new JSONObject();
                JSONArray markDataArray = new JSONArray();
                JSONObject maxObj = new JSONObject();
                maxObj.put("type", (Object)"max");
                maxObj.put("name", (Object)"\u6700\u5927\u503c");
                markDataArray.add((Object)maxObj);
                JSONObject minObj = new JSONObject();
                minObj.put("type", (Object)"min");
                minObj.put("name", (Object)"\u6700\u5c0f\u503c");
                markDataArray.add((Object)minObj);
                markDataObj.put("data", (Object)markDataArray);
                seriesObject.put("markPoint", (Object)markDataObj);
            }
            if ("Y".equals(showAve)) {
                JSONObject markLineObj = new JSONObject();
                JSONArray markLineDataArray = new JSONArray();
                JSONObject aveObj = new JSONObject();
                aveObj.put("type", (Object)"average");
                aveObj.put("name", (Object)"\u5e73\u5747\u503c");
                markLineDataArray.add((Object)aveObj);
                markLineObj.put("data", (Object)markLineDataArray);
                seriesObject.put("markLine", (Object)markLineObj);
            }
            JSONArray seriesDataArray = new JSONArray();
            for (int j = 0; j < categoryDatas.length; ++j) {
                seriesDataArray.add((Object)valueDatas[i + j * seriesDatas.length]);
            }
            seriesObject.put("data", (Object)seriesDataArray);
            seriesArray.add((Object)seriesObject);
        }
        optionObject.put("series", (Object)seriesArray);
        optionObject.put("animation", (Object)false);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>\n");
        sb.append("function refresh(option){");
        sb.append("  console.log(option);var myChart = echarts.init(document.getElementById('main'));");
        sb.append("  myChart.setOption(option);");
        sb.append("}\n");
        sb.append("$(document).ready(function(){");
        sb.append("$('#main').css('width',$(window.frameElement).attr('ow')==undefined?$(window.frameElement).width():$(window.frameElement).attr('ow'));");
        sb.append("$('#main').css('height',$(window.frameElement).attr('oh')==undefined?$(window.frameElement).height():$(window.frameElement).attr('oh'));");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append("var option = ");
        sb.append(optionObject.toString());
        sb.append(";");
        sb.append("myChart.setOption(option);");
        sb.append("window.addEventListener('resize',function(){");
        sb.append("    myChart.resize();");
        sb.append("});");
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u67f1\u72b6\u56fe";
    }

    public static String getClassName() {
        return "Bar";
    }

    public static void main(String[] args) {
        System.out.println(Bar.generateDefaultOption());
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)Bar.generateDefaultOption());
        JSONArray xAxisArray = optionJson.getJSONArray("xAxis");
        JSONObject xAxisObj = xAxisArray.getJSONObject(0);
        JSONObject xAxisDefaultObj = (JSONObject)defaultJson.get((Object)"xAxis");
        xAxisObj.put("data", xAxisDefaultObj.get((Object)"data"));
        JSONArray seriesDefaultObj = (JSONArray)defaultJson.get((Object)"series");
        if (optionJson.containsKey((Object)"labelShow")) {
            boolean flag = optionJson.getBoolean("labelShow");
            for (int i = 0; i < seriesDefaultObj.size(); ++i) {
                JSONObject seriesObject = seriesDefaultObj.getJSONObject(i);
                JSONObject labelObject = new JSONObject();
                labelObject.put("show", (Object)flag);
                seriesObject.put("label", (Object)labelObject);
            }
        }
        optionJson.put("series", (Object)seriesDefaultObj);
        return optionJson.toString();
    }
}

