/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.Token;
import java.io.IOException;

public class Slurp
extends Token {
    public Slurp() {
    }

    public Slurp(TdsInputStream tdsInputStream, int n) throws IOException {
        try {
            int n2 = this.getLength(tdsInputStream, n);
            tdsInputStream.skipBytes(n2);
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLength(TdsInputStream tdsInputStream, int n) throws IOException {
        int n2 = 0;
        try {
            if ((n & 0xE0) == 192) {
                return 0;
            }
            if ((n & 0x30) == 48) {
                switch (n & 0xC) {
                    case 0: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                    case 8: {
                        return 4;
                    }
                    case 12: {
                        return 8;
                    }
                    default: {
                        return n2;
                    }
                }
            }
            switch (n & 0xFC) {
                case 36: 
                case 40: 
                case 100: 
                case 104: {
                    return tdsInputStream.readUnsignedByte();
                }
                case 32: 
                case 96: {
                    return tdsInputStream.readInt();
                }
                default: {
                    return tdsInputStream.readUnsignedShort();
                }
            }
        }
        catch (IOException iOException) {
            Token.readSQE(iOException);
        }
        return n2;
    }
}

