/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class WordCloud {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = WordCloud.generateDefaultOption();
            String clazzName = WordCloud.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
                return results;
            }
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            StringBuffer sb = new StringBuffer();
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang='zh-cmn-Hans'>");
            sb.append("<head>");
            sb.append(" <meta charset='UTF-8'>");
            sb.append("        <meta http-equiv='pragma' content='no-cache'>");
            sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
            sb.append("        <meta http-equiv='expires' content='0'>");
            sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
            sb.append("        <meta name='format-detection' content='telephone=no'>");
            sb.append("        <meta name='format-detection' content='email=no'>");
            sb.append("        <meta name='format-detection' content='adress=no'>");
            sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
            sb.append("<script src='" + jsResourceHttp + "/echarts-5.4.2.min.js'></script>");
            sb.append("<script src='" + jsResourceHttp + "/echarts-wordCloud-5.min.js'></script>");
            sb.append("</head>");
            sb.append("<body style='margin:0px;padding:0px;'>");
            sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
            sb.append("</body>");
            sb.append("<script type='text/javascript'>");
            sb.append("var myChart = echarts.init(document.getElementById('main'));");
            sb.append(" function setColor(){");
            sb.append("      var colors = [\n              '#F6A878',\n              '#FDCA71',\n              '#D9E4E4',\n              '#CAE1E6',\n              '#8B9ECD',\n              '#6CB9FB',\n              '#5596F7',\n              '#4778FE',\n            ];\n            return colors[parseInt(Math.random() * 8)];\n");
            sb.append(" };");
            sb.append("var option = ");
            sb.append(option + ";");
            sb.append("option.series[0].textStyle.color = setColor;");
            sb.append("myChart.setOption(option);");
            sb.append("</script>");
            sb.append("</html>");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
            if (result == 0) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
            if (!htmlFile.exists()) return results;
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + WordCloud.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                JSONObject optionJSON = JSONObject.parseObject((String)option);
                JSONObject realDataJSON = JSONObject.parseObject((String)realData);
                optionJSON.put("cloudNameData", realDataJSON.get((Object)"cloudNameData"));
                optionJSON.put("cloudValueData", realDataJSON.get((Object)"cloudValueData"));
                optionJSON.put("shape", realDataJSON.get((Object)"shape"));
                optionJSON.put("rotationRange", realDataJSON.get((Object)"rotationRange"));
                optionJSON.put("sizeRange", realDataJSON.get((Object)"sizeRange"));
                optionJSON.put("gridSize", realDataJSON.get((Object)"gridSize"));
                optionJSON.put("colorList", realDataJSON.get((Object)"colorList"));
                if (optionJSON.containsKey((Object)"animation")) {
                    optionJSON.remove((Object)"animation");
                    optionJSON.put("animation", (Object)true);
                }
                results.put("option", optionJSON.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        String data = " [\n        {name: \"\u9f99\u5934\u9547\", value: \"111\"},\n        {name: \"\u5927\u57d4\u9547\", value: \"222\"},\n        {name: \"\u592a\u5e73\u9547\", value: \"458\"},\n        {name: \"\u6c99\u57d4\u9547\", value: \"445\"},\n        {name: \"\u4e1c\u6cc9\u9547\", value: \"456\"},\n        {name: \"\u51e4\u5c71\u9547\", value: \"647\"},\n        {name: \"\u516d\u5858\u9547\", value: \"189\"},\n        {name: \"\u51b2\u8109\u9547\", value: \"864\"},\n        {name: \"\u5be8\u9686\u9547\", value: \"652\"},\n        ]";
        JSONArray dataArray = JSONArray.parseArray((String)data);
        sb.append("{");
        sb.append("animation:false,");
        sb.append("layoutAnimation: true,");
        sb.append("initTimes:0,");
        sb.append("        title : {");
        sb.append("    text: '\u8bcd\u4e91\u56fe',");
        sb.append("            left: 'center',");
        sb.append("            textStyle : {");
        sb.append("        color: '#fff'");
        sb.append("    }");
        sb.append("},");
        sb.append("        tooltip: {");
        sb.append("    show: true");
        sb.append("},");
        sb.append("series: [{");
        sb.append("    type: 'wordCloud',");
        sb.append("    rotationRange: [0, 0],");
        sb.append("    rotationStep: 45,");
        sb.append("    sizeRange:[14,38],");
        sb.append("    gridSize:12,");
        sb.append("    shape: 'circle',");
        sb.append("    textStyle: {");
        sb.append("        normal: {");
        sb.append("        },");
        sb.append("        emphasis: {");
        sb.append("            shadowBlur: 10,");
        sb.append("                    shadowColor: '#333'");
        sb.append("        }");
        sb.append("    },");
        sb.append("    data:" + dataArray.toString() + " ");
        sb.append(" }]");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        String repaintRegions;
        JSONObject repaintRegionsObj;
        JSONObject backColorObj;
        StringBuffer sb = new StringBuffer();
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String cloudNameDate = (String)optionObject.get((Object)"cloudNameData");
        String cloudValueDate = (String)optionObject.get((Object)"cloudValueData");
        String sizeRange = optionObject.getString("sizeRange");
        String rotationRange = optionObject.getString("rotationRange");
        String gridSize = optionObject.getString("gridSize");
        String colorList = optionObject.getString("colorList");
        JSONArray colorArray = JSONArray.parseArray((String)colorList);
        String shape = optionObject.getString("shape");
        ArrayList<String> cloudNameList = new ArrayList<String>();
        String[] cloudNameStrs = cloudNameDate.split(",");
        for (int i = 0; i < cloudNameStrs.length; ++i) {
            cloudNameList.add(cloudNameStrs[i]);
        }
        ArrayList<String> cloudValueList = new ArrayList<String>();
        String[] cloudValueStrs = cloudValueDate.split(",");
        for (int i = 0; i < cloudValueStrs.length; ++i) {
            cloudValueList.add(cloudValueStrs[i]);
        }
        JSONArray seriesDataArray = new JSONArray();
        for (int i = 0; i < cloudNameList.size(); ++i) {
            String cloudName = (String)cloudNameList.get(i);
            String cloudValue = (String)cloudValueList.get(i);
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)cloudName);
            obj.put("value", (Object)Double.parseDouble(cloudValue));
            seriesDataArray.add((Object)obj);
        }
        JSONArray seriesArr = optionObject.getJSONArray("series");
        JSONObject seriesObj = seriesArr.getJSONObject(0);
        seriesObj.put("data", (Object)seriesDataArray);
        seriesObj.put("sizeRange", (Object)JSONArray.parseArray((String)sizeRange));
        seriesObj.put("rotationRange", (Object)JSONArray.parseArray((String)rotationRange));
        seriesObj.put("gridSize", (Object)Integer.parseInt(gridSize));
        seriesObj.put("shape", (Object)shape);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-wordCloud-5.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("$(document).ready(function(){");
        sb.append("$('#main').css('width',$(window.frameElement).attr('ow'));");
        sb.append("$('#main').css('height',$(window.frameElement).attr('oh'));");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append(" function setColor(){");
        sb.append("      var colors = " + colorList + ";\n            return colors[parseInt(Math.random() * " + colorArray.size() + ")];\n");
        sb.append("            };");
        sb.append("var option = ");
        sb.append(optionObject.toString() + ";");
        sb.append("myChart.setOption(option);");
        sb.append("option.series[0].textStyle.color = setColor;");
        sb.append("myChart.setOption(option);");
        sb.append("window.addEventListener('resize',function(){");
        sb.append("    myChart.resize();");
        sb.append("});");
        JSONObject reportInfoObj = JSONObject.parseObject((String)reportInfo);
        String hyperLink = reportInfoObj.getString("hyperLink");
        JSONArray hyperLinkArray = JSONArray.parseArray((String)hyperLink);
        if (hyperLinkArray != null) {
            sb.append("var hyperLinkArray = [];");
            sb.append("var obj = {};");
            sb.append("var paramExpression ;");
            JSONObject hyperLinkObj = hyperLinkArray.getJSONObject(0);
            Set keySet = hyperLinkObj.keySet();
            for (String key : keySet) {
                String value = hyperLinkObj.getString(key);
                if ("OpterationType".equals(key) || "WindowStyle".equals(key)) {
                    sb.append("obj." + key + "=" + value + ";");
                    continue;
                }
                sb.append("obj." + key + "='" + value + "';");
                if (!key.equals("Params")) continue;
                sb.append("paramExpression = '" + value + "';");
            }
            sb.append("hyperLinkArray.push(obj);");
            sb.append("myChart.on('click', function (params) {var changeParam='';var hyperParam = paramExpression;var hyperParams = hyperParam.split(';'); for(var i=0;i<hyperParams.length-1;i++){var param = hyperParams[i];var paramStr = param.split('=');var key = paramStr[0];var value = paramStr[1];  if(value == 'CATEGORY'){     changeParam += (key + '=' + params.name + ';')  }else if(value == 'SERIES'){     changeParam += (key + '=' + params.seriesName + ';')  }else if(value == 'VALUE'){     changeParam += (key + '=' + params.value + ';')  }else if(value == 'CONTROLVALUE'){  }   else if(value == 'XAXIS'){  }   else if(value == 'YAXIS'){  }   else{ changeParam += (key + '=' + value + ';') }}console.log(changeParam);hyperLinkArray[0].Params = changeParam;console.log(params.seriesName);parent.Link.Fn.hyperlink(hyperLinkArray)});");
        }
        if ((repaintRegionsObj = JSONObject.parseObject((String)(repaintRegions = reportInfoObj.getString("repaintRegions")))) != null) {
            String param = repaintRegionsObj.getString("Params");
            StringBuffer echartSb = new StringBuffer();
            String[] kAv = param.split(";");
            for (int i = 0; i < kAv.length; ++i) {
                String echartParam;
                String paramStr = kAv[i];
                String[] paramStrs = paramStr.split("=");
                String key = paramStrs[1];
                if ("CATEGORY".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.name + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("SERIES".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.seriesName + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("VALUE".equals(key)) {
                    echartParam = paramStrs[0] + "=' + params.value + ';";
                    echartSb.append(echartParam);
                    continue;
                }
                if ("CONTROLVALUE".equals(key) || "X-AXIS".equals(key) || "Y-AXIS".equals(key)) continue;
                String val = paramStrs[1].replaceAll("'", "");
                String echartParam2 = paramStrs[0] + "=" + val + ";";
                echartSb.append(echartParam2);
            }
            repaintRegionsObj.remove((Object)"Params");
            repaintRegionsObj.put("Params", (Object)echartSb.toString());
            reportInfoObj.remove((Object)"repaintRegions");
            reportInfoObj.put("repaintRegions", (Object)repaintRegionsObj);
            sb.append("myChart.on('click', function (params) {console.log(params);console.log(params.seriesName);parent.Link.Fn.regionLink(this,1,'" + reportInfoObj.getString("repaintRegions") + "','sheet1')});");
        }
        sb.append("})");
        sb.append("</script>");
        sb.append("</html>");
        File file = new File(path);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(sb.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        JSONObject backColorObj;
        String resultStr = null;
        JSONObject optionObject = JSONObject.parseObject((String)option);
        String cloudNameDate = (String)optionObject.get((Object)"cloudNameData");
        String cloudValueDate = (String)optionObject.get((Object)"cloudValueData");
        ArrayList<String> cloudNameList = new ArrayList<String>();
        String[] cloudNameStrs = cloudNameDate.split(",");
        for (int i = 0; i < cloudNameStrs.length; ++i) {
            cloudNameList.add(cloudNameStrs[i]);
        }
        ArrayList<String> cloudValueList = new ArrayList<String>();
        String[] cloudValueStrs = cloudValueDate.split(",");
        for (int i = 0; i < cloudValueStrs.length; ++i) {
            cloudValueList.add(cloudValueStrs[i]);
        }
        JSONArray seriesDataArray = new JSONArray();
        for (int i = 0; i < cloudNameList.size(); ++i) {
            String cloudName = (String)cloudNameList.get(i);
            String cloudValue = (String)cloudValueList.get(i);
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)cloudName);
            obj.put("value", (Object)Double.parseDouble(cloudValue));
            seriesDataArray.add((Object)obj);
        }
        JSONArray seriesArr = optionObject.getJSONArray("series");
        JSONObject seriesObj = seriesArr.getJSONObject(0);
        seriesObj.put("data", (Object)seriesDataArray);
        Object baObject = optionObject.get((Object)"backgroundColor");
        if (baObject instanceof JSONObject && (backColorObj = optionObject.getJSONObject("backgroundColor")) != null && backColorObj.containsKey((Object)"__canvasGradient")) {
            backColorObj.remove((Object)"__canvasGradient");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html>");
        sb.append("<html lang='zh-cmn-Hans'>");
        sb.append("<head>");
        sb.append(" <meta charset='UTF-8'>");
        sb.append("        <meta http-equiv='pragma' content='no-cache'>");
        sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
        sb.append("        <meta http-equiv='expires' content='0'>");
        sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
        sb.append("        <meta name='format-detection' content='telephone=no'>");
        sb.append("        <meta name='format-detection' content='email=no'>");
        sb.append("        <meta name='format-detection' content='adress=no'>");
        sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-5.4.2.min.js'></script>");
        sb.append("<script src='" + jsResourcePath + "/echarts-wordCloud-5.min.js'></script>");
        sb.append("</head>");
        sb.append("<body style='margin:0px;padding:0px;'>");
        sb.append("<div id='main' style='width:" + width + "px;height:" + height + "px;'></div>");
        sb.append("</body>");
        sb.append("<script type='text/javascript'>");
        sb.append("var myChart = echarts.init(document.getElementById('main'));");
        sb.append(" function setColor(){");
        sb.append("               return 'rgb(' + [");
        sb.append("                Math.round(Math.random() * 250),");
        sb.append("                        Math.round(Math.random() * 250),");
        sb.append("                        Math.round(Math.random() * 250)");
        sb.append("                ].join(',') + ')';");
        sb.append("            };");
        sb.append("var option = ");
        sb.append(optionObject.toString() + ";");
        sb.append("myChart.setOption(option);");
        sb.append("option.series[0].textStyle.normal.color = setColor;");
        sb.append("myChart.setOption(option);");
        sb.append("</script>");
        sb.append("</html>");
        File classPath = new File(tempPath).getParentFile();
        File webInf = classPath.getParentFile();
        File efrs = webInf.getParentFile();
        String efrsPath = efrs.getAbsolutePath();
        String exportPath = efrsPath + File.separator + "export";
        String exportIdPath = exportPath + File.separator + pathId;
        UUID uuid = UUID.randomUUID();
        String fileName = uuid.toString() + ".html";
        String htmlPath = exportIdPath + File.separator + fileName;
        String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
        try {
            File pngFile;
            String base64Code;
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                // empty if block
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u8bcd\u4e91\u56fe";
    }

    public static String getClassName() {
        return "WordCloud";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        JSONObject optionJson = JSONObject.parseObject((String)option);
        JSONObject defaultJson = JSONObject.parseObject((String)WordCloud.generateDefaultOption());
        JSONArray seriesDefaultObj = (JSONArray)defaultJson.get((Object)"series");
        optionJson.put("series", (Object)seriesDefaultObj);
        return optionJson.toString();
    }
}

