/*
 * Decompiled with CFR 0.152.
 */
package com.efreport.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efreport.core.ReportEngineLibrary;
import com.efreport.util.FileToBase64;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class Grid {
    private static final ReportEngineLibrary engine = ReportEngineLibrary.instance;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getPluginDefaultImage(int width, int height, String path, String flag, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String option = "{}";
            String clazzName = Grid.getClassName();
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String websiteName = json.getString("websiteName");
            String jsResourcePath = json.getString("jsResourcePath");
            String jsResourceHttp = websiteName + jsResourcePath;
            String fileName = clazzName + ".html";
            String htmlPath = path + File.separator + fileName;
            String pngPath = path + File.separator + clazzName + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
                return results;
            }
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            StringBuffer sb = new StringBuffer();
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang='zh-cmn-Hans'>");
            sb.append("<head>");
            sb.append(" <meta charset='UTF-8'>");
            sb.append(" <meta http-equiv='pragma' content='no-cache'>");
            sb.append(" <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
            sb.append(" <meta http-equiv='expires' content='0'>");
            sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
            sb.append("        <meta name='format-detection' content='telephone=no'>");
            sb.append("        <meta name='format-detection' content='email=no'>");
            sb.append("        <meta name='format-detection' content='adress=no'>");
            sb.append("<link rel='stylesheet' href='" + jsResourceHttp + "/layui/css/layui.css' media='all'>");
            sb.append("<script src='" + jsResourceHttp + "/jquery-1.11.3.min.js'></script>");
            sb.append("<script src='" + jsResourceHttp + "/layui/layui.js'></script>");
            sb.append("</head>");
            sb.append("<body style='margin:0px;padding:0px;'>");
            sb.append("<table id='demo'></table>");
            sb.append("</body>");
            sb.append("<script type='text/javascript'>");
            sb.append("layui.use('table', function(){");
            sb.append("    var table = layui.table;");
            sb.append("    table.render({");
            sb.append("           elem: '#demo'");
            sb.append("            ,height:" + height);
            sb.append("            ,page: true ");
            sb.append("            ,cols: [[ ");
            sb.append("    {field: 'id', title: 'ID', width:80, sort: true, fixed: 'left'}");
            sb.append("    ,{field: 'username', title: '\u7528\u6237\u540d', width:80}");
            sb.append("    ,{field: 'sex', title: '\u6027\u522b', width:80, sort: true}");
            sb.append("    ,{field: 'city', title: '\u57ce\u5e02', width:80}");
            sb.append("    ,{field: 'sign', title: '\u7b7e\u540d', width: 177}");
            sb.append("    ,{field: 'experience', title: '\u79ef\u5206', width: 80, sort: true}");
            sb.append("    ,{field: 'score', title: '\u8bc4\u5206', width: 80, sort: true}");
            sb.append("    ,{field: 'classify', title: '\u804c\u4e1a', width: 80}");
            sb.append("    ,{field: 'words', title: '\u5b57\u6570', width: 135, sort: true}");
            sb.append("    ]]");
            sb.append("   });");
            sb.append("});");
            sb.append("</script>");
            sb.append("</html>");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, 0, 0, width, height, pngPath);
            if (result == 0) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", option);
            } else {
                results.put("state", "failed");
            }
            if (!htmlFile.exists()) return results;
        }
        catch (Exception e) {
            results.put("state", "failed");
            e.printStackTrace();
        }
        return results;
    }

    public static Map<String, String> getPluginMixedImage(String option, String realData, int width, int height, String tempPath, String platformOption) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            JSONObject optionJson = JSONObject.parseObject((String)option);
            JSONObject opJson = JSONObject.parseObject((String)option);
            JSONObject json = JSONObject.parseObject((String)platformOption);
            String pngPath = tempPath + File.separator + Grid.getClassName() + ".png";
            File pngFile = new File(pngPath);
            if (pngFile.exists()) {
                String base64Code = FileToBase64.encodeBase64File((String)pngPath);
                results.put("state", "success");
                results.put("imageCode", base64Code);
                results.put("option", opJson.toString());
            } else {
                results.put("state", "failed");
            }
        }
        catch (Exception e) {
            results.put("state", "failed");
        }
        return results;
    }

    public static String generateDefaultOption() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("  elem: '#table'");
        sb.append("   ,height: 312");
        sb.append("   ,url: '/static/json/table/user.json'");
        sb.append("   ,page: true ");
        sb.append("   ,cols: [[ ");
        sb.append("    {field: 'id', title: 'ID', width:80, sort: true, fixed: 'left'}");
        sb.append("    ,{field: 'username', title: '\u7528\u6237\u540d', width:80}");
        sb.append("    ,{field: 'sex', title: '\u6027\u522b', width:80, sort: true}");
        sb.append("    ,{field: 'city', title: '\u57ce\u5e02', width:80}");
        sb.append("    ,{field: 'sign', title: '\u7b7e\u540d', width: 177}");
        sb.append("    ,{field: 'experience', title: '\u79ef\u5206', width: 80, sort: true}");
        sb.append("    ,{field: 'score', title: '\u8bc4\u5206', width: 80, sort: true}");
        sb.append("    ,{field: 'classify', title: '\u804c\u4e1a', width: 80}");
        sb.append("   ,{field: 'words', title: '\u5b57\u6570', width: 135, sort: true}");
        sb.append("   ]]");
        sb.append("}");
        return sb.toString();
    }

    public static int generatePluginHtml(String jsResourcePath, String option, int width, int height, String path, String reportInfo) {
        try {
            path = path.replace(".html", ".plugin");
            StringBuffer sb = new StringBuffer();
            String base = jsResourcePath.substring(0, jsResourcePath.length() - 7);
            JSONObject gridOption = JSONObject.parseObject((String)option);
            String conn = gridOption.getString("datasource");
            String sql = gridOption.getString("sql");
            String newSql = sql.replaceAll("\n", " ");
            newSql = newSql.replaceAll("\"", "@#");
            JSONArray columns = gridOption.getJSONArray("columns");
            JSONArray newColumns = new JSONArray();
            String getDataUrl = base + "/grid/geneData?conn=" + conn + "&sql=" + URLEncoder.encode(newSql, "UTF-8") + "&ef_companyId=1";
            for (int i = 0; i < columns.size(); ++i) {
                JSONObject column = columns.getJSONObject(i);
                JSONObject columnObj = new JSONObject();
                columnObj.put("field", (Object)column.getString("id"));
                columnObj.put("title", (Object)column.getString("name"));
                columnObj.put("width", (Object)column.getString("width"));
                columnObj.put("sort", (Object)(!column.getString("sort").equals("0") ? 1 : 0));
                newColumns.add((Object)columnObj);
            }
            StringBuffer cssBuffer = new StringBuffer();
            StringBuffer domBuffer = new StringBuffer();
            StringBuffer jsBuffer = new StringBuffer();
            StringBuffer scriptBuffer = new StringBuffer();
            JSONArray jsArray = new JSONArray();
            jsArray.add((Object)(jsResourcePath + "/jquery-1.11.3.min.js"));
            jsArray.add((Object)(jsResourcePath + "/layui/layui.js"));
            jsBuffer.append(jsArray.toString());
            JSONArray cssArray = new JSONArray();
            cssArray.add((Object)(jsResourcePath + "/layui/css/layui.css"));
            cssBuffer.append(cssArray.toString());
            long pluginTime = new Random().nextLong();
            if (pluginTime < 0L) {
                pluginTime = 0L - pluginTime;
            }
            domBuffer.append("<table id='main_" + pluginTime + "' style='width:100%;height:100%;'></table>");
            scriptBuffer.append("layui.use('table', function(){");
            scriptBuffer.append("    table = layui.table;");
            scriptBuffer.append("    let conn = '" + conn + "';");
            scriptBuffer.append("    let sql = \"" + newSql + "\";");
            scriptBuffer.append("    conn = btoa(encodeURIComponent(conn));");
            scriptBuffer.append("    sql = btoa(encodeURIComponent(sql));");
            scriptBuffer.append("    var url = \"" + base + "/grid/geneData\";");
            scriptBuffer.append("    table.render({");
            scriptBuffer.append("            elem: '#main_" + pluginTime + "'");
            scriptBuffer.append("            ,height:$('#main_" + pluginTime + "').height()");
            scriptBuffer.append("            ,url: url");
            scriptBuffer.append("            ,method:'POST'");
            scriptBuffer.append("            ,where: { ");
            scriptBuffer.append("                 conn:conn,");
            scriptBuffer.append("                 sql:sql,");
            scriptBuffer.append("                 ef_companyId:'1'");
            scriptBuffer.append("             }");
            scriptBuffer.append("            ,page: true ");
            scriptBuffer.append("            ,cols: [" + newColumns.toString() + "]");
            scriptBuffer.append("    });");
            scriptBuffer.append("});");
            JSONObject pluginInfo = new JSONObject();
            pluginInfo.put("dom", (Object)domBuffer.toString());
            pluginInfo.put("css", (Object)cssBuffer.toString());
            pluginInfo.put("js", (Object)jsBuffer.toString());
            pluginInfo.put("script", (Object)scriptBuffer.toString());
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            fileWriter.write(pluginInfo.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static String generatePluginPng(String jsResourcePath, String option, int width, int height, String tempPath, int x, int y, String pathId) {
        String resultStr = null;
        try {
            File pngFile;
            String base64Code;
            StringBuffer sb = new StringBuffer();
            String base = jsResourcePath.substring(0, jsResourcePath.length() - 7);
            JSONObject gridOption = JSONObject.parseObject((String)option);
            String conn = gridOption.getString("datasource");
            String sql = gridOption.getString("sql");
            JSONArray columns = gridOption.getJSONArray("columns");
            JSONArray newColumns = new JSONArray();
            String getDataUrl = base + "/grid/geneData?conn=" + conn + "&sql=" + URLEncoder.encode(sql, "UTF-8") + "&ef_companyId=1";
            for (int i = 0; i < columns.size(); ++i) {
                JSONObject column = columns.getJSONObject(i);
                JSONObject columnObj = new JSONObject();
                columnObj.put("field", (Object)column.getString("id"));
                columnObj.put("title", (Object)column.getString("name"));
                columnObj.put("width", (Object)column.getString("width"));
                columnObj.put("sort", (Object)(!column.getString("sort").equals("0") ? 1 : 0));
                newColumns.add((Object)columnObj);
            }
            sb.append("<!DOCTYPE html>");
            sb.append("<html lang='zh-cmn-Hans'>");
            sb.append("<head>");
            sb.append(" <meta charset='UTF-8'>");
            sb.append("        <meta http-equiv='pragma' content='no-cache'>");
            sb.append("        <meta http-equiv='Cache-Control' content='no-cache, no-store'>");
            sb.append("        <meta http-equiv='expires' content='0'>");
            sb.append("        <meta name='viewport' content='width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no'>");
            sb.append("        <meta name='format-detection' content='telephone=no'>");
            sb.append("        <meta name='format-detection' content='email=no'>");
            sb.append("        <meta name='format-detection' content='adress=no'>");
            sb.append("<link rel='stylesheet' href='" + jsResourcePath + "/layui/css/layui.css' media='all'>");
            sb.append("<script src='" + jsResourcePath + "/jquery-1.11.3.min.js'></script>");
            sb.append("<script src='" + jsResourcePath + "/layui/layui.js'></script>");
            sb.append("</head>");
            sb.append("<style>");
            sb.append("        html, body {");
            sb.append("    border: 0px;");
            sb.append("    margin: 0px;");
            sb.append("    padding: 0px;");
            sb.append("     height: 100%;");
            sb.append(" }");
            sb.append("        .layui-table-view {");
            sb.append("     margin:0; ");
            sb.append("}");
            sb.append(".layui-table-tool-temp {");
            sb.append("    padding-right: 120px;");
            sb.append("    display: none;");
            sb.append(" }");
            sb.append(".layui-table-column {");
            sb.append("    ");
            sb.append("    display: none;");
            sb.append(" }");
            sb.append("</style>");
            sb.append("<body style='margin:0px;padding:0px;'>");
            sb.append("<table id='main' lay-filter='test'></table>");
            sb.append("</body>");
            sb.append("<script type='text/javascript'>");
            sb.append("$(document).ready(function(){");
            sb.append("layui.use('table', function(){\n");
            sb.append("    var table = layui.table;\n");
            sb.append("    table.render({\n");
            sb.append("            elem: '#main'\n");
            sb.append("            ,height:$(window.frameElement).attr('oh')\n");
            sb.append("            ,url: '" + getDataUrl + "'\n");
            sb.append("            ,request: { \n");
            sb.append("                 conn:\"" + conn + "\",\n");
            sb.append("                 sql:\"" + sql + "\",\n");
            sb.append("                 ef_companyId:'1'\n");
            sb.append("             }\n");
            sb.append("            ,page: true \n");
            sb.append("            ,cols: [" + newColumns.toString() + "]\n");
            sb.append("    });\n");
            sb.append("});\n");
            sb.append("});\n");
            sb.append("</script>");
            sb.append("</html>");
            File classPath = new File(tempPath).getParentFile();
            File webInf = classPath.getParentFile();
            File efrs = webInf.getParentFile();
            String efrsPath = efrs.getAbsolutePath();
            String exportPath = efrsPath + File.separator + "export";
            String exportIdPath = exportPath + File.separator + pathId;
            UUID uuid = UUID.randomUUID();
            String fileName = uuid.toString() + ".html";
            String htmlPath = exportIdPath + File.separator + fileName;
            String pngPath = exportIdPath + File.separator + uuid.toString() + ".png";
            File htmlFile = new File(htmlPath);
            htmlFile.createNewFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), "UTF-8"));
            writer.write(sb.toString());
            ((Writer)writer).flush();
            ((Writer)writer).close();
            htmlPath = htmlPath.replaceAll("\\\\", "/");
            pngPath = pngPath.replaceAll("\\\\", "/");
            htmlPath = htmlPath.replaceAll("//", "/");
            pngPath = pngPath.replaceAll("//", "/");
            int result = engine.Er_ExportPluginImage(htmlPath, x, y, width, height, pngPath);
            resultStr = result == 0 ? (base64Code = FileToBase64.encodeBase64File((String)pngPath)) : "error";
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
            if ((pngFile = new File(pngPath)).exists()) {
                pngFile.delete();
            }
        }
        catch (Exception e) {
            resultStr = "error";
        }
        return resultStr;
    }

    public static String getPluginName() {
        return "\u5206\u9875\u8868\u683c";
    }

    public static String getClassName() {
        return "Grid";
    }

    public static void main(String[] args) {
    }

    public static String getMixedOption(String option) {
        return null;
    }
}

