/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.HexUtils;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import com.sap.db.util.security.ScramSHA256;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class ScramSHA256Authentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "SCRAMSHA256";
    private static final int CLIENT_PROOF_SIZE = 32;
    private List<byte[]> _salt = new ArrayList<byte[]>();
    private byte[] _clientChallenge;
    private byte[] _serverChallenge;

    ScramSHA256Authentication() {
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        return this._getClientChallenge();
    }

    @Override
    byte[] getFinalData(String passwd) throws SQLException {
        if (passwd == null) {
            throw SQLExceptionSapDB.newInstance("error.nopasswd", new String[0]);
        }
        return this._getClientProof(passwd);
    }

    @Override
    byte[] evaluateAuthenticateReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        byte[] salt;
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", HexUtils.toDisplayHexString(authenticationPart.getPartData()));
        }
        this._salt.add(part.getValueAsBytes());
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", HexUtils.toDisplayHexString(authenticationPart.getPartData()));
        }
        while (true) {
            salt = part.getValueAsBytes();
            if (!part.nextField()) break;
            this._salt.add(salt);
        }
        this._serverChallenge = salt;
        return null;
    }

    @Override
    boolean supportsReconnect() {
        return true;
    }

    private byte[] _getClientChallenge() throws SQLException {
        if (this._clientChallenge != null) {
            return this._clientChallenge;
        }
        this._clientChallenge = new byte[64];
        SecureRandom srnd = new SecureRandom();
        srnd.nextBytes(this._clientChallenge);
        return this._clientChallenge;
    }

    private byte[] _getClientProof(String pass) throws SQLException {
        byte[] passBytes = pass.getBytes(AbstractAuthenticationManager.CHARSET_UTF_8);
        byte[] data = new byte[2 + 33 * this._salt.size()];
        data[0] = 0;
        data[1] = (byte)this._salt.size();
        for (int j = 0; j < this._salt.size(); ++j) {
            byte[] clientproof = ScramSHA256.scrammSHA256(this._salt.get(j), passBytes, this._getClientChallenge(), this._serverChallenge);
            data[2 + j * 33] = 32;
            System.arraycopy(clientproof, 0, data, 2 + (j + 1) + j * 32, clientproof.length);
        }
        return data;
    }
}

