/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GSSAuthentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "GSS";
    private static final int REJECT = 0;
    private static final int SERVICE_PRINCIPAL_NAME_REQUEST = 1;
    private static final int SERVICE_PRINCIPAL_NAME_REPLY = 2;
    private static final int UNESTABLISHED_REQUEST = 3;
    private static final int UNESTABLISHED_REPLY = 4;
    private static final int ESTABLISHED_REQUEST = 5;
    private static final int ESTABLISHED_REPLY = 6;
    private static final int CONNECT_REPLY = 7;
    private final ConnectionSapDB _connection;
    private final GSSManager _manager;
    private final Oid _krb5Oid;
    private final String _krb5OidString;
    private final byte[] _krb5OidBytes;
    private final Subject _authenticatedSubject;
    private final Subject _currentContextSubject;
    private byte[] _finalData;
    private String _userName;
    private GSSContext _context;

    GSSAuthentication(ConnectionSapDB connection) throws GSSException {
        this._connection = connection;
        Tracer tracer = connection.getTracer();
        if (tracer.on()) {
            tracer.printMessage("Property: java.security.auth.login.config = " + System.getProperty("java.security.auth.login.config", "null") + "\nProperty: javax.security.auth.useSubjectCredsOnly = " + System.getProperty("javax.security.auth.useSubjectCredsOnly", "null"));
        }
        this._manager = GSSManager.getInstance();
        this._krb5Oid = new Oid("1.2.840.113554.1.2.2");
        this._krb5OidString = this._krb5Oid.toString();
        this._krb5OidBytes = this._krb5OidString.getBytes(AbstractAuthenticationManager.CHARSET_UTF_8);
        this._authenticatedSubject = this._connection.getAuthenticatedSubject();
        if (this._authenticatedSubject != null) {
            this._currentContextSubject = null;
            if (tracer.on()) {
                tracer.printMessage("Reusing connection subject");
            }
        } else {
            this._currentContextSubject = Subject.getSubject(AccessController.getContext());
            if (tracer.on()) {
                tracer.printMessage("Using current access context subject");
            }
        }
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        if (this._authenticatedSubject == null) {
            return this._getInitialData();
        }
        GetInitialDataAction action = new GetInitialDataAction();
        Subject.doAs(this._authenticatedSubject, action);
        if (action._exception != null) {
            throw action._exception;
        }
        return action._result;
    }

    @Override
    byte[] getFinalData(String passwd) throws SQLException {
        if (this._finalData != null) {
            return this._finalData;
        }
        throw SQLExceptionSapDB.newInstance("error.connection.gssauthenticationerror", "GSS Protocol error: Context is still unestablished.");
    }

    @Override
    byte[] evaluateAuthenticateReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        if (this._authenticatedSubject == null) {
            return this._evaluateAuthenticateReply(authenticationPart, tracer);
        }
        EvaluateAuthenticateReplyAction action = new EvaluateAuthenticateReplyAction(authenticationPart, tracer);
        Subject.doAs(this._authenticatedSubject, action);
        if (action._exception != null) {
            throw action._exception;
        }
        return action._result;
    }

    @Override
    boolean supportsReconnect() {
        return true;
    }

    @Override
    String getUserNameFromServer() {
        return this._userName;
    }

    @Override
    byte[] evaluateConnectReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        String kernelOid = part.getValueAsString();
        if (!kernelOid.equals(this._krb5OidString)) {
            if (tracer.on()) {
                tracer.printMessage("Reject GSS Authentication: Wrong OID found: expected: " + this._krb5OidString + ", actual: " + kernelOid);
            }
            return this.reject();
        }
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        int requestType = part.getValueAsUByte();
        if (requestType != 7) {
            return null;
        }
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        byte[] sessionCookie = part.getValueAsBytes();
        if (tracer.on()) {
            tracer.printMessage("GSS Authentication: Received session cookie");
        }
        return sessionCookie;
    }

    @Override
    void onAuthenticationCompleted() {
        this._connection.setAuthenticatedSubject(this._currentContextSubject);
    }

    private byte[] _getInitialData() throws SQLException {
        try {
            GSSCredential clientCredential = this._manager.createCredential(1);
            GSSName client = clientCredential.getName().canonicalize(this._krb5Oid);
            Oid typeOid = client.getStringNameType();
            return GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {1}, typeOid.toString().getBytes(AbstractAuthenticationManager.CHARSET_UTF_8), client.toString().getBytes(AbstractAuthenticationManager.CHARSET_UTF_8)});
        }
        catch (GSSException e) {
            throw SQLExceptionSapDB.newInstance("error.connection.gssauthenticationerror", e.toString());
        }
    }

    private byte[] _evaluateAuthenticateReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        String kernelOid = part.getValueAsString();
        if (!kernelOid.equals(this._krb5OidString)) {
            if (tracer.on()) {
                tracer.printMessage("Reject GSS Authentication: Wrong OID found: expected: " + this._krb5OidString + ", actual: " + kernelOid);
            }
            return this.reject();
        }
        if (!part.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        int requestType = part.getValueAsUByte();
        if (!part.nextField() && requestType != 6) {
            throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
        }
        byte[] token = part.getValueAsBytes();
        if (requestType == 2) {
            if (!part.nextField()) {
                throw SQLExceptionSapDB.newInstance("error.packet.wrongpacketformat", new String[0]);
            }
            String plainServerName = part.getValueAsString();
            if (tracer.on()) {
                tracer.printMessage("GSS Authentication: Received SPN: " + plainServerName);
            }
            if (part.nextField()) {
                this._userName = part.getValueAsString();
                if (tracer.on()) {
                    tracer.printMessage("GSS Authentication: Received user name: " + this._userName);
                }
            }
            try {
                GSSName serverName = this._manager.createName(plainServerName, null);
                this._context = this._manager.createContext(serverName, this._krb5Oid, null, 0);
                this._context.requestMutualAuth(true);
                this._context.requestConf(true);
                this._context.requestInteg(true);
            }
            catch (GSSException e) {
                if (tracer.on()) {
                    tracer.printThrowable(e, "Reject GSS Authentication");
                }
                return this.reject();
            }
            token = new byte[]{};
        }
        if (requestType == 4 || requestType == 2) {
            try {
                token = this._context.initSecContext(token, 0, token.length);
                if (token == null) {
                    if (tracer.on()) {
                        tracer.printMessage("Reject GSS Authentication: Protocol error");
                    }
                    return this.reject();
                }
            }
            catch (GSSException e) {
                if (tracer.on()) {
                    tracer.printThrowable(e, "Reject GSS Authentication");
                }
                return this.reject();
            }
            if (this._context.isEstablished()) {
                return GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {5}, token});
            }
            return GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {3}, token});
        }
        if (requestType == 6) {
            if (token == null) {
                this._finalData = GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {5}});
                return null;
            }
            try {
                token = this._context.initSecContext(token, 0, token.length);
            }
            catch (GSSException e) {
                if (tracer.on()) {
                    tracer.printThrowable(e, "Reject GSS Authentication");
                }
                return this.reject();
            }
            if (this._context.isEstablished()) {
                this._finalData = token == null ? GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {5}}) : GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {5}, token});
                return null;
            }
            if (tracer.on()) {
                tracer.printMessage("Reject GSS Authentication: Communication type 6 but not established");
            }
            return this.reject();
        }
        if (tracer.on()) {
            tracer.printMessage("Reject GSS Authentication: No suitable communication type: Found request type: " + requestType);
        }
        return this.reject();
    }

    private byte[] reject() {
        return GSSAuthentication.pack(new byte[][]{this._krb5OidBytes, {0}});
    }

    private static byte[] pack(byte[][] chunks) {
        int chunkLength;
        int lengthPos = 2;
        for (byte[] chunk : chunks) {
            chunkLength = chunk.length;
            lengthPos += chunkLength;
            lengthPos += chunkLength <= 250 ? 1 : 3;
        }
        byte[] part = new byte[lengthPos];
        ByteUtils.putShortBigEndian(chunks.length, part, 0);
        lengthPos = 2;
        for (byte[] chunk : chunks) {
            chunkLength = chunk.length;
            if (chunkLength <= 250) {
                ByteUtils.putByte(chunkLength, part, lengthPos++);
            } else {
                ByteUtils.putByte(255, part, lengthPos++);
                ByteUtils.putShortBigEndian(chunkLength, part, lengthPos);
                lengthPos += 2;
            }
            ByteUtils.putBytes(chunk, part, lengthPos);
            lengthPos += chunkLength;
        }
        return part;
    }

    private class EvaluateAuthenticateReplyAction
    implements PrivilegedAction<Object> {
        private HAuthenticationPart _authenticationPart;
        private Tracer _tracer;
        private byte[] _result;
        private SQLException _exception;

        private EvaluateAuthenticateReplyAction(HAuthenticationPart authenticationPart, Tracer tracer) {
            this._authenticationPart = authenticationPart;
            this._tracer = tracer;
        }

        @Override
        public Object run() {
            try {
                this._result = GSSAuthentication.this._evaluateAuthenticateReply(this._authenticationPart, this._tracer);
            }
            catch (SQLException e) {
                this._exception = e;
            }
            return null;
        }
    }

    private class GetInitialDataAction
    implements PrivilegedAction<Object> {
        private byte[] _result;
        private SQLException _exception;

        private GetInitialDataAction() {
        }

        @Override
        public Object run() {
            try {
                this._result = GSSAuthentication.this._getInitialData();
            }
            catch (SQLException e) {
                this._exception = e;
            }
            return null;
        }
    }
}

