/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import com.sap.db.util.security.GSSAuthentication;
import com.sap.db.util.security.JWTAuthentication;
import com.sap.db.util.security.SAMLAuthentication;
import com.sap.db.util.security.SAPLogonAuthentication;
import com.sap.db.util.security.ScramSHA256Authentication;
import com.sap.db.util.security.SessionCookieAuthentication;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ietf.jgss.GSSException;

public class AuthenticationManager
extends AbstractAuthenticationManager {
    private Map<String, AbstractAuthenticationMethod> _methods = new LinkedHashMap<String, AbstractAuthenticationMethod>();
    private AbstractAuthenticationMethod _currentMethod;

    @Override
    public void authenticate(ConnectionSapDB connection, Session session, String userName, String passwd) throws SQLException {
        byte[] data;
        String methodName;
        HAuthenticationPart authenticationPart;
        boolean errorOccurred;
        boolean hasPasswd;
        Tracer tracer = connection.getTracer();
        boolean hasUserName = userName != null && !userName.isEmpty();
        boolean bl = hasPasswd = !passwd.isEmpty();
        if (connection.getCookie() != null && hasUserName) {
            this._methods.put("SessionCookie", new SessionCookieAuthentication(connection));
            if (tracer.on()) {
                tracer.printMessage("Using Session Cookie Authentication");
            }
        } else if (!hasPasswd) {
            try {
                this._methods.put("GSS", new GSSAuthentication(connection));
            }
            catch (GSSException e) {
                if (tracer.on()) {
                    tracer.printThrowable(e, "Reject GSS Authentication");
                }
            }
        } else {
            if (tracer.on()) {
                tracer.printMessage("Reject GSS Authentication: Password is not empty");
            }
            if (!hasUserName) {
                this._methods.put("SAML", new SAMLAuthentication());
                this._methods.put("SAPLogon", new SAPLogonAuthentication());
                this._methods.put("JWT", new JWTAuthentication());
            } else if (tracer.on()) {
                tracer.printMessage("Reject SAML, SAPLogon and JWT Authentication: User name is not empty");
            }
        }
        this._methods.put("SCRAMSHA256", new ScramSHA256Authentication());
        HRequestPacket requestPacket = connection.getRequestPacket(session);
        do {
            errorOccurred = false;
            authenticationPart = requestPacket.initAuthenticate();
            authenticationPart.addArg();
            authenticationPart.addRow(2 * this._methods.size() + 1);
            authenticationPart.addString(userName);
            for (Map.Entry<String, AbstractAuthenticationMethod> entry : new LinkedHashMap<String, AbstractAuthenticationMethod>(this._methods).entrySet()) {
                methodName = entry.getKey();
                AbstractAuthenticationMethod method = entry.getValue();
                try {
                    authenticationPart.addBytes(methodName.getBytes(CHARSET_UTF_8));
                    authenticationPart.addBytes(method.getInitialData(passwd.getBytes(CHARSET_UTF_8)));
                }
                catch (SQLException e) {
                    errorOccurred = true;
                    if (tracer.on()) {
                        tracer.printThrowable(e, "Reject authentication method " + method.getMethodName());
                    }
                    this._methods.remove(methodName);
                    if (this._methods.size() != 0) continue;
                    connection.freeRequestPacket(requestPacket);
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable", new Object[0]), "08001", -11111);
                }
            }
            if (errorOccurred) continue;
            authenticationPart.close();
        } while (errorOccurred);
        do {
            requestPacket.close();
            HReplyPacket replyPacket = connection.execute(this, session, requestPacket, new ConnectionSapDB.ExecuteFlag[0]);
            authenticationPart = replyPacket.findAuthenticationPart(0);
            if (authenticationPart == null || !authenticationPart.nextField()) {
                throw SQLExceptionSapDB.newInstance("error.connection.noauthenticationmethodavailable", new String[0]);
            }
            methodName = authenticationPart.getValueAsString();
            this._currentMethod = this._methods.get(methodName);
            authenticationPart.nextField();
            data = this._currentMethod.evaluateAuthenticateReply(authenticationPart, tracer);
            if (data == null) continue;
            requestPacket = connection.getRequestPacket(session);
            authenticationPart = requestPacket.initAuthenticate();
            authenticationPart.addArg();
            authenticationPart.addRow(2);
            authenticationPart.addBytes(methodName.getBytes(AbstractAuthenticationManager.CHARSET_UTF_8));
            authenticationPart.addBytes(data);
            authenticationPart.close();
        } while (data != null);
    }

    @Override
    public void setClientProofPart(HAuthenticationPart authenticationPart, String userName, String passwd) throws SQLException {
        authenticationPart.addRow(3);
        authenticationPart.addString(userName);
        authenticationPart.addArg();
        authenticationPart.addString(this._currentMethod.getMethodName());
        authenticationPart.addArg();
        authenticationPart.addBytes(this._currentMethod.getFinalData(passwd));
        authenticationPart.addArg();
    }

    @Override
    public String getMethodName() {
        return this._currentMethod != null ? this._currentMethod.getMethodName() : "NULL";
    }

    @Override
    public byte[] evaluateConnectReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        return this._currentMethod != null ? this._currentMethod.evaluateConnectReply(authenticationPart, tracer) : null;
    }

    @Override
    public boolean supportsReconnect() {
        return this._currentMethod != null ? this._currentMethod.supportsReconnect() : false;
    }

    @Override
    String getUserNameFromServer() {
        return this._currentMethod != null ? this._currentMethod.getUserNameFromServer() : null;
    }

    @Override
    void onAuthenticationCompleted() {
        if (this._currentMethod != null) {
            this._currentMethod.onAuthenticationCompleted();
        }
    }
}

