/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

public final class VersionInfo {
    private final String _versionString;
    private final int _majorVersion;
    private final int _minorVersion;
    private final int _patchLevel;

    public VersionInfo() {
        this("1.0.0.000000");
    }

    public VersionInfo(String versionString) {
        this._versionString = versionString;
        int majorVersion = 1;
        int minorVersion = 0;
        int patchLevel = 0;
        String[] components = versionString.split("\\.");
        int n = components.length;
        if (n >= 3) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                patchLevel = Integer.parseInt(components[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._patchLevel = patchLevel;
    }

    public String toString() {
        return this._versionString;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getPatchLevel() {
        return this._patchLevel;
    }
}

