/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import java.io.File;

public final class FileUtils {
    private FileUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String getDirectoryName(String path) {
        int index = path.lastIndexOf(File.separatorChar);
        return index != -1 ? path.substring(0, index) : ".";
    }

    public static String getFileName(String path) {
        String fileNameWithExtension = path.substring(path.lastIndexOf(File.separatorChar) + 1);
        int index = fileNameWithExtension.lastIndexOf(46);
        return index != -1 ? fileNameWithExtension.substring(0, index) : fileNameWithExtension;
    }

    public static String getFileExtension(String path) {
        int index = path.lastIndexOf(46);
        return index != -1 ? path.substring(index) : "";
    }

    public static File createDirectoryIfNecessary(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isDirectory() && !file.mkdirs()) {
            return null;
        }
        return file;
    }
}

