/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public final class Dbg {
    public static final boolean on = false;
    public static final boolean ignoredException = false;
    public static final boolean authentication = false;
    public static final boolean sockets = false;
    public static final boolean sessions = false;
    public static final boolean close = false;
    public static final boolean finalize = false;
    public static final boolean locks = false;
    private static final int BUFFER_SIZE = 4096;

    private Dbg() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static void print(String text) {
    }

    public static void println(String text) {
    }

    public static void printlnEx(Throwable t, String text) {
    }

    public static String hexDump(byte[] bytes) {
        return Dbg.hexDump(bytes, 0, bytes.length);
    }

    public static String hexDump(byte[] bytes, int off, int len) {
        if (bytes == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(65536);
        StringBuilder hex = new StringBuilder(48);
        StringBuilder ascii = new StringBuilder(16);
        int offset = -1;
        int i = off;
        int j = 0;
        int n = off + len;
        while (i < n) {
            byte b = bytes[i];
            hex.append(String.format("%02X ", b));
            ascii.append(b >= 32 && b < 127 ? (char)b : (char)'.');
            switch (j % 16) {
                case 0: {
                    offset = j;
                    break;
                }
                case 15: {
                    builder.append(Dbg._hexDumpFormatLine(offset, hex.toString(), ascii.toString()));
                    hex.setLength(0);
                    ascii.setLength(0);
                }
            }
            ++i;
            ++j;
        }
        if (hex.length() > 0) {
            builder.append(Dbg._hexDumpFormatLine(offset, hex.toString(), ascii.toString()));
        }
        return builder.toString();
    }

    private static String _hexDumpFormatLine(int offset, String hex, String ascii) {
        return String.format("%10d | %8X | %-48s| %-16s |\n", offset, offset, hex, ascii);
    }

    private static void _formatThrowable(StringBuilder builder, Throwable t) {
        StringWriter stringWriter = new StringWriter(4096);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (t instanceof SQLException) {
            SQLException sqle = (SQLException)t;
            builder.append("\nSQLState  = ").append(sqle.getSQLState());
            builder.append("\nErrorCode = ").append(sqle.getErrorCode());
        }
        t.printStackTrace(printWriter);
        printWriter.flush();
        builder.append('\n');
        builder.append(stringWriter.toString());
        printWriter.close();
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            builder.append("\nThis exception was caused by:");
            Dbg._formatThrowable(builder, cause);
        }
    }
}

