/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class ByteUtils {
    private static final int EXP_BIAS = 6176;

    private ByteUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static boolean getBoolean(byte[] src, int off) {
        return src[off] != 0;
    }

    public static int getUByte(byte[] src, int off) {
        return src[off] & 0xFF;
    }

    public static byte getByte(byte[] src, int off) {
        return src[off];
    }

    public static void putByte(int src, byte[] dst, int off) {
        dst[off] = (byte)src;
    }

    public static short getShort(byte[] src, int off) {
        return (short)(src[off + 1] << 8 | src[off] & 0xFF);
    }

    public static short getShortBigEndian(byte[] src, int off) {
        return (short)(src[off] << 8 | src[off + 1] & 0xFF);
    }

    public static void putShort(int src, byte[] dst, int off) {
        dst[off + 1] = (byte)(src >> 8);
        dst[off] = (byte)src;
    }

    public static void putShortBigEndian(int src, byte[] dst, int off) {
        dst[off] = (byte)(src >> 8);
        dst[off + 1] = (byte)src;
    }

    public static int getInt(byte[] src, int off) {
        return src[off + 3] << 24 | (src[off + 2] & 0xFF) << 16 | (src[off + 1] & 0xFF) << 8 | src[off] & 0xFF;
    }

    public static int getIntBigEndian(byte[] src, int off) {
        return src[off] << 24 | (src[off + 1] & 0xFF) << 16 | (src[off + 2] & 0xFF) << 8 | src[off + 3] & 0xFF;
    }

    public static void putInt(int src, byte[] dst, int off) {
        dst[off + 3] = (byte)(src >> 24);
        dst[off + 2] = (byte)(src >> 16);
        dst[off + 1] = (byte)(src >> 8);
        dst[off] = (byte)src;
    }

    public static void putIntBigEndian(int src, byte[] dst, int off) {
        dst[off] = (byte)(src >> 24);
        dst[off + 1] = (byte)(src >> 16);
        dst[off + 2] = (byte)(src >> 8);
        dst[off + 3] = (byte)src;
    }

    public static long getLong(byte[] src, int off) {
        return (long)src[off + 7] << 56 | ((long)src[off + 6] & 0xFFL) << 48 | ((long)src[off + 5] & 0xFFL) << 40 | ((long)src[off + 4] & 0xFFL) << 32 | ((long)src[off + 3] & 0xFFL) << 24 | ((long)src[off + 2] & 0xFFL) << 16 | ((long)src[off + 1] & 0xFFL) << 8 | (long)src[off] & 0xFFL;
    }

    public static long getLongBigEndian(byte[] src, int off) {
        return (long)src[off] << 56 | ((long)src[off + 1] & 0xFFL) << 48 | ((long)src[off + 2] & 0xFFL) << 40 | ((long)src[off + 3] & 0xFFL) << 32 | ((long)src[off + 4] & 0xFFL) << 24 | ((long)src[off + 5] & 0xFFL) << 16 | ((long)src[off + 6] & 0xFFL) << 8 | (long)src[off + 7] & 0xFFL;
    }

    public static void putLong(long src, byte[] dst, int off) {
        dst[off + 7] = (byte)(src >> 56);
        dst[off + 6] = (byte)(src >> 48);
        dst[off + 5] = (byte)(src >> 40);
        dst[off + 4] = (byte)(src >> 32);
        dst[off + 3] = (byte)(src >> 24);
        dst[off + 2] = (byte)(src >> 16);
        dst[off + 1] = (byte)(src >> 8);
        dst[off] = (byte)src;
    }

    public static void putLongBigEndian(long src, byte[] dst, int off) {
        dst[off] = (byte)(src >> 56);
        dst[off + 1] = (byte)(src >> 48);
        dst[off + 2] = (byte)(src >> 40);
        dst[off + 3] = (byte)(src >> 32);
        dst[off + 4] = (byte)(src >> 24);
        dst[off + 5] = (byte)(src >> 16);
        dst[off + 6] = (byte)(src >> 8);
        dst[off + 7] = (byte)src;
    }

    public static float getFloat(byte[] src, int off) {
        return Float.intBitsToFloat(ByteUtils.getInt(src, off));
    }

    public static void putFloat(float src, byte[] dst, int off) {
        ByteUtils.putInt(Float.floatToRawIntBits(src), dst, off);
    }

    public static double getDouble(byte[] src, int off) {
        return Double.longBitsToDouble(ByteUtils.getLong(src, off));
    }

    public static void putDouble(double src, byte[] dst, int off) {
        ByteUtils.putLong(Double.doubleToRawLongBits(src), dst, off);
    }

    public static BigDecimal getBigDecimal(byte[] src, int off, int fraction) {
        BigDecimal bigDecimal;
        int signum = (ByteUtils.getByte(src, off + 15) & 0x80) == 0 ? 1 : -1;
        int exponent = 6176 - ((ByteUtils.getShort(src, off + 14) & Short.MAX_VALUE) >> 1);
        long low = ByteUtils.getLong(src, off);
        if ((low & Long.MIN_VALUE) == 0L && (ByteUtils.getLong(src, off + 8) & 0x1FFFFFFFFFFFFL) == 0L) {
            bigDecimal = BigDecimal.valueOf((long)signum * low, exponent);
        } else {
            byte[] magnitude = new byte[15];
            for (int i = 0; i < 15; ++i) {
                magnitude[i] = src[off + 14 - i];
            }
            magnitude[0] = (byte)(magnitude[0] & 1);
            bigDecimal = new BigDecimal(new BigInteger(signum, magnitude), exponent);
        }
        if (exponent != fraction && fraction < Short.MAX_VALUE) {
            bigDecimal = bigDecimal.setScale(fraction, 7);
        }
        return bigDecimal;
    }

    public static void putBigDecimal(BigDecimal src, byte[] dst, int off) {
        int scale = src.scale();
        int sign = src.signum();
        src = src.movePointRight(scale);
        src = src.abs();
        BigInteger bi = src.toBigInteger();
        while (bi.bitLength() > 113) {
            bi = bi.divide(BigInteger.TEN);
            --scale;
        }
        byte[] dval = bi.toByteArray();
        int dvalSize = dval.length;
        int exp = 6176 - scale;
        dst[off + 15] = sign < 0 ? (byte)(0xFFFFFF80 | (byte)(exp >> 7)) : (byte)(exp >> 7);
        int i = 0;
        int j = 14 + off;
        while (i < 15) {
            dst[j] = dvalSize + i < 15 ? (byte)0 : dval[(dvalSize + i) % 15];
            ++i;
            --j;
        }
        dst[off + 14] = (byte)((byte)(exp << 1 & 0xFE) | (byte)(dst[off + 14] & 1));
    }

    public static byte[] getBytes(byte[] src, int off, int len) {
        return ByteUtils.getBytes(src, off, len, null);
    }

    public static byte[] getBytes(byte[] src, int off, int len, byte[] buffer) {
        byte[] dst = buffer != null && buffer.length == len ? buffer : new byte[len];
        System.arraycopy(src, off, dst, 0, len);
        return dst;
    }

    public static void putBytes(byte[] src, byte[] dst, int off) {
        System.arraycopy(src, 0, dst, off, src.length);
    }
}

