/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext.wrapper;

import com.sap.db.jdbcext.wrapper.Array;
import com.sap.db.jdbcext.wrapper.Blob;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.jdbcext.wrapper.Clob;
import com.sap.db.jdbcext.wrapper.DatabaseMetaData;
import com.sap.db.jdbcext.wrapper.PreparedStatement;
import com.sap.db.jdbcext.wrapper.Statement;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

public abstract class Connection
implements java.sql.Connection {
    private final Set<java.sql.PreparedStatement> _statements = Collections.newSetFromMap(new WeakHashMap());
    private java.sql.DatabaseMetaData _wrappedDatabaseMetaData;

    public abstract java.sql.Connection getPhysicalConnection();

    public abstract void sendConnectionErrorEvent(SQLException var1);

    public abstract void sendStatementErrorEvent(SQLException var1, java.sql.PreparedStatement var2);

    public abstract void sendStatementClosedEvent(java.sql.PreparedStatement var1);

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        try {
            java.sql.Statement result = this.getPhysicalConnection().createStatement();
            if (result != null) {
                result = Statement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            java.sql.PreparedStatement result = this.getPhysicalConnection().prepareStatement(sql);
            if (result != null) {
                result = PreparedStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        try {
            java.sql.CallableStatement result = this.getPhysicalConnection().prepareCall(sql);
            if (result != null) {
                result = CallableStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            return this.getPhysicalConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.getPhysicalConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.getPhysicalConnection().setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.getPhysicalConnection().commit();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.getPhysicalConnection().rollback();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.getPhysicalConnection().isClosed();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.closeStatements();
            this.getPhysicalConnection().close();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (this._wrappedDatabaseMetaData == null) {
                this._wrappedDatabaseMetaData = this.getPhysicalConnection().getMetaData();
            }
            if (this._wrappedDatabaseMetaData != null) {
                this._wrappedDatabaseMetaData = DatabaseMetaData.newInstance(this._wrappedDatabaseMetaData, this, this);
            }
            return this._wrappedDatabaseMetaData;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.getPhysicalConnection().isReadOnly();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean isReadOnly) throws SQLException {
        try {
            this.getPhysicalConnection().setReadOnly(isReadOnly);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.getPhysicalConnection().getCatalog();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.getPhysicalConnection().setCatalog(catalog);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            return this.getPhysicalConnection().getTransactionIsolation();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.getPhysicalConnection().setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getPhysicalConnection().getWarnings();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.getPhysicalConnection().clearWarnings();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            java.sql.Statement result = this.getPhysicalConnection().createStatement(resultSetType, resultSetConcurrency);
            if (result != null) {
                result = Statement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            java.sql.PreparedStatement result = this.getPhysicalConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
            if (result != null) {
                result = PreparedStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            java.sql.CallableStatement result = this.getPhysicalConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
            if (result != null) {
                result = CallableStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getPhysicalConnection().getTypeMap();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        try {
            this.getPhysicalConnection().setTypeMap(typeMap);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            java.sql.Statement result = this.getPhysicalConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            if (result != null) {
                result = Statement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            java.sql.PreparedStatement result = this.getPhysicalConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (result != null) {
                result = PreparedStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            java.sql.CallableStatement result = this.getPhysicalConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (result != null) {
                result = CallableStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            java.sql.PreparedStatement result = this.getPhysicalConnection().prepareStatement(sql, autoGeneratedKeys);
            if (result != null) {
                result = PreparedStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            java.sql.PreparedStatement result = this.getPhysicalConnection().prepareStatement(sql, columnIndexes);
            if (result != null) {
                result = PreparedStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            java.sql.PreparedStatement result = this.getPhysicalConnection().prepareStatement(sql, columnNames);
            if (result != null) {
                result = PreparedStatement.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.getPhysicalConnection().getHoldability();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.getPhysicalConnection().setHoldability(holdability);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.getPhysicalConnection().setSavepoint();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            return this.getPhysicalConnection().setSavepoint(name);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.getPhysicalConnection().rollback(savepoint);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getPhysicalConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Clob createClob() throws SQLException {
        try {
            java.sql.Clob result = this.getPhysicalConnection().createClob();
            if (result != null) {
                result = Clob.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Blob createBlob() throws SQLException {
        try {
            java.sql.Blob result = this.getPhysicalConnection().createBlob();
            if (result != null) {
                result = Blob.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            NClob result = this.getPhysicalConnection().createNClob();
            if (result != null) {
                result = Clob.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            return this.getPhysicalConnection().createSQLXML();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return this.getPhysicalConnection().isValid(timeout);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            return this.getPhysicalConnection().getClientInfo();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getClientInfo(String key) throws SQLException {
        try {
            return this.getPhysicalConnection().getClientInfo(key);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getPhysicalConnection().setClientInfo(properties);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw (SQLClientInfoException)e;
        }
    }

    @Override
    public void setClientInfo(String key, String value) throws SQLClientInfoException {
        try {
            this.getPhysicalConnection().setClientInfo(key, value);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw (SQLClientInfoException)e;
        }
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            java.sql.Array result = this.getPhysicalConnection().createArrayOf(typeName, elements);
            if (result != null) {
                result = Array.newInstance(result, this, this);
            }
            return result;
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.getPhysicalConnection().createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.getPhysicalConnection().getSchema();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.getPhysicalConnection().setSchema(schema);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.getPhysicalConnection().abort(executor);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.getPhysicalConnection().getNetworkTimeout();
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.getPhysicalConnection().setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.getPhysicalConnection().unwrap(iface);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.getPhysicalConnection().isWrapperFor(iface);
        }
        catch (SQLException e) {
            this.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatements() throws SQLException {
        Set<java.sql.PreparedStatement> set = this._statements;
        synchronized (set) {
            for (java.sql.PreparedStatement statement : new HashSet<java.sql.PreparedStatement>(this._statements)) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _addStatement(java.sql.PreparedStatement statement) {
        Set<java.sql.PreparedStatement> set = this._statements;
        synchronized (set) {
            this._statements.add(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _removeStatement(java.sql.PreparedStatement statement) {
        Set<java.sql.PreparedStatement> set = this._statements;
        synchronized (set) {
            this._statements.remove(statement);
        }
    }
}

