/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext.wrapper;

import com.sap.db.jdbcext.wrapper.Array;
import com.sap.db.jdbcext.wrapper.Blob;
import com.sap.db.jdbcext.wrapper.Clob;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.jdbcext.wrapper.ParameterMetaData;
import com.sap.db.jdbcext.wrapper.ResultSet;
import com.sap.db.jdbcext.wrapper.ResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class CallableStatement
implements java.sql.CallableStatement {
    private final java.sql.CallableStatement _inner;
    private final Object _creator;
    private final Connection _clientConnection;
    private java.sql.ResultSet _wrappedResultSet;
    private java.sql.ResultSetMetaData _wrappedResultSetMetaData;
    private java.sql.ParameterMetaData _wrappedParameterMetaData;

    public static CallableStatement newInstance(java.sql.CallableStatement inner, Object creator, Connection clientConnection) {
        return new CallableStatement(inner, creator, clientConnection);
    }

    private CallableStatement(java.sql.CallableStatement inner, Object creator, Connection clientConnection) {
        this._inner = inner;
        this._creator = creator;
        this._clientConnection = clientConnection;
        this._clientConnection._addStatement(this);
    }

    @Override
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            java.sql.ResultSet result = this._inner.executeQuery(sql);
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            this._wrappedResultSet = result;
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._inner.close();
            this._clientConnection.sendStatementClosedEvent(this);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
        finally {
            this._clientConnection._removeStatement(this);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this._inner.getMaxFieldSize();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        try {
            this._inner.setMaxFieldSize(maxFieldSize);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this._inner.getMaxRows();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        try {
            this._inner.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this._inner.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this._inner.getQueryTimeout();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        try {
            this._inner.setQueryTimeout(queryTimeout);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this._inner.cancel();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._inner.getWarnings();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this._inner.clearWarnings();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        try {
            this._inner.setCursorName(cursorName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        try {
            if (this._wrappedResultSet == null) {
                this._wrappedResultSet = this._inner.getResultSet();
            }
            if (this._wrappedResultSet != null) {
                this._wrappedResultSet = ResultSet.newInstance(this._wrappedResultSet, this, this._clientConnection);
            }
            return this._wrappedResultSet;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this._inner.getUpdateCount();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.getMoreResults();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._inner.getFetchDirection();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        try {
            this._inner.setFetchDirection(fetchDirection);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._inner.getFetchSize();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        try {
            this._inner.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this._inner.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this._inner.getResultSetType();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this._inner.addBatch(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this._inner.clearBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)this._creator;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.getMoreResults(current);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        try {
            java.sql.ResultSet result = this._inner.getGeneratedKeys();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._inner.getResultSetHoldability();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._inner.isClosed();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this._inner.isPoolable();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        try {
            this._inner.setPoolable(isPoolable);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this._inner.isCloseOnCompletion();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this._inner.closeOnCompletion();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            return this._inner.getLargeUpdateCount();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this._inner.getLargeMaxRows();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            this._inner.setLargeMaxRows(max);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        try {
            this._wrappedResultSet = null;
            java.sql.ResultSet result = this._inner.executeQuery();
            if (result != null) {
                result = ResultSet.newInstance(result, this, this._clientConnection);
            }
            this._wrappedResultSet = result;
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this._inner.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this._inner.setBoolean(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this._inner.setByte(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this._inner.setShort(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this._inner.setInt(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this._inner.setLong(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this._inner.setFloat(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this._inner.setDouble(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this._inner.setBigDecimal(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this._inner.setDate(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this._inner.setTime(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this._inner.setTimestamp(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this._inner.setString(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this._inner.setBytes(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this._inner.clearParameters();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this._inner.addBatch();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this._inner.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this._inner.setDate(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this._inner.setTime(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this._inner.setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, java.sql.Clob x) throws SQLException {
        try {
            this._inner.setClob(parameterIndex, Clob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, java.sql.Blob x) throws SQLException {
        try {
            this._inner.setBlob(parameterIndex, Blob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setArray(int parameterIndex, java.sql.Array x) throws SQLException {
        try {
            this._inner.setArray(parameterIndex, Array.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            this._inner.setRef(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (this._wrappedResultSetMetaData == null) {
                this._wrappedResultSetMetaData = this._inner.getMetaData();
            }
            if (this._wrappedResultSetMetaData != null) {
                this._wrappedResultSetMetaData = ResultSetMetaData.newInstance(this._wrappedResultSetMetaData, this, this._clientConnection);
            }
            return this._wrappedResultSetMetaData;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            this._inner.setURL(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            if (this._wrappedParameterMetaData == null) {
                this._wrappedParameterMetaData = this._inner.getParameterMetaData();
            }
            if (this._wrappedParameterMetaData != null) {
                this._wrappedParameterMetaData = ParameterMetaData.newInstance(this._wrappedParameterMetaData, this, this._clientConnection);
            }
            return this._wrappedParameterMetaData;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            this._inner.setNString(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setNCharacterStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setNCharacterStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        try {
            this._inner.setNClob(parameterIndex, (NClob)Clob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        try {
            this._inner.setNClob(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            this._inner.setNClob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        try {
            this._inner.setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this._inner.setBlob(parameterIndex, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        try {
            this._inner.setRowId(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        try {
            this._inner.setSQLXML(parameterIndex, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this._inner.wasNull();
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        try {
            return this._inner.getObject(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        try {
            return this._inner.getBoolean(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        try {
            return this._inner.getByte(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        try {
            return this._inner.getShort(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        try {
            return this._inner.getInt(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        try {
            return this._inner.getLong(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        try {
            return this._inner.getFloat(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        try {
            return this._inner.getDouble(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        try {
            return this._inner.getBigDecimal(parameterIndex, scale);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        try {
            return this._inner.getDate(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        try {
            return this._inner.getTime(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        try {
            return this._inner.getTimestamp(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        try {
            return this._inner.getString(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        try {
            return this._inner.getBytes(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return this._inner.getObject(parameterIndex, map);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        try {
            return this._inner.getBigDecimal(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        try {
            return this._inner.getDate(parameterIndex, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        try {
            return this._inner.getTime(parameterIndex, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        try {
            return this._inner.getTimestamp(parameterIndex, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Clob getClob(int parameterIndex) throws SQLException {
        try {
            java.sql.Clob result = this._inner.getClob(parameterIndex);
            if (result != null) {
                result = Clob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Blob getBlob(int parameterIndex) throws SQLException {
        try {
            java.sql.Blob result = this._inner.getBlob(parameterIndex);
            if (result != null) {
                result = Blob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Array getArray(int parameterIndex) throws SQLException {
        try {
            java.sql.Array result = this._inner.getArray(parameterIndex);
            if (result != null) {
                result = Array.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        try {
            return this._inner.getRef(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        try {
            return this._inner.getObject(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        try {
            return this._inner.getObject(parameterName, map);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        try {
            return this._inner.getBoolean(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        try {
            return this._inner.getByte(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        try {
            return this._inner.getShort(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        try {
            return this._inner.getInt(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        try {
            return this._inner.getLong(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        try {
            return this._inner.getFloat(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        try {
            return this._inner.getDouble(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        try {
            return this._inner.getBigDecimal(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        try {
            return this._inner.getDate(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        try {
            return this._inner.getDate(parameterName, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        try {
            return this._inner.getTime(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        try {
            return this._inner.getTime(parameterName, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        try {
            return this._inner.getTimestamp(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        try {
            return this._inner.getTimestamp(parameterName, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        try {
            return this._inner.getString(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        try {
            return this._inner.getBytes(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Clob getClob(String parameterName) throws SQLException {
        try {
            java.sql.Clob result = this._inner.getClob(parameterName);
            if (result != null) {
                result = Clob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Blob getBlob(String parameterName) throws SQLException {
        try {
            java.sql.Blob result = this._inner.getBlob(parameterName);
            if (result != null) {
                result = Blob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public java.sql.Array getArray(String parameterName) throws SQLException {
        try {
            java.sql.Array result = this._inner.getArray(parameterName);
            if (result != null) {
                result = Array.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        try {
            return this._inner.getRef(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        try {
            return this._inner.getURL(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        try {
            return this._inner.getURL(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        try {
            this._inner.setNull(parameterName, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            this._inner.setNull(parameterName, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        try {
            this._inner.setObject(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        try {
            this._inner.setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            this._inner.setObject(parameterName, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        try {
            this._inner.setBoolean(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        try {
            this._inner.setByte(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        try {
            this._inner.setShort(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        try {
            this._inner.setInt(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        try {
            this._inner.setLong(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        try {
            this._inner.setFloat(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        try {
            this._inner.setDouble(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        try {
            this._inner.setBigDecimal(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        try {
            this._inner.setDate(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        try {
            this._inner.setDate(parameterName, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        try {
            this._inner.setTime(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        try {
            this._inner.setTime(parameterName, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        try {
            this._inner.setTimestamp(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        try {
            this._inner.setTimestamp(parameterName, x, cal);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        try {
            this._inner.setString(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        try {
            this._inner.setBytes(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setURL(String parameterName, URL x) throws SQLException {
        try {
            this._inner.setURL(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        try {
            return this._inner.getNString(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        try {
            return this._inner.getNString(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        try {
            return this._inner.getCharacterStream(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        try {
            return this._inner.getCharacterStream(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        try {
            return this._inner.getNCharacterStream(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        try {
            return this._inner.getNCharacterStream(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        try {
            NClob result = this._inner.getNClob(parameterIndex);
            if (result != null) {
                result = Clob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        try {
            NClob result = this._inner.getNClob(parameterName);
            if (result != null) {
                result = Clob.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        try {
            return this._inner.getRowId(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        try {
            return this._inner.getRowId(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        try {
            return this._inner.getSQLXML(parameterIndex);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        try {
            return this._inner.getSQLXML(parameterName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNString(String parameterName, String x) throws SQLException {
        try {
            this._inner.setNString(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        try {
            this._inner.setAsciiStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        try {
            this._inner.setCharacterStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        try {
            this._inner.setNCharacterStream(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        try {
            this._inner.setNCharacterStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        try {
            this._inner.setBinaryStream(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(String parameterName, java.sql.Clob x) throws SQLException {
        try {
            this._inner.setClob(parameterName, Clob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(String parameterName, Reader x) throws SQLException {
        try {
            this._inner.setClob(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setClob(String parameterName, Reader x, long length) throws SQLException {
        try {
            this._inner.setClob(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(String parameterName, NClob x) throws SQLException {
        try {
            this._inner.setNClob(parameterName, (NClob)Clob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(String parameterName, Reader x) throws SQLException {
        try {
            this._inner.setNClob(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setNClob(String parameterName, Reader x, long length) throws SQLException {
        try {
            this._inner.setNClob(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(String parameterName, java.sql.Blob x) throws SQLException {
        try {
            this._inner.setBlob(parameterName, Blob.getInner(x));
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x) throws SQLException {
        try {
            this._inner.setBlob(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        try {
            this._inner.setBlob(parameterName, x, length);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        try {
            this._inner.setRowId(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        try {
            this._inner.setSQLXML(parameterName, x);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        try {
            return this._inner.getObject(parameterIndex, type);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        try {
            return this._inner.getObject(parameterName, type);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        try {
            this._inner.setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            this._inner.setObject(parameterName, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        try {
            this._inner.registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this._inner.unwrap(iface);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this._inner.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this._exceptionOccurred(e);
            throw e;
        }
    }

    public java.sql.CallableStatement getInner() {
        return this._inner;
    }

    private void _exceptionOccurred(SQLException e) {
        this._clientConnection.sendConnectionErrorEvent(e);
        this._clientConnection.sendStatementErrorEvent(e, this);
    }
}

