/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbcext.wrapper.Connection;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class PooledConnectionSAP
implements PooledConnection {
    private final Set<ConnectionEventListener> _connectionEventListeners = new HashSet<ConnectionEventListener>();
    private final Set<StatementEventListener> _statementEventListeners = new HashSet<StatementEventListener>();
    private final java.sql.Connection _physicalConnection;
    private WeakReference<PooledClientConnectionSapDB> _lastClientConnection;

    protected PooledConnectionSAP(java.sql.Connection physicalConnection) {
        this._physicalConnection = physicalConnection;
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return this._getConnection();
    }

    @Override
    public void close() throws SQLException {
        this._physicalConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            this._connectionEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            this._connectionEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            this._statementEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            this._statementEventListeners.remove(listener);
        }
    }

    public void reinitialize(ConnectionSapDB connection) throws SQLException {
        connection.reinitialize(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<StatementEventListener> _getStatementEventListeners() {
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            return Collections.unmodifiableSet(this._statementEventListeners);
        }
    }

    private synchronized java.sql.Connection _getConnection() throws SQLException {
        PooledClientConnectionSapDB pcc;
        if (this._lastClientConnection != null && (pcc = (PooledClientConnectionSapDB)this._lastClientConnection.get()) != null) {
            pcc._close(false);
        }
        pcc = new PooledClientConnectionSapDB();
        this._lastClientConnection = new WeakReference<PooledClientConnectionSapDB>(pcc);
        return pcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendConnectionClosed() {
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            if (this._connectionEventListeners.isEmpty()) {
                return;
            }
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            for (ConnectionEventListener l : this._connectionEventListeners) {
                l.connectionClosed(connectionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendConnectionError(SQLException e) {
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            if (this._connectionEventListeners.isEmpty()) {
                return;
            }
            ConnectionEvent connectionEvent = new ConnectionEvent(this, e);
            for (ConnectionEventListener l : this._connectionEventListeners) {
                l.connectionErrorOccurred(connectionEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendStatementClosed(PreparedStatement ps) {
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            if (this._statementEventListeners.isEmpty()) {
                return;
            }
            StatementEvent statementEvent = new StatementEvent(this, ps);
            for (StatementEventListener l : this._statementEventListeners) {
                l.statementClosed(statementEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendStatementError(PreparedStatement ps, SQLException e) {
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            if (this._statementEventListeners.isEmpty()) {
                return;
            }
            StatementEvent statementEvent = new StatementEvent(this, ps, e);
            for (StatementEventListener l : this._statementEventListeners) {
                l.statementErrorOccurred(statementEvent);
            }
        }
    }

    private class PooledClientConnectionSapDB
    extends Connection {
        private boolean _isClosed;

        private PooledClientConnectionSapDB() {
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public java.sql.Connection getPhysicalConnection() {
            return PooledConnectionSAP.this._physicalConnection;
        }

        @Override
        public void sendConnectionErrorEvent(SQLException e) {
            boolean doSend;
            boolean bl = doSend = e instanceof SQLExceptionSapDBInterface ? ((SQLExceptionSapDBInterface)((Object)e)).isConnectionReleasing() : true;
            if (doSend) {
                PooledConnectionSAP.this._sendConnectionError(e);
            }
        }

        @Override
        public void sendStatementErrorEvent(SQLException e, PreparedStatement ps) {
            boolean doSend;
            boolean bl = doSend = e instanceof SQLExceptionSapDBInterface ? ((SQLExceptionSapDBInterface)((Object)e)).isConnectionReleasing() : true;
            if (doSend) {
                PooledConnectionSAP.this._sendStatementError(ps, e);
            }
        }

        @Override
        public void sendStatementClosedEvent(PreparedStatement ps) {
            PooledConnectionSAP.this._sendStatementClosed(ps);
        }

        @Override
        public synchronized boolean isClosed() throws SQLException {
            return this._isClosed ? true : super.isClosed();
        }

        @Override
        public synchronized void close() throws SQLException {
            if (this._isClosed) {
                return;
            }
            this._close(true);
        }

        private synchronized void _close(boolean sendConnectionClosed) throws SQLException {
            ConnectionSapDB c;
            this.closeStatements();
            if (!this.getAutoCommit()) {
                this.rollback();
            }
            if ((c = ConnectionSapDB.getConnectionSapDB(PooledConnectionSAP.this._physicalConnection)) != null) {
                PooledConnectionSAP.this.reinitialize(c);
            }
            this._isClosed = true;
            if (sendConnectionClosed) {
                PooledConnectionSAP.this._sendConnectionClosed();
            }
        }
    }
}

