/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.jdbcext.AbstractDataSource;
import com.sap.db.jdbcext.ConnectionPoolDataSourceSAP;
import com.sap.db.jdbcext.DataSourceSAP;
import com.sap.db.jdbcext.XADataSourceSAP;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class DataSourceSAPFactory
implements ObjectFactory {
    private static final HashSet<String> FORBIDDEN_PROPERTIES = new HashSet();

    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        AbstractDataSource result;
        if (!(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        String className = reference.getClassName();
        if (XADataSourceSAP.class.getCanonicalName().equals(className)) {
            result = new XADataSourceSAP();
        } else if (ConnectionPoolDataSourceSAP.class.getCanonicalName().equals(className)) {
            result = new ConnectionPoolDataSourceSAP();
        } else if (DataSourceSAP.class.getCanonicalName().equals(className)) {
            result = new DataSourceSAP();
        } else {
            return null;
        }
        Properties properties = this._getPropertiesFromReference(reference);
        result.setProperties(properties);
        return result;
    }

    private Properties _getPropertiesFromReference(Reference reference) {
        Enumeration<RefAddr> refAddrs = reference.getAll();
        Properties properties = new Properties();
        while (refAddrs.hasMoreElements()) {
            RefAddr refAddr = refAddrs.nextElement();
            if (!(refAddr instanceof StringRefAddr)) continue;
            StringRefAddr stringRefAddr = (StringRefAddr)refAddr;
            String type = stringRefAddr.getType();
            String content = (String)stringRefAddr.getContent();
            if (type == null || content == null || FORBIDDEN_PROPERTIES.contains(type)) continue;
            if (type.equals("isolation")) {
                if (content.equals("none")) continue;
                if (content.equals("ruc")) {
                    content = "TRANSACTION_READ_UNCOMMITTED";
                } else if (content.equals("rc")) {
                    content = "TRANSACTION_READ_COMMITTED";
                } else if (content.equals("rr")) {
                    content = "TRANSACTION_REPEATABLE_READ";
                } else if (content.equals("s")) {
                    content = "TRANSACTION_SERIALIZABLE";
                }
            }
            properties.setProperty(type, content);
        }
        return properties;
    }

    static {
        FORBIDDEN_PROPERTIES.add("autoCommit");
    }
}

