/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractDateTimeTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Set;

class TimestampTranslator
extends AbstractDateTimeTranslator {
    protected TimestampTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getPrecision() {
        return 23;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsTimestamp(controller, dataPart, null);
    }

    @Override
    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Timestamp timestamp = this._getValueAsTimestamp(controller, dataPart, cal);
        return timestamp != null ? new Date(timestamp.getTime()) : null;
    }

    @Override
    public Object setDate(Date val, Calendar cal) throws SQLException {
        return this._transUtilDateToDate(val, cal);
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Timestamp timestamp = this._getValueAsTimestamp(controller, dataPart, cal);
        return timestamp != null ? new Time(TimestampTranslator._normalizeTimeMilliseconds(timestamp.getTime())) : null;
    }

    @Override
    public Object setTime(Time val, Calendar cal) throws SQLException {
        return this._transUtilDateToTime(val, cal);
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsTimestamp(controller, dataPart, cal);
    }

    @Override
    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        return this._transTimestampToTimestamp(val, cal);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return TimestampTranslator._formatTimestamp(this._getValueAsTimestamp(controller, dataPart, null), true);
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transStringToTimestamp(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp _getValueAsTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        byte[] packet = dataPart.getRawPacketArray();
        int offset = dataPart.getNonNullDataOffset();
        int year = packet[offset] & 0xFF | packet[offset + 1] << 8 & 0xFF00;
        byte month = packet[offset + 2];
        byte day = packet[offset + 3];
        int hour = packet[offset + 4];
        byte min = packet[offset + 5];
        int millisec = packet[offset + 6] & 0xFF | packet[offset + 7] << 8 & 0xFF00;
        if ((year & 0x8000) != 0) {
            year &= Short.MAX_VALUE;
        }
        if ((year & 0x4000) != 0) {
            year |= 0x8000;
        }
        if ((hour & 0x80) != 0) {
            hour &= 0x7F;
        }
        if (cal == null) {
            Calendar calendar = CALENDAR;
            synchronized (calendar) {
                return TimestampTranslator._newTimestamp(CALENDAR, year, month, day, hour, min, millisec / 1000, millisec % 1000 * 1000000);
            }
        }
        return TimestampTranslator._newTimestamp(cal, year, month, day, hour, min, millisec / 1000, millisec % 1000 * 1000000);
    }

    private static Timestamp _newTimestamp(Calendar cal, int year, int month, int day, int hour, int minute, int second, int nanos) {
        cal.clear();
        cal.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

