/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractDateTimeTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Set;

class TimeTranslator
extends AbstractDateTimeTranslator {
    protected TimeTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getPrecision() {
        return 8;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsTime(controller, dataPart, null, false);
    }

    @Override
    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Time time = this._getValueAsTime(controller, dataPart, cal, true);
        return time != null ? new Date(time.getTime()) : null;
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsTime(controller, dataPart, cal, false);
    }

    @Override
    public Object setTime(Time val, Calendar cal) throws SQLException {
        return this._transUtilDateToTime(val, cal);
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Time time = this._getValueAsTime(controller, dataPart, cal, true);
        return time != null ? new Timestamp(time.getTime()) : null;
    }

    @Override
    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        return this._transUtilDateToTime(val, cal);
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transStringToTime(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time _getValueAsTime(SQLParamController controller, HDataPart dataPart, Calendar cal, boolean setCurrentDate) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        byte[] packet = dataPart.getRawPacketArray();
        int offset = dataPart.getNonNullDataOffset();
        int hour = packet[offset];
        byte min = packet[offset + 1];
        int millisec = packet[offset + 2] & 0xFF | packet[offset + 3] << 8 & 0xFF00;
        if ((hour & 0x80) != 0) {
            hour &= 0x7F;
        }
        if (cal == null) {
            Calendar calendar = CALENDAR;
            synchronized (calendar) {
                return TimeTranslator._newTime(CALENDAR, setCurrentDate, hour, min, millisec / 1000);
            }
        }
        return TimeTranslator._newTime(cal, setCurrentDate, hour, min, millisec / 1000);
    }

    private static Time _newTime(Calendar cal, boolean setCurrentDate, int hour, int minute, int second) {
        cal.clear();
        if (setCurrentDate) {
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(14, 0);
        }
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        long ms = cal.getTimeInMillis();
        if (!setCurrentDate) {
            ms = TimeTranslator._normalizeTimeMilliseconds(ms);
        }
        return new Time(ms);
    }
}

