/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.LongDateTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;

class SecondDateTranslator
extends LongDateTranslator {
    protected SecondDateTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getPrecision() {
        return 19;
    }

    @Override
    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        return this._transTimestampToSecondDate(val, cal);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return SecondDateTranslator._formatTimestamp(this._getValueAsTimestamp(controller, dataPart, null), false);
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : "";
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transStringToSecondDate(val);
    }

    @Override
    protected Timestamp _getValueAsTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Timestamp(this._getMillis(dataPart, cal));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : ONE_SECOND_BEFORE_HANA_EPOCH_TIMESTAMP;
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    protected long _getMillis(HDataPart dataPart, Calendar cal) {
        long secondDate = dataPart.getValueAsLong() - 1L;
        long ms = (secondDate - 62135769600L) * 1000L;
        TimeZone tz = cal != null ? cal.getTimeZone() : TIME_ZONE;
        int offset = tz.getOffset(ms);
        return ms - (long)offset;
    }
}

