/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

class ReaderInputStream
extends InputStream {
    private final Reader _reader;
    private final CharsetEncoder _encoder;
    private final CharBuffer _in;
    private final ByteBuffer _out;
    private CoderResult _coderResult;
    private boolean _endOfInput;

    ReaderInputStream(Reader reader, int bufferSize) {
        this(reader, bufferSize, Charset.defaultCharset());
    }

    ReaderInputStream(Reader reader, int bufferSize, Charset charset) {
        this._reader = reader;
        this._encoder = charset.newEncoder();
        this._encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this._encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this._in = CharBuffer.allocate(bufferSize);
        this._in.flip();
        this._out = ByteBuffer.allocate(bufferSize);
        this._out.flip();
        this._coderResult = CoderResult.UNDERFLOW;
    }

    @Override
    public int read() throws IOException {
        if (this._out.hasRemaining()) {
            return this._out.get();
        }
        if (!this._endOfInput && this._coderResult.isUnderflow()) {
            this._in.compact();
            int n = this._reader.read(this._in.array(), this._in.position(), this._in.remaining());
            if (n != -1) {
                this._in.position(this._in.position() + n);
            } else {
                this._endOfInput = true;
            }
            this._in.flip();
        }
        this._out.compact();
        this._coderResult = this._encoder.encode(this._in, this._out, this._endOfInput);
        this._out.flip();
        return this._out.hasRemaining() ? (int)this._out.get() : -1;
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }
}

