/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractNumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

class IntegerTranslator
extends AbstractNumericTranslator {
    protected IntegerTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getColumnDisplaySize() {
        return String.valueOf(Integer.MAX_VALUE).length() + 1;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : Integer.valueOf(this._getValueAsInt(controller, dataPart, false));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true) != 0;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (byte)this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return (short)this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsInt(controller, dataPart, true);
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : BigDecimal.valueOf(this._getValueAsInt(controller, dataPart, false));
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsInt(controller, dataPart, false));
    }

    private int _getValueAsInt(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        return doNullCheck && dataPart.isNull(controller) ? 0 : dataPart.getValueAsInt();
    }
}

