/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractNumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

class DecimalTranslator
extends AbstractNumericTranslator {
    protected DecimalTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getColumnDisplaySize() {
        return this._length + (this._fraction > 0 ? 1 : 0) + (this._length < this._fraction ? 1 : 0) + 1;
    }

    @Override
    public int getScale() {
        return this._fraction == Short.MAX_VALUE ? 0 : this._fraction;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBigDecimal(controller, dataPart, true);
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? false : this._getValueAsBigDecimal(controller, dataPart, false).longValue() != 0L;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? (byte)0 : this._getValueAsBigDecimal(controller, dataPart, false).byteValue();
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? (short)0 : this._getValueAsBigDecimal(controller, dataPart, false).shortValue();
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0 : this._getValueAsBigDecimal(controller, dataPart, false).intValue();
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0L : this._getValueAsBigDecimal(controller, dataPart, false).longValue();
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0.0f : this._getValueAsBigDecimal(controller, dataPart, false).floatValue();
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? 0.0 : this._getValueAsBigDecimal(controller, dataPart, false).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBigDecimal(controller, dataPart, true);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsBigDecimal(controller, dataPart, false));
    }

    private BigDecimal _getValueAsBigDecimal(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        return doNullCheck && dataPart.isNull(controller) ? null : dataPart.getValueAsBigDecimal(this._fraction);
    }
}

