/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractDateTimeTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;

class DayDateTranslator
extends AbstractDateTimeTranslator {
    protected DayDateTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getPrecision() {
        return 10;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsDate(controller, dataPart, null);
    }

    @Override
    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsDate(controller, dataPart, cal);
    }

    @Override
    public Object setDate(Date val, Calendar cal) throws SQLException {
        return this._transUtilDateToDayDate(val, cal);
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsTime(controller, dataPart, cal);
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsTimestamp(controller, dataPart, cal);
    }

    @Override
    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        return this._transUtilDateToDayDate(val, cal);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return super.getString(controller, dataPart);
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : "";
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transStringToDayDate(val);
    }

    @Override
    protected int _putNull(HDataPart dataPart) {
        return dataPart.addNull(DataType.DATE);
    }

    private Date _getValueAsDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Date(this._getMillis(dataPart, cal));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : ONE_DAY_BEFORE_HANA_EPOCH_DATE;
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Time _getValueAsTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Time(DayDateTranslator._normalizeTimeMilliseconds(this._getMillis(dataPart, cal)));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : ONE_DAY_BEFORE_HANA_EPOCH_TIME;
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private Timestamp _getValueAsTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        DataFormatDescription.NullIndicator nullIndicator = dataPart.getNullIndicator(controller);
        switch (nullIndicator) {
            case NOT_NULL: {
                return new Timestamp(this._getMillis(dataPart, cal));
            }
            case NULL: {
                return null;
            }
            case SPECIAL_NULL: {
                return this._emptyTimestampIsNull ? null : ONE_DAY_BEFORE_HANA_EPOCH_TIMESTAMP;
            }
        }
        throw new AssertionError((Object)("Unexpected NullIndicator value: " + (Object)((Object)nullIndicator)));
    }

    private long _getMillis(HDataPart dataPart, Calendar cal) {
        int dayDate = dataPart.getValueAsInt();
        long ms = ((long)dayDate - 719164L - 1L) * 86400000L;
        TimeZone tz = cal != null ? cal.getTimeZone() : TIME_ZONE;
        int offset = tz.getOffset(ms);
        return ms - (long)offset;
    }
}

