/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractDateTimeTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Set;

class DateTranslator
extends AbstractDateTimeTranslator {
    protected DateTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getPrecision() {
        return 10;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsDate(controller, dataPart, null);
    }

    @Override
    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsDate(controller, dataPart, cal);
    }

    @Override
    public Object setDate(Date val, Calendar cal) throws SQLException {
        return this._transUtilDateToDate(val, cal);
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Date date = this._getValueAsDate(controller, dataPart, cal);
        return date != null ? new Time(DateTranslator._normalizeTimeMilliseconds(date.getTime())) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Date date = this._getValueAsDate(controller, dataPart, cal);
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    @Override
    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        return this._transUtilDateToDate(val, cal);
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transStringToDate(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date _getValueAsDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        byte[] packet = dataPart.getRawPacketArray();
        int offset = dataPart.getNonNullDataOffset();
        int year = packet[offset] & 0xFF | packet[offset + 1] << 8 & 0xFF00;
        byte month = packet[offset + 2];
        byte day = packet[offset + 3];
        if ((year & 0x8000) != 0) {
            year &= Short.MAX_VALUE;
        }
        if ((year & 0x4000) != 0) {
            year |= 0x8000;
        }
        if (cal == null) {
            Calendar calendar = CALENDAR;
            synchronized (calendar) {
                return DateTranslator._newDate(CALENDAR, year, month, day);
            }
        }
        return DateTranslator._newDate(cal, year, month, day);
    }

    private static Date _newDate(Calendar cal, int year, int month, int day) {
        cal.clear();
        cal.set(year, month, day);
        return new Date(cal.getTimeInMillis());
    }
}

