/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractGetval;
import com.sap.db.jdbc.translators.AbstractLobTranslator;
import com.sap.db.jdbc.translators.GetvalClob;
import com.sap.db.jdbc.translators.InputStreamFilter;
import com.sap.db.jdbc.translators.SQLParamController;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Set;

class ClobTranslator
extends AbstractLobTranslator {
    private final boolean _isNClob;

    protected ClobTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel, boolean isNClob) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
        this._isNClob = isNClob;
    }

    @Override
    protected AbstractGetval _getLob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        return new GetvalClob(controller, dataPart, this._outputFieldPos, this._length, this._isNClob);
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transStringToClob(val);
    }

    @Override
    public Object setBytes(byte[] val) throws SQLException {
        return this._transStringToClob(val != null ? new String(val) : null);
    }

    @Override
    public Object setCharacterStream(Reader val, long length) throws SQLException {
        return this._transReaderToClob(val, length);
    }

    @Override
    public Object setAsciiStream(InputStream val, long length) throws SQLException {
        return this._transReaderToClob(val != null ? new InputStreamReader(length >= 0L ? new InputStreamFilter(val, length) : val, CHARSET_ISO_8859_1) : null, -1L);
    }

    @Override
    public Object setBinaryStream(InputStream val, long length) throws SQLException {
        return this._transReaderToClob(val != null ? new InputStreamReader(length >= 0L ? new InputStreamFilter(val, length) : val) : null, -1L);
    }

    @Override
    public Clob getClob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? (Clob)((Object)getval) : null;
    }

    @Override
    public Object setClob(Clob clob) throws SQLException {
        return this._transClobToClob(clob);
    }
}

