/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractDateTimeTranslator;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.InputStreamFilter;
import com.sap.db.jdbc.translators.SQLParamController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Set;

class CharacterTranslator
extends AbstractTranslator {
    protected CharacterTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    protected Object _transSpecific(Object obj) throws SQLException {
        if (obj instanceof byte[]) {
            throw this._newSetException("byte[]");
        }
        return null;
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsString(controller, dataPart);
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return false;
        }
        if (Boolean.valueOf(value).booleanValue()) {
            return true;
        }
        try {
            return !new BigDecimal(value).equals(BigDecimal.ZERO);
        }
        catch (NumberFormatException e1) {
            return false;
        }
    }

    @Override
    public Object setBoolean(boolean val) throws SQLException {
        return this._transBooleanToTinyInt(val);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return 0;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).byteValue();
            }
            catch (NumberFormatException e1) {
                throw this._newParseException(value, "byte");
            }
        }
    }

    @Override
    public Object setByte(byte val) throws SQLException {
        return this._transByteToSmallInt(val);
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return 0;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).shortValue();
            }
            catch (NumberFormatException e1) {
                throw this._newParseException(value, "short");
            }
        }
    }

    @Override
    public Object setShort(short val) throws SQLException {
        return this._transShortToSmallInt(val);
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).intValue();
            }
            catch (NumberFormatException e1) {
                throw this._newParseException(value, "int");
            }
        }
    }

    @Override
    public Object setInt(int val) throws SQLException {
        return this._transIntToInteger(val);
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).longValue();
            }
            catch (NumberFormatException e1) {
                throw this._newParseException(value, "long");
            }
        }
    }

    @Override
    public Object setLong(long val) throws SQLException {
        return this._transLongToBigInt(val);
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).floatValue();
            }
            catch (NumberFormatException e1) {
                throw this._newParseException(value, "float");
            }
        }
    }

    @Override
    public Object setFloat(float val) throws SQLException {
        return this._transFloatToReal(val);
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            try {
                return new BigDecimal(value).doubleValue();
            }
            catch (NumberFormatException e1) {
                throw this._newParseException(value, "double");
            }
        }
    }

    @Override
    public Object setDouble(double val) throws SQLException {
        return this._transDoubleToDouble(val);
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return null;
        }
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e1) {
            throw this._newParseException(value, "java.math.BigDecimal");
        }
    }

    @Override
    public Object setBigDecimal(BigDecimal val) throws SQLException {
        return this._transBigDecimalToDecimal(val);
    }

    @Override
    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return null;
        }
        try {
            return CharacterTranslator._getDate(value, cal);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Date(CharacterTranslator._getTimestamp(value, cal).getTime());
            }
            catch (IllegalArgumentException e1) {
                throw this._newParseException(value, "java.sql.Date");
            }
        }
    }

    @Override
    public Object setDate(Date val, Calendar cal) throws SQLException {
        return this._transUtilDateToDate(val, cal);
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return null;
        }
        try {
            return CharacterTranslator._getTime(value, cal);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Time(AbstractDateTimeTranslator._normalizeTimeMilliseconds(CharacterTranslator._getTimestamp(value, cal).getTime()));
            }
            catch (IllegalArgumentException e1) {
                throw this._newParseException(value, "java.sql.Time");
            }
        }
    }

    @Override
    public Object setTime(Time val, Calendar cal) throws SQLException {
        return this._transUtilDateToTime(val, cal);
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        if (value == null) {
            return null;
        }
        try {
            return CharacterTranslator._getTimestamp(value, cal);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Timestamp(CharacterTranslator._getDate(value, cal).getTime());
            }
            catch (IllegalArgumentException e1) {
                throw this._newParseException(value, "java.sql.Timestamp");
            }
        }
    }

    @Override
    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        return this._transTimestampToTimestamp(val, cal);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsString(controller, dataPart);
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        return value != null ? value.getBytes() : null;
    }

    @Override
    public Object setBytes(byte[] val) throws SQLException {
        return this._transStringToString(val != null ? new String(val) : null);
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        return value != null ? new StringReader(value) : null;
    }

    @Override
    public Object setCharacterStream(Reader val, long length) throws SQLException {
        return this._transReaderToString(val, length);
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        return value != null ? new ByteArrayInputStream(value.getBytes(CHARSET_ISO_8859_1)) : null;
    }

    @Override
    public Object setAsciiStream(InputStream val, long length) throws SQLException {
        return this._transReaderToString(val != null ? new InputStreamReader(length >= 0L ? new InputStreamFilter(val, length) : val, CHARSET_ISO_8859_1) : null, -1L);
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        String value = this._getValueAsString(controller, dataPart);
        return value != null ? new ByteArrayInputStream(value.getBytes()) : null;
    }

    @Override
    public Object setBinaryStream(InputStream val, long length) throws SQLException {
        return this._transReaderToString(val != null ? new InputStreamReader(length >= 0L ? new InputStreamFilter(val, length) : val) : null, -1L);
    }

    protected String _getValueAsString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : dataPart.getValueAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date _getDate(String value, Calendar cal) throws IllegalArgumentException {
        int dayOfMonth;
        int month;
        int year;
        Date date = Date.valueOf(value);
        if (cal == null) {
            return date;
        }
        Calendar calendar = AbstractDateTimeTranslator.CALENDAR;
        synchronized (calendar) {
            AbstractDateTimeTranslator.CALENDAR.setTime(date);
            year = AbstractDateTimeTranslator.CALENDAR.get(1);
            month = AbstractDateTimeTranslator.CALENDAR.get(2);
            dayOfMonth = AbstractDateTimeTranslator.CALENDAR.get(5);
        }
        cal.clear();
        cal.set(year, month, dayOfMonth);
        date.setTime(cal.getTimeInMillis());
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Time _getTime(String value, Calendar cal) throws IllegalArgumentException {
        int second;
        int minute;
        int hourOfDay;
        Time time = new Time(AbstractDateTimeTranslator._normalizeTimeMilliseconds(Time.valueOf(value).getTime()));
        if (cal == null) {
            return time;
        }
        Calendar calendar = AbstractDateTimeTranslator.CALENDAR;
        synchronized (calendar) {
            AbstractDateTimeTranslator.CALENDAR.setTime(time);
            hourOfDay = AbstractDateTimeTranslator.CALENDAR.get(11);
            minute = AbstractDateTimeTranslator.CALENDAR.get(12);
            second = AbstractDateTimeTranslator.CALENDAR.get(13);
        }
        cal.clear();
        cal.set(11, hourOfDay);
        cal.set(12, minute);
        cal.set(13, second);
        time.setTime(AbstractDateTimeTranslator._normalizeTimeMilliseconds(cal.getTimeInMillis()));
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timestamp _getTimestamp(String value, Calendar cal) throws IllegalArgumentException {
        int second;
        int minute;
        int hourOfDay;
        int dayOfMonth;
        int month;
        int year;
        Timestamp timestamp = Timestamp.valueOf(value);
        if (cal == null) {
            return timestamp;
        }
        Calendar calendar = AbstractDateTimeTranslator.CALENDAR;
        synchronized (calendar) {
            AbstractDateTimeTranslator.CALENDAR.setTime(timestamp);
            year = AbstractDateTimeTranslator.CALENDAR.get(1);
            month = AbstractDateTimeTranslator.CALENDAR.get(2);
            dayOfMonth = AbstractDateTimeTranslator.CALENDAR.get(5);
            hourOfDay = AbstractDateTimeTranslator.CALENDAR.get(11);
            minute = AbstractDateTimeTranslator.CALENDAR.get(12);
            second = AbstractDateTimeTranslator.CALENDAR.get(13);
        }
        int nanos = timestamp.getNanos();
        cal.clear();
        cal.set(year, month, dayOfMonth, hourOfDay, minute, second);
        timestamp.setTime(cal.getTimeInMillis());
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

