/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractNumericTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

class BooleanTranslator
extends AbstractNumericTranslator {
    protected BooleanTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    public int getColumnDisplaySize() {
        return 5;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : Boolean.valueOf(this._getValueAsBoolean(controller, dataPart, false));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true) ? (byte)1 : 0;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true) ? (short)1 : 0;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true) ? 1 : 0;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true) ? 1L : 0L;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true) ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true) ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : (this._getValueAsBoolean(controller, dataPart, false) ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : String.valueOf(this._getValueAsBoolean(controller, dataPart, false));
    }

    private boolean _getValueAsBoolean(SQLParamController controller, HDataPart dataPart, boolean doNullCheck) throws SQLException {
        return doNullCheck && dataPart.isNull(controller) ? false : dataPart.getValueAsBoolean();
    }
}

