/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractGetval;
import com.sap.db.jdbc.translators.AbstractLobTranslator;
import com.sap.db.jdbc.translators.GetvalBlob;
import com.sap.db.jdbc.translators.InputStreamFilter;
import com.sap.db.jdbc.translators.ReaderFilter;
import com.sap.db.jdbc.translators.ReaderInputStream;
import com.sap.db.jdbc.translators.SQLParamController;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Set;

class BlobTranslator
extends AbstractLobTranslator {
    protected BlobTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    protected AbstractGetval _getLob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        return new GetvalBlob(controller, dataPart, this._outputFieldPos, this._length);
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transBytesToBlob(val != null ? val.getBytes() : null);
    }

    @Override
    public Object setBytes(byte[] val) throws SQLException {
        return this._transBytesToBlob(val);
    }

    @Override
    public Object setCharacterStream(Reader val, long length) throws SQLException {
        return this._transInputStreamToBlob(val != null ? new ReaderInputStream(length >= 0L ? new ReaderFilter(val, length) : val, 4096) : null, -1L);
    }

    @Override
    public Object setAsciiStream(InputStream val, long length) throws SQLException {
        return this._transInputStreamToBlob(val != null ? new ReaderInputStream(new InputStreamReader(length >= 0L ? new InputStreamFilter(val, length) : val, CHARSET_ISO_8859_1), 4096) : null, -1L);
    }

    @Override
    public Object setBinaryStream(InputStream val, long length) throws SQLException {
        return this._transInputStreamToBlob(val, length);
    }

    @Override
    public Blob getBlob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        AbstractGetval getval = this._getLob(controller, dataPart);
        return getval != null ? (Blob)((Object)getval) : null;
    }

    @Override
    public Object setBlob(Blob blob) throws SQLException {
        return this._transBlobToBlob(blob);
    }
}

