/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.InputStreamFilter;
import com.sap.db.jdbc.translators.ReaderFilter;
import com.sap.db.jdbc.translators.ReaderInputStream;
import com.sap.db.jdbc.translators.SQLParamController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Set;

class BinaryTranslator
extends AbstractTranslator {
    protected BinaryTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    protected Object _transSpecific(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return this.setBytes((byte[])obj);
        }
        return null;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null && bytes.length > 0 ? bytes[0] : (byte)0;
    }

    @Override
    public Object setByte(byte val) throws SQLException {
        return this._transByteToBinary(val);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null ? new String(bytes) : null;
    }

    @Override
    public Object setString(String val) throws SQLException {
        return this._transBytesToBinary(val != null ? val.getBytes() : null);
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    @Override
    public Object setBytes(byte[] val) throws SQLException {
        return this._transBytesToBinary(val);
    }

    @Override
    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null ? new StringReader(new String(bytes)) : null;
    }

    @Override
    public Object setCharacterStream(Reader val, long length) throws SQLException {
        return this._transInputStreamToBinary(val != null ? new ReaderInputStream(length >= 0L ? new ReaderFilter(val, length) : val, 256) : null, -1L);
    }

    @Override
    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null ? new ByteArrayInputStream(new String(bytes).getBytes(CHARSET_ISO_8859_1)) : null;
    }

    @Override
    public Object setAsciiStream(InputStream val, long length) throws SQLException {
        return this._transInputStreamToBinary(val != null ? new ReaderInputStream(new InputStreamReader(length >= 0L ? new InputStreamFilter(val, length) : val, CHARSET_ISO_8859_1), 256) : null, -1L);
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public Object setBinaryStream(InputStream val, long length) throws SQLException {
        return this._transInputStreamToBinary(val, length);
    }

    private byte[] _getValueAsByteArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : dataPart.getValueAsBytes();
    }
}

