/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ArraySapDB;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractTranslator;
import com.sap.db.jdbc.translators.DataFormatDescription;
import com.sap.db.jdbc.translators.SQLParamController;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Set;

class ArrayTranslator
extends AbstractTranslator {
    private final DataType _elementType;
    private final AbstractTranslator _elementTranslator;

    protected ArrayTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel, DataType elementType, AbstractTranslator elementTranslator) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
        this._elementType = elementType;
        this._elementTranslator = elementTranslator;
    }

    @Override
    protected Object _transSpecific(Object obj) throws SQLException {
        return null;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsArray(controller, dataPart);
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.lang.String");
    }

    @Override
    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsByteArray(controller, dataPart);
    }

    @Override
    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] bytes = this._getValueAsByteArray(controller, dataPart);
        return bytes != null ? new ByteArrayInputStream(bytes) : null;
    }

    @Override
    public Array getArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsArray(controller, dataPart);
    }

    private byte[] _getValueAsByteArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return dataPart.isNull(controller) ? null : dataPart.getBytes(this._outputFieldPos, this._length);
    }

    private Array _getValueAsArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        if (dataPart.isNull(controller)) {
            return null;
        }
        int elementCount = dataPart.getValueAsInt();
        Object[] elements = ArraySapDB.newArray(this._elementType, elementCount);
        HDataPart data = HDataPart.createArrayPart(dataPart, this._outputFieldPos, this._elementTranslator);
        int n = elementCount;
        block14: for (int i = 0; i < n; ++i) {
            data.moveToField(i + 1);
            switch (this._elementType) {
                case BOOLEAN: {
                    Comparable<Boolean> element = this._elementTranslator.getBoolean(controller, data);
                    elements[i] = controller.wasNullOrSpecialNull() ? null : element;
                    continue block14;
                }
                case TINYINT: 
                case SMALLINT: {
                    Comparable<Boolean> element = this._elementTranslator.getShort(controller, data);
                    elements[i] = controller.wasNullOrSpecialNull() ? null : element;
                    continue block14;
                }
                case INT: {
                    Comparable<Boolean> element = this._elementTranslator.getInt(controller, data);
                    elements[i] = controller.wasNullOrSpecialNull() ? null : element;
                    continue block14;
                }
                case BIGINT: {
                    Comparable<Boolean> element = this._elementTranslator.getLong(controller, data);
                    elements[i] = controller.wasNullOrSpecialNull() ? null : element;
                    continue block14;
                }
                case REAL: {
                    Comparable<Boolean> element = Float.valueOf(this._elementTranslator.getFloat(controller, data));
                    elements[i] = controller.wasNullOrSpecialNull() ? null : element;
                    continue block14;
                }
                case DOUBLE: {
                    Comparable<Boolean> element = this._elementTranslator.getDouble(controller, data);
                    elements[i] = controller.wasNullOrSpecialNull() ? null : element;
                    continue block14;
                }
                case DECIMAL: {
                    elements[i] = this._elementTranslator.getBigDecimal(controller, data);
                    continue block14;
                }
                case DATE: 
                case DAYDATE: {
                    elements[i] = this._elementTranslator.getDate(controller, data, null);
                    continue block14;
                }
                case TIME: 
                case SECONDTIME: {
                    elements[i] = this._elementTranslator.getTime(controller, data, null);
                    continue block14;
                }
                case TIMESTAMP: 
                case SECONDDATE: 
                case LONGDATE: {
                    elements[i] = this._elementTranslator.getTimestamp(controller, data, null);
                    continue block14;
                }
                case CHAR: 
                case VARCHAR1: 
                case NCHAR: 
                case NVARCHAR: 
                case STRING: 
                case NSTRING: 
                case VARCHAR2: 
                case ALPHANUM: {
                    elements[i] = this._elementTranslator.getString(controller, data);
                    continue block14;
                }
                case BINARY: 
                case VARBINARY: 
                case BSTRING: {
                    elements[i] = this._elementTranslator.getBytes(controller, data);
                    continue block14;
                }
                default: {
                    throw SQLExceptionSapDB.newInstance("error.method.unsupported", "ArrayTranslator", this._elementType.getDisplayName() + " as element data type of array");
                }
            }
        }
        controller.setNullIndicator(DataFormatDescription.NullIndicator.NOT_NULL);
        return new ArraySapDB(this._connection, this._elementType, elements);
    }
}

