/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.CharacterTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.util.Cesu8Utils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

class AlphanumTranslator
extends CharacterTranslator {
    private static final int ALPHANUM_LENGTH_MASK = 127;
    private static final int ALPHANUM_PURELY_NUMERIC = 128;
    private static final String ZEROS_127;

    protected AlphanumTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    protected int _putNull(HDataPart dataPart) {
        return dataPart.addNull(DataType.CHAR);
    }

    @Override
    protected String _getValueAsString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        int datalen;
        int alphalen;
        if (dataPart.isNull(controller)) {
            return null;
        }
        byte[] packet = dataPart.getRawPacketArray();
        int offset = dataPart.getNonNullDataOffset();
        int length = dataPart.getNonNullDataLength();
        int flags = packet[offset];
        String result = "";
        if (flags < 0) {
            flags += 256;
        }
        String value = Cesu8Utils.getString(packet, offset + 1, length - 1);
        if ((flags & 0x80) > 0 && (alphalen = flags & 0x7F) > (datalen = value.length())) {
            int zerolen = alphalen < datalen ? 0 : alphalen - datalen;
            result = ZEROS_127.substring(0, zerolen);
        }
        result = result + value;
        return result;
    }

    static {
        char[] chars = new char[127];
        Arrays.fill(chars, '0');
        ZEROS_127 = new String(chars);
    }
}

