/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractPutval;
import com.sap.db.jdbc.translators.AlphanumTranslator;
import com.sap.db.jdbc.translators.ArrayTranslator;
import com.sap.db.jdbc.translators.BigIntTranslator;
import com.sap.db.jdbc.translators.BinaryTranslator;
import com.sap.db.jdbc.translators.BlobTranslator;
import com.sap.db.jdbc.translators.BooleanTranslator;
import com.sap.db.jdbc.translators.CharacterTranslator;
import com.sap.db.jdbc.translators.ClobTranslator;
import com.sap.db.jdbc.translators.DateTranslator;
import com.sap.db.jdbc.translators.DayDateTranslator;
import com.sap.db.jdbc.translators.DecimalTranslator;
import com.sap.db.jdbc.translators.DoubleTranslator;
import com.sap.db.jdbc.translators.GetvalBlob;
import com.sap.db.jdbc.translators.GetvalClob;
import com.sap.db.jdbc.translators.IntegerTranslator;
import com.sap.db.jdbc.translators.LongDateTranslator;
import com.sap.db.jdbc.translators.PutvalBlob;
import com.sap.db.jdbc.translators.PutvalClob;
import com.sap.db.jdbc.translators.RealTranslator;
import com.sap.db.jdbc.translators.SQLParamController;
import com.sap.db.jdbc.translators.SecondDateTranslator;
import com.sap.db.jdbc.translators.SecondTimeTranslator;
import com.sap.db.jdbc.translators.SmallIntTranslator;
import com.sap.db.jdbc.translators.SpatialTranslator;
import com.sap.db.jdbc.translators.TimeTranslator;
import com.sap.db.jdbc.translators.TimestampTranslator;
import com.sap.db.jdbc.translators.TinyIntTranslator;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;

public abstract class AbstractTranslator {
    protected static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    protected static final int BUFFER_SIZE = 256;
    protected static final int BUFFER_SIZE_LOB = 4096;
    private static final int DATE_NULL = 32768;
    private static final int TIME_NULL = 128;
    protected final ConnectionSapDB _connection;
    protected final Set<ParameterOption> _parameterOptions;
    protected final ParameterMode _parameterMode;
    protected final DataType _dataType;
    protected final int _index;
    protected final int _inputFieldPos;
    protected final int _outputFieldPos;
    protected final int _length;
    protected final String _schemaName;
    protected final String _tableName;
    protected final String _columnName;
    protected final String _columnLabel;
    protected final DataFormatVersion _dataFormatVersion;
    protected final boolean _emptyTimestampIsNull;

    public static AbstractTranslator newInstance(ConnectionSapDB conn, Set<ParameterOption> parmOptions, ParameterMode parmMode, DataType dataType, int index, int inPos, int outPos, int len, int frac, String schemaName, String tableName, String columnName, String columnLabel) throws SQLException {
        AbstractTranslator translator;
        switch (dataType) {
            case BOOLEAN: {
                translator = new BooleanTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case TINYINT: {
                translator = new TinyIntTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case SMALLINT: {
                translator = new SmallIntTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case INT: {
                translator = new IntegerTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case BIGINT: {
                translator = new BigIntTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case REAL: {
                translator = new RealTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DOUBLE: {
                translator = new DoubleTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DECIMAL: {
                translator = new DecimalTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, frac, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DATE: {
                translator = new DateTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case TIME: {
                translator = new TimeTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case TIMESTAMP: {
                translator = new TimestampTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case DAYDATE: {
                translator = new DayDateTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case SECONDTIME: {
                translator = new SecondTimeTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case SECONDDATE: {
                translator = new SecondDateTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case LONGDATE: {
                translator = new LongDateTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case CHAR: 
            case VARCHAR1: 
            case NCHAR: 
            case NVARCHAR: 
            case SHORTTEXT: 
            case VARCHAR2: 
            case STRING: 
            case NSTRING: {
                translator = new CharacterTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case ALPHANUM: {
                translator = new AlphanumTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case BSTRING: {
                translator = new BinaryTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case CLOB: 
            case NCLOB: 
            case TEXT: 
            case BINTEXT: 
            case LOCATOR: 
            case NLOCATOR: {
                translator = new ClobTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel, dataType != DataType.CLOB && dataType != DataType.LOCATOR);
                break;
            }
            case BLOB: 
            case BLOCATOR: {
                translator = new BlobTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case GEOMETRY: 
            case POINT: {
                translator = new SpatialTranslator(conn, parmOptions, parmMode, dataType, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel);
                break;
            }
            case ARRAY: {
                throw new AssertionError((Object)"ARRAY is not an element type");
            }
            default: {
                throw SQLExceptionSapDB.newInstance("error.notranslator", dataType.getDisplayName());
            }
        }
        AbstractTranslator result = parmOptions.contains((Object)ParameterOption.ArrayType) ? new ArrayTranslator(conn, parmOptions, parmMode, DataType.ARRAY, index, inPos, outPos, len, schemaName, tableName, columnName, columnLabel, dataType, translator) : translator;
        return result;
    }

    public static long getEmptyDayDateMilliseconds() {
        return -62135856000000L;
    }

    public static long getEmptySecondTimeMilliseconds() {
        return -62135769601000L;
    }

    public static long getEmptySecondDateMilliseconds() {
        return -62135769601000L;
    }

    public static long getEmptyLongDateMilliseconds() {
        return -62135769600001L;
    }

    public static int getEmptyLongDateNanoseconds() {
        return 999999900;
    }

    protected AbstractTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        this._connection = connection;
        this._parameterOptions = parameterOptions;
        this._parameterMode = parameterMode;
        this._dataType = dataType;
        this._index = index;
        this._inputFieldPos = inputFieldPos;
        this._outputFieldPos = outputFieldPos;
        this._length = length;
        this._schemaName = schemaName;
        this._tableName = tableName;
        this._columnName = columnName;
        this._columnLabel = columnLabel;
        this._dataFormatVersion = connection.getEngineFeatures().getDataFormatVersion2();
        this._emptyTimestampIsNull = connection.emptyTimestampIsNull();
    }

    protected abstract Object _transSpecific(Object var1) throws SQLException;

    public int isNullable() {
        int result = this._parameterOptions.contains((Object)ParameterOption.Mandatory) ? 0 : (this._parameterOptions.contains((Object)ParameterOption.Optional) ? 1 : 2);
        return result;
    }

    public boolean isReadOnly() {
        return this._parameterOptions.contains((Object)ParameterOption.Readonly);
    }

    public boolean isAutoIncrement() {
        return this._parameterOptions.contains((Object)ParameterOption.Autoincrement);
    }

    public ParameterMode getParameterMode() {
        return this._parameterMode;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public int getColumnType() {
        return this._dataType.getSQLType();
    }

    public String getColumnTypeName() {
        return this._dataType.getSQLTypeName();
    }

    public String getColumnClassName() {
        return this._dataType.getJavaClassName();
    }

    public boolean isSigned() {
        return this._dataType.isSigned();
    }

    public boolean isLOB() {
        return this._dataType.isLOB();
    }

    public int getIndex() {
        return this._index;
    }

    public int getInputFieldPos() {
        return this._inputFieldPos;
    }

    public int getOutputFieldPos() {
        return this._outputFieldPos;
    }

    public int getColumnDisplaySize() {
        return this._length;
    }

    public int getPrecision() {
        return this._length;
    }

    public int getScale() {
        return 0;
    }

    public String getCatalogName() {
        return "";
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public String getColumnLabel() {
        return this._columnLabel;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean isSearchable() {
        return true;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDefinitelyWritable() {
        return false;
    }

    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.lang.Object");
    }

    public final Object setObject(Object val) throws SQLException {
        return this._transObject(val);
    }

    public boolean getBoolean(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("boolean");
    }

    public Object setBoolean(boolean val) throws SQLException {
        throw this._newSetException("boolean");
    }

    public byte getByte(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("byte");
    }

    public Object setByte(byte val) throws SQLException {
        throw this._newSetException("byte");
    }

    public short getShort(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("short");
    }

    public Object setShort(short val) throws SQLException {
        throw this._newSetException("short");
    }

    public int getInt(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("int");
    }

    public Object setInt(int val) throws SQLException {
        throw this._newSetException("int");
    }

    public long getLong(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("long");
    }

    public Object setLong(long val) throws SQLException {
        throw this._newSetException("long");
    }

    public float getFloat(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("float");
    }

    public Object setFloat(float val) throws SQLException {
        throw this._newSetException("float");
    }

    public double getDouble(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("double");
    }

    public Object setDouble(double val) throws SQLException {
        throw this._newSetException("double");
    }

    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.math.BigDecimal");
    }

    public Object setBigDecimal(BigDecimal val) throws SQLException {
        throw this._newSetException("java.math.BigDecimal");
    }

    public Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        throw this._newGetException("java.sql.Date");
    }

    public Object setDate(Date val, Calendar cal) throws SQLException {
        throw this._newSetException("java.sql.Date");
    }

    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        throw this._newGetException("java.sql.Time");
    }

    public Object setTime(Time val, Calendar cal) throws SQLException {
        throw this._newSetException("java.sql.Time");
    }

    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        throw this._newGetException("java.sql.Timestamp");
    }

    public Object setTimestamp(Timestamp val, Calendar cal) throws SQLException {
        throw this._newSetException("java.sql.Timestamp");
    }

    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        Object obj = this.getObject(controller, dataPart);
        return obj != null ? obj.toString() : null;
    }

    public Object setString(String val) throws SQLException {
        return this._transStringToString(val);
    }

    public byte[] getBytes(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("byte[]");
    }

    public Object setBytes(byte[] val) throws SQLException {
        throw this._newSetException("byte[]");
    }

    public Reader getCharacterStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.Reader");
    }

    public Object setCharacterStream(Reader val, long length) throws SQLException {
        throw this._newSetException("java.io.Reader");
    }

    public InputStream getAsciiStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.InputStream");
    }

    public Object setAsciiStream(InputStream val, long length) throws SQLException {
        throw this._newSetException("java.io.InputStream");
    }

    public final InputStream getUnicodeStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.InputStream");
    }

    public final Object setUnicodeStream(InputStream val) throws SQLException {
        throw this._newSetException("java.io.InputStream");
    }

    public InputStream getBinaryStream(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.io.InputStream");
    }

    public Object setBinaryStream(InputStream val, long length) throws SQLException {
        throw this._newSetException("java.io.InputStream");
    }

    public Clob getClob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.sql.Clob");
    }

    public Object setClob(Clob clob) throws SQLException {
        throw this._newSetException("java.sql.Clob");
    }

    public Blob getBlob(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.sql.Blob");
    }

    public Object setBlob(Blob blob) throws SQLException {
        throw this._newSetException("java.sql.Blob");
    }

    public Array getArray(SQLParamController controller, HDataPart dataPart) throws SQLException {
        throw this._newGetException("java.sql.Array");
    }

    public int getInputArgLength(Object data) {
        int len;
        if (!this._parameterMode.isInput()) {
            return 0;
        }
        if (data == null) {
            len = 1;
        } else if (data instanceof byte[]) {
            len = ((byte[])data).length;
        } else if (data instanceof AbstractPutval) {
            len = 10;
        } else {
            throw new AssertionError((Object)("Unexpected input argument type: " + data.getClass().getCanonicalName()));
        }
        return len;
    }

    public boolean putInputArg(HDataPart dataPart, Object data) {
        if (!this._parameterMode.isInput()) {
            return true;
        }
        int len = data == null ? this._putNull(dataPart) : this._putSpecific(dataPart, data);
        return len != -1;
    }

    public Object cloneObjectForBatch(Object object) {
        return object;
    }

    protected final SQLException _newParseException(String data, String requestedType) {
        return SQLExceptionSapDB.newInstance("error.conversion.data", data, requestedType != null ? requestedType : this.getColumnTypeName());
    }

    protected final SQLException _newGetException(String javaType) {
        return SQLExceptionSapDB.newInstance("error.conversion.sqljava", this.getColumnTypeName(), javaType);
    }

    protected final SQLException _newSetException(String javaType) {
        return SQLExceptionSapDB.newInstance("error.conversion.javasql", javaType, this.getColumnTypeName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final Object _transObject(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        Object result = this._transSpecific(obj);
        if (result != null) {
            return result;
        }
        if (obj instanceof String) {
            return this.setString((String)obj);
        }
        if (obj instanceof BigDecimal) {
            return this.setString(((BigDecimal)obj).toPlainString());
        }
        Class<?> clas = obj.getClass();
        if (!clas.isArray()) return this.setString(obj.toString());
        if (obj instanceof byte[]) {
            return this.setBytes((byte[])obj);
        }
        if (!(obj instanceof char[])) throw this._newSetException(clas.getName());
        return this.setString(new String((char[])obj));
    }

    protected final Object _transBooleanToBoolean(boolean val) throws SQLException {
        byte[] result = new byte[]{DataType.BOOLEAN.getTypeCode(), val ? (byte)2 : 0};
        return result;
    }

    protected final Object _transBooleanToTinyInt(boolean val) throws SQLException {
        byte[] result = new byte[]{DataType.TINYINT.getTypeCode(), val ? (byte)1 : 0};
        return result;
    }

    protected final Object _transByteToTinyInt(byte val) throws SQLException {
        byte[] result = new byte[2];
        result[0] = DataType.TINYINT.getTypeCode();
        ByteUtils.putByte(val, result, 1);
        return result;
    }

    protected final Object _transByteToSmallInt(byte val) throws SQLException {
        byte[] result = new byte[3];
        result[0] = DataType.SMALLINT.getTypeCode();
        ByteUtils.putShort(val, result, 1);
        return result;
    }

    protected final Object _transByteToBinary(byte val) throws SQLException {
        byte[] result = new byte[]{DataType.BINARY.getTypeCode(), 1, val};
        return result;
    }

    protected final Object _transShortToSmallInt(short val) throws SQLException {
        byte[] result = new byte[3];
        result[0] = DataType.SMALLINT.getTypeCode();
        ByteUtils.putShort(val, result, 1);
        return result;
    }

    protected final Object _transIntToInteger(int val) throws SQLException {
        byte[] result = new byte[5];
        result[0] = DataType.INT.getTypeCode();
        ByteUtils.putInt(val, result, 1);
        return result;
    }

    protected final Object _transLongToBigInt(long val) throws SQLException {
        byte[] result = new byte[9];
        result[0] = DataType.BIGINT.getTypeCode();
        ByteUtils.putLong(val, result, 1);
        return result;
    }

    protected final Object _transFloatToReal(float val) throws SQLException {
        byte[] result = new byte[5];
        result[0] = DataType.REAL.getTypeCode();
        ByteUtils.putFloat(val, result, 1);
        return result;
    }

    protected final Object _transDoubleToDouble(double val) throws SQLException {
        byte[] result = new byte[9];
        result[0] = DataType.DOUBLE.getTypeCode();
        ByteUtils.putDouble(val, result, 1);
        return result;
    }

    protected final Object _transBigDecimalToDecimal(BigDecimal val) throws SQLException {
        if (val == null) {
            return null;
        }
        byte[] result = new byte[17];
        result[0] = DataType.DECIMAL.getTypeCode();
        ByteUtils.putBigDecimal(val, result, 1);
        return result;
    }

    protected final Object _transUtilDateToDate(java.util.Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] result = new byte[5];
        short year = (short)(cal.get(1) | 0x8000);
        byte month = (byte)cal.get(2);
        byte day = (byte)cal.get(5);
        result[0] = DataType.DATE.getTypeCode();
        ByteUtils.putShort(year, result, 1);
        ByteUtils.putByte(month, result, 3);
        ByteUtils.putByte(day, result, 4);
        return result;
    }

    protected final Object _transUtilDateToTime(java.util.Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] result = new byte[5];
        byte hour = (byte)(cal.get(11) | 0x80);
        byte minute = (byte)cal.get(12);
        short milli = (short)(cal.get(13) * 1000);
        result[0] = DataType.TIME.getTypeCode();
        ByteUtils.putByte(hour, result, 1);
        ByteUtils.putByte(minute, result, 2);
        ByteUtils.putShort(milli, result, 3);
        return result;
    }

    protected final Object _transTimestampToTimestamp(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] result = new byte[9];
        short year = (short)(cal.get(1) | 0x8000);
        byte month = (byte)cal.get(2);
        byte day = (byte)cal.get(5);
        byte hour = (byte)(cal.get(11) | 0x80);
        byte minute = (byte)cal.get(12);
        short milli = (short)(cal.get(13) * 1000 + val.getNanos() / 1000000);
        result[0] = DataType.TIMESTAMP.getTypeCode();
        ByteUtils.putShort(year, result, 1);
        ByteUtils.putByte(month, result, 3);
        ByteUtils.putByte(day, result, 4);
        ByteUtils.putByte(hour, result, 5);
        ByteUtils.putByte(minute, result, 6);
        ByteUtils.putShort(milli, result, 7);
        return result;
    }

    protected final Object _transUtilDateToDayDate(java.util.Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        AbstractTranslator._validateYear(cal);
        byte[] value = new byte[5];
        TimeZone tz = cal.getTimeZone();
        long timeInMillis = cal.getTimeInMillis();
        int offset = tz.getOffset(timeInMillis);
        long ts = (timeInMillis + 62135769600000L + (long)offset) / 86400000L + 1L;
        value[0] = DataType.DAYDATE.getTypeCode();
        ByteUtils.putInt((int)ts, value, 1);
        return value;
    }

    protected final Object _transUtilDateToSecondTime(java.util.Date val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        byte[] value = new byte[5];
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        value[0] = DataType.SECONDTIME.getTypeCode();
        ByteUtils.putInt(hour * 60 * 60 + minute * 60 + second + 1, value, 1);
        return value;
    }

    protected final Object _transTimestampToSecondDate(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        AbstractTranslator._validateYear(cal);
        byte[] value = new byte[9];
        TimeZone tz = cal.getTimeZone();
        long timeInMillis = cal.getTimeInMillis();
        int offset = tz.getOffset(timeInMillis);
        long ts = (timeInMillis + 62135769600000L + (long)offset) / 1000L + 1L;
        value[0] = DataType.SECONDDATE.getTypeCode();
        ByteUtils.putLong(ts, value, 1);
        return value;
    }

    protected final Object _transTimestampToLongDate(Timestamp val, Calendar cal) throws SQLException {
        if (val == null) {
            return null;
        }
        cal.setTime(val);
        AbstractTranslator._validateYear(cal);
        byte[] value = new byte[9];
        TimeZone tz = cal.getTimeZone();
        long timeInMillis = cal.getTimeInMillis();
        int offset = tz.getOffset(timeInMillis);
        int nanos = val.getNanos() / 100;
        long ts = (timeInMillis + (62135769600000L + (long)offset)) / 1000L * 10000000L + (long)nanos + 1L;
        value[0] = DataType.LONGDATE.getTypeCode();
        ByteUtils.putLong(ts, value, 1);
        return value;
    }

    protected final Object _transStringToDate(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Date date = Date.valueOf(val);
            return this._transUtilDateToDate(date, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue", val);
        }
    }

    protected final Object _transStringToTime(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Time time = Time.valueOf(val);
            return this._transUtilDateToTime(time, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue", val);
        }
    }

    protected final Object _transStringToTimestamp(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(val);
            return this._transTimestampToTimestamp(timestamp, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            throw SQLExceptionSapDB.newInstance("error.invalid.argumentvalue", val);
        }
    }

    protected final Object _transStringToDayDate(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val.isEmpty() && !this._emptyTimestampIsNull) {
            return new byte[]{DataType.DAYDATE.getTypeCode(), 0, 0, 0, 0};
        }
        try {
            Date date = Date.valueOf(val);
            return this._transUtilDateToDayDate(date, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            return this._transStringToString(val);
        }
    }

    protected final Object _transStringToSecondTime(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val.isEmpty() && !this._emptyTimestampIsNull) {
            return new byte[]{DataType.SECONDTIME.getTypeCode(), 0, 0, 0, 0};
        }
        try {
            Time time = Time.valueOf(val);
            return this._transUtilDateToSecondTime(time, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            return this._transStringToString(val);
        }
    }

    protected final Object _transStringToSecondDate(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val.isEmpty() && !this._emptyTimestampIsNull) {
            return new byte[]{DataType.SECONDDATE.getTypeCode(), 0, 0, 0, 0, 0, 0, 0, 0};
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(val);
            return this._transTimestampToSecondDate(timestamp, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            return this._transStringToString(val);
        }
    }

    protected final Object _transStringToLongDate(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val.isEmpty() && !this._emptyTimestampIsNull) {
            return new byte[]{DataType.LONGDATE.getTypeCode(), 0, 0, 0, 0, 0, 0, 0, 0};
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(val);
            return this._transTimestampToLongDate(timestamp, Calendar.getInstance());
        }
        catch (IllegalArgumentException e) {
            return this._transStringToString(val);
        }
    }

    protected final Object _transStringToString(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        int len = Cesu8Utils.getByteLength(val);
        byte[] dst = AbstractTranslator._newBuffer(len);
        int off = AbstractTranslator._setTypeCodeAndLength(DataType.STRING.getTypeCode(), len, dst);
        Cesu8Utils.putBytes(val, dst, off);
        return dst;
    }

    protected final Object _transStringToClob(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        return new PutvalClob(val, this._inputFieldPos, null, -1);
    }

    protected final Object _transBytesToBinary(byte[] val) throws SQLException {
        if (val == null) {
            return null;
        }
        int len = val.length;
        byte[] dst = AbstractTranslator._newBuffer(len);
        int off = AbstractTranslator._setTypeCodeAndLength(DataType.BINARY.getTypeCode(), len, dst);
        ByteUtils.putBytes(val, dst, off);
        return dst;
    }

    protected final Object _transBytesToBlob(byte[] val) throws SQLException {
        if (val == null) {
            return null;
        }
        return new PutvalBlob(val, this._inputFieldPos, null, -1);
    }

    protected final Object _transReaderToString(Reader reader, long length) throws SQLException {
        if (reader == null || length == 0L) {
            return null;
        }
        if (length > Integer.MAX_VALUE) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", "Streams with size greater than Integer.MAX_VALUE are not supported");
        }
        try {
            String s;
            if (length == -1L) {
                int n;
                StringBuilder builder = new StringBuilder(256);
                char[] buf = new char[256];
                while ((n = reader.read(buf)) != -1) {
                    builder.append(buf, 0, n);
                }
                s = builder.toString();
            } else {
                char[] buf = new char[(int)length];
                int n = reader.read(buf);
                if (n == -1) {
                    n = 0;
                }
                s = new String(buf, 0, n);
            }
            return this._transStringToString(s);
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
    }

    protected final Object _transReaderToClob(Reader reader, long length) throws SQLException {
        if (reader == null) {
            return null;
        }
        return new PutvalClob(reader, length, this._inputFieldPos);
    }

    protected final Object _transInputStreamToBinary(InputStream stream, long length) throws SQLException {
        if (stream == null || length == 0L) {
            return null;
        }
        if (length > (long)this._length) {
            throw SQLExceptionSapDB.newInstance("error.valueoverflow", String.valueOf(this._inputFieldPos), String.valueOf(length), String.valueOf(this._length));
        }
        try {
            byte[] buf;
            if (length == -1L) {
                int n;
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                buf = new byte[256];
                while ((n = stream.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                buf = out.toByteArray();
            } else {
                buf = new byte[(int)length];
                int n = stream.read(buf);
                if (n == -1) {
                    n = 0;
                }
                if ((long)n != length) {
                    buf = Arrays.copyOfRange(buf, 0, n);
                }
            }
            return this._transBytesToBinary(buf);
        }
        catch (IOException ioex) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", ioex.getMessage());
        }
    }

    protected final Object _transInputStreamToBlob(InputStream stream, long length) throws SQLException {
        if (stream == null) {
            return null;
        }
        return new PutvalBlob(stream, length, this._inputFieldPos);
    }

    protected final Object _transClobToClob(Clob val) throws SQLException {
        if (val == null) {
            return null;
        }
        Reader reader = null;
        try {
            reader = val instanceof GetvalClob ? ((GetvalClob)val)._getCharacterStream() : val.getCharacterStream();
            Object object = this._transReaderToClob(reader, -1L);
            return object;
        }
        catch (SQLException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected final Object _transBlobToBlob(Blob val) throws SQLException {
        if (val == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = val instanceof GetvalBlob ? ((GetvalBlob)val)._getBinaryStream() : val.getBinaryStream();
            Object object = this._transInputStreamToBlob(stream, -1L);
            return object;
        }
        catch (SQLException e) {
            throw SQLExceptionSapDB.newInstance("error.stream.ioexception", e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected int _putNull(HDataPart dataPart) {
        return dataPart.addNull(this._dataType);
    }

    protected int _putSpecific(HDataPart dataPart, Object data) {
        return dataPart.addRawBytes((byte[])data);
    }

    private static void _validateYear(Calendar cal) throws SQLException {
        int year = cal.get(1);
        if (year < 1 || year > 9999) {
            throw SQLExceptionSapDB.newInstance("error.invalidyearfordate", String.valueOf(year));
        }
    }

    private static byte[] _newBuffer(int dataLen) {
        int bufLen = dataLen + 1;
        bufLen = dataLen <= 245 ? ++bufLen : (dataLen <= Short.MAX_VALUE ? (bufLen += 3) : (bufLen += 5));
        return new byte[bufLen];
    }

    private static int _setTypeCodeAndLength(byte typeCode, int dataLen, byte[] dst) {
        int off;
        dst[0] = typeCode;
        if (dataLen <= 245) {
            ByteUtils.putByte(dataLen, dst, 1);
            off = 2;
        } else if (dataLen <= Short.MAX_VALUE) {
            ByteUtils.putByte(246, dst, 1);
            ByteUtils.putShort(dataLen, dst, 2);
            off = 4;
        } else {
            ByteUtils.putByte(247, dst, 1);
            ByteUtils.putInt(dataLen, dst, 2);
            off = 6;
        }
        return off;
    }
}

