/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import java.sql.SQLException;

public abstract class AbstractPutval {
    protected final int _inputFieldPos;
    protected HDataPart _dataPart;
    protected int _descriptorOffset;
    protected State _state;
    private byte[] _locatorID;
    private boolean _isLocatorIDStale;

    protected AbstractPutval(int inputFieldPos) {
        this(inputFieldPos, null, -1);
    }

    protected AbstractPutval(int inputFieldPos, HDataPart dataPart, int descriptorOffset) {
        this._inputFieldPos = inputFieldPos;
        this._dataPart = dataPart;
        this._descriptorOffset = descriptorOffset;
        this._state = State.EXECUTE;
    }

    public abstract DataType getDataType();

    public abstract Object cloneForBatch();

    public abstract boolean atEnd();

    public abstract void transferStream(HDataPart var1) throws SQLException;

    public abstract void closeStream();

    public int getInputFieldPos() {
        return this._inputFieldPos;
    }

    public void setState(State state) {
        this._state = state;
    }

    public void setLocatorID(byte[] locatorID) {
        this._locatorID = locatorID;
        this._isLocatorIDStale = false;
    }

    public boolean isLocatorIDStale() {
        return this._isLocatorIDStale;
    }

    public void setLocatorIDStale() {
        this._isLocatorIDStale = true;
    }

    public int addDescriptor(HDataPart dataPart) {
        this._dataPart = dataPart;
        this._descriptorOffset = dataPart.getCurrentFieldOffset();
        return dataPart.addDescriptor(this._state, this.getDataType(), this._locatorID);
    }

    public static enum State {
        EXECUTE,
        WRITELOB;

    }
}

