/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataFormatVersion;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractTranslator;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Set;

abstract class AbstractNumericTranslator
extends AbstractTranslator {
    protected final int _fraction;

    protected AbstractNumericTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
        this._fraction = fraction;
    }

    @Override
    protected Object _transSpecific(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return this.setBoolean((Boolean)obj);
        }
        if (obj instanceof Byte) {
            return this.setByte((Byte)obj);
        }
        if (obj instanceof Short) {
            return this.setShort((Short)obj);
        }
        if (obj instanceof Integer) {
            return this.setInt((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.setLong((Long)obj);
        }
        if (obj instanceof Float) {
            return this.setFloat(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return this.setDouble((Double)obj);
        }
        if (obj instanceof BigDecimal) {
            return this.setBigDecimal((BigDecimal)obj);
        }
        return null;
    }

    @Override
    public int getScale() {
        return this._fraction;
    }

    @Override
    public Object setBoolean(boolean val) throws SQLException {
        return this._dataFormatVersion.getValue() >= DataFormatVersion.Level7.getValue() ? this._transBooleanToBoolean(val) : this._transBooleanToTinyInt(val);
    }

    @Override
    public Object setByte(byte val) throws SQLException {
        return this._transByteToSmallInt(val);
    }

    @Override
    public Object setShort(short val) throws SQLException {
        return this._transShortToSmallInt(val);
    }

    @Override
    public Object setInt(int val) throws SQLException {
        return this._transIntToInteger(val);
    }

    @Override
    public Object setLong(long val) throws SQLException {
        return this._transLongToBigInt(val);
    }

    @Override
    public Object setFloat(float val) throws SQLException {
        return this._transFloatToReal(val);
    }

    @Override
    public Object setDouble(double val) throws SQLException {
        return this._transDoubleToDouble(val);
    }

    @Override
    public Object setBigDecimal(BigDecimal val) throws SQLException {
        return this._transBigDecimalToDecimal(val);
    }

    @Override
    public Object setBytes(byte[] val) throws SQLException {
        return this._transBytesToBinary(val);
    }
}

