/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.exceptions.InternalReconnectException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.HReadLOBReplyPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbc.translators.SQLParamController;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.sql.SQLException;

abstract class AbstractGetval {
    protected final SQLParamController _controller;
    protected final HDataPart _dataPart;
    protected final int _outputFieldPos;
    protected final int _length;
    protected final Tracer _tracer;
    protected final long _charLength;
    protected final long _byteLength;
    private final ConnectionSapDB _connection;
    private final Session _session;
    private final ResultSetSapDB _resultSet;
    private final byte[] _locatorID;
    protected long _firstPosition;
    protected long _currentPosition;
    protected boolean _isLastChunk;
    protected ByteBuffer _byteBuffer;
    protected boolean _atEnd;

    protected AbstractGetval(SQLParamController controller, HDataPart dataPart, int outputFieldPos, int length) throws SQLException {
        this._controller = controller;
        this._dataPart = dataPart;
        this._outputFieldPos = outputFieldPos;
        this._length = length;
        this._connection = controller.getConnectionSapDB();
        this._session = controller.getSession(true, false);
        this._resultSet = controller.getResultSetSapDB();
        this._tracer = this._connection.getTracer();
        dataPart.moveToLOBField(outputFieldPos);
        this._isLastChunk = dataPart.getLOBIsLastChunk();
        this._charLength = dataPart.getLOBCharLength();
        this._byteLength = dataPart.getLOBByteLength();
        this._locatorID = dataPart.getLOBLocatorID();
        this._byteBuffer = dataPart.getLOBByteBuffer();
        this._currentPosition = 1L;
        this._firstPosition = 1L;
    }

    protected abstract long _length();

    protected abstract String _getString() throws SQLException;

    protected abstract byte[] _getBytes() throws SQLException;

    protected abstract Reader _getCharacterStream() throws SQLException;

    protected abstract InputStream _getAsciiStream() throws SQLException;

    protected abstract InputStream _getBinaryStream() throws SQLException;

    protected static SQLException _getUnsupportedMethodException(String className, String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, className);
    }

    protected TraceRecord _newTraceRecord(String className, String methodName) {
        return new TraceRecord(this._connection, null, this._resultSet, className, methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected void _changeBytePosition(long newPosition) throws SQLException {
        this._currentPosition = newPosition;
        if (this._byteLength == 0L) {
            return;
        }
        if (newPosition >= this._firstPosition && newPosition <= this._firstPosition + (long)this._byteBuffer.limit()) {
            this._byteBuffer.position((int)(newPosition - this._firstPosition));
        } else {
            this._atEnd = false;
            this._isLastChunk = false;
            this._nextChunk();
        }
    }

    protected void _nextChunk() throws SQLException {
        try {
            this._controller.assertControllerOpen();
            if (this._isLastChunk || this._atEnd) {
                this._atEnd = true;
                return;
            }
            this._connection.handleTransaction(this._session, false);
            HRequestPacket requestPacket = this._connection.getRequestPacket(this._session);
            requestPacket.initReadLOB(this._connection, this._session, this._locatorID, this._currentPosition);
            HReplyPacket replyPacket = this._connection.execute(this, this._session, requestPacket, new ConnectionSapDB.ExecuteFlag[0]);
            HReadLOBReplyPart readLOBReplyPart = replyPacket.findReadLOBReplyPart(0);
            if (readLOBReplyPart == null) {
                throw SQLExceptionSapDB.newInstance("error.longdata.expected", new String[0]);
            }
            this._isLastChunk = readLOBReplyPart.isLastChunk();
            this._byteBuffer = readLOBReplyPart.getByteBuffer();
            this._firstPosition = this._currentPosition;
        }
        catch (InternalReconnectException e) {
            throw SQLExceptionSapDB.newInstance("error.objectisclosed", this.toString());
        }
    }
}

