/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.translators;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.translators.AbstractTranslator;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;

abstract class AbstractDateTimeTranslator
extends AbstractTranslator {
    protected static final Calendar CALENDAR = Calendar.getInstance();
    protected static final TimeZone TIME_ZONE = CALENDAR.getTimeZone();
    protected static final long MILLISECONDS_PER_SECOND = 1000L;
    protected static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    protected static final long NANOSECONDS_PER_SECOND = 1000000000L;
    protected static final long SECONDS_PER_DAY = 86400L;
    protected static final long MILLISECONDS_PER_DAY = 86400000L;
    protected static final long NANOSECONDS_PER_DAY = 86400000000000L;
    protected static final long EPOCH_CONVERSION_DAYS = 719164L;
    protected static final long EPOCH_CONVERSION_MILLISECONDS = 62135769600000L;
    protected static final long ONE_DAY_BEFORE_HANA_EPOCH_MILLISECONDS = -62135856000000L;
    protected static final java.sql.Date ONE_DAY_BEFORE_HANA_EPOCH_DATE = new java.sql.Date(-62135856000000L);
    protected static final Time ONE_DAY_BEFORE_HANA_EPOCH_TIME = new Time(-62135856000000L);
    protected static final Timestamp ONE_DAY_BEFORE_HANA_EPOCH_TIMESTAMP = new Timestamp(-62135856000000L);
    protected static final long ONE_SECOND_BEFORE_HANA_EPOCH_MILLISECONDS = -62135769601000L;
    protected static final java.sql.Date ONE_SECOND_BEFORE_HANA_EPOCH_DATE = new java.sql.Date(-62135769601000L);
    protected static final Time ONE_SECOND_BEFORE_HANA_EPOCH_TIME = new Time(-62135769601000L);
    protected static final Timestamp ONE_SECOND_BEFORE_HANA_EPOCH_TIMESTAMP = new Timestamp(-62135769601000L);
    protected static final long HUNDRED_NANOSECONDS_BEFORE_HANA_EPOCH_MILLISECONDS = -62135769600001L;
    protected static final int HUNDRED_NANOSECONDS_BEFORE_HANA_EPOCH_NANOSECONDS = 999999900;
    protected static final Timestamp HUNDRED_NANOSECONDS_BEFORE_HANA_EPOCH_TIMESTAMP = new Timestamp(-62135769600001L);

    protected AbstractDateTimeTranslator(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, String schemaName, String tableName, String columnName, String columnLabel) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, schemaName, tableName, columnName, columnLabel);
    }

    @Override
    protected Object _transSpecific(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return this.setTimestamp((Timestamp)obj, Calendar.getInstance());
        }
        if (obj instanceof Time) {
            return this.setTime((Time)obj, Calendar.getInstance());
        }
        if (obj instanceof java.sql.Date) {
            return this.setDate((java.sql.Date)obj, Calendar.getInstance());
        }
        if (obj instanceof Date) {
            Date utilDate = (Date)obj;
            return this.setDate(new java.sql.Date(utilDate.getTime()), Calendar.getInstance());
        }
        if (obj instanceof String) {
            return this.setString((String)obj);
        }
        return null;
    }

    @Override
    public int getColumnDisplaySize() {
        return this.getPrecision();
    }

    protected static long _normalizeTimeMilliseconds(long ms) {
        if (ms < 0L) {
            return ms + 86400000L;
        }
        if (ms > 86400000L) {
            return ms - 86400000L;
        }
        return ms;
    }

    protected static String _formatTimestamp(Timestamp timestamp, boolean includeNanos) {
        if (timestamp == null) {
            return null;
        }
        String s = timestamp.toString();
        int idx = s.indexOf(".");
        if (idx == -1) {
            return s;
        }
        return includeNanos ? s.substring(0, idx) + String.format(".%09d", timestamp.getNanos()) : s.substring(0, idx);
    }

    static {
        HUNDRED_NANOSECONDS_BEFORE_HANA_EPOCH_TIMESTAMP.setNanos(999999900);
    }
}

