/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Tracer {
    public static final DummyTracer DUMMY = new DummyTracer();
    private static final Charset CHARSET_UTF_8 = Charset.forName("UTF-8");
    private static final String CURRENT_WRITE_POSITION = "<CURRENT WRITE POSITION>";
    private final PacketAnalyzer _packetAnalyzer = new PacketAnalyzer();
    private final TraceControl _traceControl;
    private String _traceFileName;
    private long _traceSize;
    private File _traceFile;
    private RandomAccessFile _log;
    private int _wrapCount;
    private Thread _lastThread;
    private boolean _isWritingHeader;

    public Tracer(TraceControl traceControl) {
        this._traceControl = traceControl;
    }

    public boolean on() {
        return this._traceControl.isTraceOn();
    }

    public boolean pon() {
        return this._traceControl.isPerformanceTraceOn();
    }

    public File getTraceFile() {
        if (this._traceFile != null) {
            return this._traceFile;
        }
        if (this._traceFileName == null || this._traceFileName.isEmpty()) {
            this._traceFileName = "jdbctrace.prt";
        }
        try {
            String fileName = FileUtils.getFileName(this._traceFileName);
            String fileExtension = FileUtils.getFileExtension(this._traceFileName);
            String directoryName = FileUtils.getDirectoryName(this._traceFileName);
            File directory = FileUtils.createDirectoryIfNecessary(directoryName);
            this._traceFile = File.createTempFile(fileName, fileExtension, directory);
            if (!this._traceFile.delete()) {
                this._traceFile = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._traceFile;
    }

    public boolean setTraceFileName(String traceFileName) {
        boolean wasNameChanged;
        boolean bl = wasNameChanged = !traceFileName.equals(this._traceFileName);
        if (!wasNameChanged) {
            return false;
        }
        this._traceFileName = traceFileName;
        this._traceFile = null;
        return true;
    }

    public boolean setTraceSize(String traceSize) {
        try {
            return this.setTraceSize(Long.parseLong(traceSize));
        }
        catch (NumberFormatException e) {
            return this.setTraceSize(Long.MAX_VALUE);
        }
    }

    public boolean setTraceSize(long traceSize) {
        if (traceSize < 8192L) {
            traceSize = 8192L;
        }
        if (traceSize == this._traceSize) {
            return false;
        }
        this._traceSize = traceSize;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        File traceFile = this.getTraceFile();
        if (traceFile == null) {
            return;
        }
        this.close();
        try {
            this._log = new RandomAccessFile(traceFile, "rw");
            this._wrapCount = 0;
            Tracer tracer = this;
            synchronized (tracer) {
                this._writeHeader();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void close() {
        if (this._log == null) {
            return;
        }
        try {
            this._log.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this._log = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMessage(String message) {
        if (this._log == null) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._writeln(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProperties(Map<String, String> properties, String message) {
        if (this._log == null) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            if (message != null) {
                this._writeln(message);
            }
            if (properties == null) {
                return;
            }
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                this._writeln(entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printThrowable(Throwable t, String message) {
        if (this._log == null) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._writeln("<-!\nTimestamp: " + new Timestamp(System.currentTimeMillis()));
            if (message != null) {
                this._writeln(message);
            }
            this._writeln(this._getStackTraceString(t));
            this._checkStopOnError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCurrentStackTrace(String message) {
        if (this._log == null) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            if (message != null) {
                this._writeln(message);
            }
            this._writeln("Stack trace:\n" + this._getStackTraceString(new Throwable()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCall(Object caller, String name, Object ... arguments) {
        if (this._log == null || !this._getTraceConfiguration().getTraceLevel().get(0)) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._writeln(caller + "." + name + "(" + this._getArgumentsString(arguments) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printResult(Object result) {
        if (this._log == null || !this._getTraceConfiguration().getTraceLevel().get(0)) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._writeln("=> " + result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printException(SQLException e) {
        if (this._log == null || !this._getTraceConfiguration().getTraceLevel().get(0)) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._writeln("<-!\nTimestamp: " + new Timestamp(System.currentTimeMillis()) + "\n" + this._getStackTraceString(e));
            this._checkStopOnError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printPacket(byte[] packet) {
        if (this._log == null || !this._getTraceConfiguration().getTraceLevel().get(1)) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._packetAnalyzer.parse(packet);
            this._writeln("<Packet " + this._packetAnalyzer.getDisplayPacketHeader() + ">");
            while (this._packetAnalyzer.nextSegment()) {
                this._writeln("  <Segment " + this._packetAnalyzer.getDisplaySegmentHeader() + ">");
                while (this._packetAnalyzer.nextPart()) {
                    this._writeln("    <Part " + this._packetAnalyzer.getDisplayPartHeader() + ">");
                    this._writeln("      <PartBuffer>");
                    this._writeln("        " + this._packetAnalyzer.getDisplayPartDataAsBinaryString());
                    this._writeln("        " + this._packetAnalyzer.getDisplayPartData());
                    this._writeln("      </PartBuffer>");
                    this._writeln("    </Part>");
                }
                this._writeln("  </Segment>");
            }
            this._writeln("</Packet>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDistribution(String message) {
        if (this._log == null || !this._getTraceConfiguration().getTraceLevel().get(2)) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            this._writeln("DISTRIBUTION: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDistributionState(ConnectionSapDB connection, String message) {
        if (this._log == null || !this._getTraceConfiguration().getTraceLevel().get(2)) {
            return;
        }
        SessionPool sessionPool = connection.getSessionPool();
        Session anchor = sessionPool.getAnchorSession();
        Session primary = sessionPool.getPrimarySession();
        if (anchor == null || primary == null) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._checkThreadChange();
            if (message != null) {
                this._writeln("DISTRIBUTION: " + message);
            }
            this._writeln("Connection@" + connection.hashCode() + " ConnectionID " + anchor.getConnectionID() + " SessionID " + anchor.getSessionID());
            for (Session session : sessionPool.getSessions().values()) {
                this._writeln("  |->" + session + (session == anchor ? " anchor" : "") + (session == primary ? " primary" : ""));
            }
        }
    }

    private TraceConfiguration _getTraceConfiguration() {
        return this._traceControl.getTraceConfiguration();
    }

    private void _writeln(String text) {
        try {
            this._log.write(text.getBytes(CHARSET_UTF_8));
            this._log.write(10);
            this._checkFileSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeHeader() {
        try {
            Set<ConnectionSapDB> connections;
            this._isWritingHeader = true;
            this._writeln("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><PRE><PLAINTEXT>");
            this._writeln("Java version: " + Driver.getJavaVersion());
            this._writeln("ClassLoader: " + Tracer.class.getClassLoader());
            this._writeln("Process ID: " + Driver.getProcessID());
            this._writeln("Driver version: " + Driver.getVersionInfo().toString() + "\n");
            if (this._wrapCount > 0) {
                this._writeln("Warning: Trace wrapped around " + this._wrapCount + " times.\n");
            }
            Set<ConnectionSapDB> set = connections = this._traceControl.isForOneConnection() && this._traceControl.getConnection() != null ? Collections.singleton(this._traceControl.getConnection()) : Driver.getConnections();
            if (!connections.isEmpty()) {
                this._writeln("Object tree begin:");
                for (ConnectionSapDB connectionSapDB : connections) {
                    this._writeln(connectionSapDB.toString());
                    for (StatementSapDB statement : connectionSapDB.getStatements()) {
                        this._writeln("\t" + statement.toString());
                    }
                }
                this._writeln("Object tree end:");
            }
        }
        finally {
            this._isWritingHeader = false;
        }
    }

    private void _checkFileSize() throws IOException {
        if (this._isWritingHeader || this._traceSize == Long.MAX_VALUE) {
            return;
        }
        long offset = this._log.getFilePointer();
        if (offset + (long)CURRENT_WRITE_POSITION.length() > this._traceSize) {
            while (offset < this._traceSize) {
                this._log.write(32);
                ++offset;
            }
            this._log.seek(0L);
            ++this._wrapCount;
            this._writeHeader();
            offset = this._log.getFilePointer();
        }
        this._log.writeBytes(CURRENT_WRITE_POSITION);
        this._log.seek(offset);
    }

    private void _checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread == this._lastThread) {
            return;
        }
        this._lastThread = thread;
        this._writeln("\n---- Thread " + Integer.toHexString(thread.hashCode()) + " " + thread.getName() + " Timestamp: " + new Timestamp(System.currentTimeMillis()));
    }

    private void _checkStopOnError(Throwable t) {
        int stopOnError = this._traceControl.getTraceConfiguration().getStopOnError();
        if (stopOnError != 0 && t instanceof SQLException && ((SQLException)t).getErrorCode() == stopOnError) {
            this.close();
        }
    }

    private String _getStackTraceString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private String _getArgumentsString(Object[] arguments) {
        switch (arguments.length) {
            case 0: {
                return "";
            }
            case 1: {
                return String.valueOf(arguments[0]);
            }
        }
        StringBuilder builder = new StringBuilder(64);
        for (Object arg : arguments) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(String.valueOf(arg));
        }
        return builder.toString();
    }

    public static class DummyTracer
    extends Tracer {
        private DummyTracer() {
            super(null);
        }

        @Override
        public boolean on() {
            return false;
        }

        @Override
        public boolean pon() {
            return false;
        }
    }
}

