/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TraceControl {
    private final boolean _isForOneConnection;
    private final AtomicBoolean _isTraceOn;
    private final AtomicBoolean _isPerformanceTraceOn;
    private final TraceConfiguration _traceConfiguration;
    private final Tracer _tracer;
    private ConnectionSapDB _connection;

    public TraceControl(boolean isForOneConnection) {
        this._isForOneConnection = isForOneConnection;
        this._isTraceOn = new AtomicBoolean(false);
        this._isPerformanceTraceOn = new AtomicBoolean(false);
        this._traceConfiguration = new TraceConfiguration();
        this._tracer = new Tracer(this);
        this._tracer.setTraceFileName(this._traceConfiguration.getTraceFileName());
        this._tracer.setTraceSize(this._traceConfiguration.getTraceSize());
    }

    public boolean isForOneConnection() {
        return this._isForOneConnection;
    }

    public boolean isTraceOn() {
        return this._isTraceOn.get();
    }

    public boolean isPerformanceTraceOn() {
        return this._isPerformanceTraceOn.get();
    }

    public TraceConfiguration getTraceConfiguration() {
        return this._traceConfiguration;
    }

    public Tracer getTracer() {
        return this._tracer;
    }

    public synchronized ConnectionSapDB getConnection() {
        return this._connection;
    }

    public synchronized void setConnection(ConnectionSapDB connection) {
        this._connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOn() {
        if (this._isTraceOn.get()) {
            return;
        }
        TraceControl traceControl = this;
        synchronized (traceControl) {
            this._isTraceOn.set(true);
            this._traceConfiguration.setTraceEnabled(true);
            this._tracer.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOff() {
        if (!this._isTraceOn.get()) {
            return;
        }
        TraceControl traceControl = this;
        synchronized (traceControl) {
            this._isTraceOn.set(false);
            this._traceConfiguration.setTraceEnabled(false);
            this._tracer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOn() {
        if (this._isPerformanceTraceOn.get()) {
            return;
        }
        TraceControl traceControl = this;
        synchronized (traceControl) {
            this._isPerformanceTraceOn.set(true);
            this._traceConfiguration.setPerformanceTraceEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOff() {
        if (!this._isPerformanceTraceOn.get()) {
            return;
        }
        TraceControl traceControl = this;
        synchronized (traceControl) {
            this._isPerformanceTraceOn.set(false);
            this._traceConfiguration.setPerformanceTraceEnabled(false);
            TraceRecordPublisher.getInstance().close();
        }
    }

    public synchronized void checkTraceSettings() {
        if (!this._traceConfiguration.hasTraceSettingsChanged()) {
            return;
        }
        this._traceConfiguration.loadTraceSettings();
        boolean wasTraceFileNameChanged = this._tracer.setTraceFileName(this._traceConfiguration.getTraceFileName());
        boolean wasTraceSizeChanged = this._tracer.setTraceSize(this._traceConfiguration.getTraceSize());
        if (this._traceConfiguration.isTraceEnabled()) {
            if (wasTraceFileNameChanged || wasTraceSizeChanged) {
                this.switchTraceOff();
            }
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void refreshTraceSettings() {
        if (this._traceConfiguration.isTraceEnabled()) {
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }
}

