/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

public enum TransactionFlag {
    RolledBack(0),
    Committed(1),
    NewIsolationLevel(2),
    DDLCommitModeChanged(3),
    WriteTransactionStarted(4),
    NoWriteTransactionStarted(5),
    SessionClosingTransactionError(6),
    ReadOnlyMode(7),
    Unknown(-1);

    private static final TransactionFlag[] VALUES;

    public static TransactionFlag decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return TransactionFlag.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private TransactionFlag(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = TransactionFlag.values();
    }
}

