/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

public enum SessionContextOption {
    PrimaryConnectionID(1),
    PrimaryHostName(2),
    PrimaryHostPortNumber(3),
    AnchorConnectionID(4),
    AnchorHostName(5),
    AnchorHostPortNumber(6),
    Unknown(-1);

    private static final SessionContextOption[] VALUES;

    public static SessionContextOption decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return SessionContextOption.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private SessionContextOption(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = SessionContextOption.values();
    }
}

