/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

public enum RangeComparisonFunction {
    GT(0),
    GE(1),
    EQ(2),
    NE(3),
    LE(4),
    LT(5),
    Unknown(-1);

    private static final RangeComparisonFunction[] VALUES;

    public static RangeComparisonFunction decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return RangeComparisonFunction.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private RangeComparisonFunction(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = RangeComparisonFunction.values();
    }
}

