/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum ParameterOption {
    Mandatory(1),
    Optional(2),
    Default(4),
    Escape_char(8),
    Readonly(16),
    Autoincrement(32),
    ArrayType(64);

    private static final ParameterOption[] VALUES;
    private final int _value;

    public static Set<ParameterOption> decode(int value) {
        EnumSet<ParameterOption> parameterOptions = EnumSet.noneOf(ParameterOption.class);
        for (ParameterOption parameterOption : VALUES) {
            if ((value & 1 << parameterOption.ordinal()) == 0) continue;
            parameterOptions.add(parameterOption);
        }
        return parameterOptions;
    }

    public static String getDisplayString(int value) {
        Set<ParameterOption> parameterOptions = ParameterOption.decode(value);
        return value + (parameterOptions.isEmpty() ? "(none)" : Arrays.toString(parameterOptions.toArray()));
    }

    private ParameterOption(int value) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    static {
        VALUES = ParameterOption.values();
    }
}

